/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.version;

import com.sun.javafx.runtime.VersionInfo;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;

public class VersionChecker {
    private static final String javaFXVersion;
    private static final String controlsFXSpecTitle;
    private static final String controlsFXSpecVersion;
    private static final String controlsFXImpVersion;
    private static final Package controlsFX;

    private VersionChecker() {
    }

    public static void doVersionCheck() {
        if (controlsFXSpecVersion == null) {
            return;
        }
        String[] splitSpecVersion = controlsFXSpecVersion.split("\\.");
        String[] splitJavaVersion = javaFXVersion.replace('-', '.').split("\\.");
        for (int i = 0; i < 3; ++i) {
            if (Integer.parseInt(splitJavaVersion[i]) >= Integer.parseInt(splitSpecVersion[i])) continue;
            throw new RuntimeException("ControlsFX Error: ControlsFX " + controlsFXImpVersion + " requires at least " + controlsFXSpecTitle);
        }
    }

    private static String getControlsFXSpecificationTitle() {
        try {
            return controlsFX.getSpecificationTitle();
        }
        catch (NullPointerException e) {
            try {
                Properties prop = new Properties();
                File file = new File("../controlsfx-build.properties");
                if (file.exists()) {
                    prop.load(new FileReader(file));
                    String version = prop.getProperty("controlsfx_specification_title");
                    if (version != null && !version.isEmpty()) {
                        return version;
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
    }

    private static String getControlsFXSpecificationVersion() {
        try {
            return controlsFX.getSpecificationVersion();
        }
        catch (NullPointerException e) {
            try {
                Properties prop = new Properties();
                File file = new File("../controlsfx-build.properties");
                if (file.exists()) {
                    prop.load(new FileReader(file));
                    String version = prop.getProperty("controlsfx_specification_version");
                    if (version != null && !version.isEmpty()) {
                        return version;
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
    }

    private static String getControlsFXImplementationVersion() {
        try {
            return controlsFX.getImplementationVersion();
        }
        catch (NullPointerException e) {
            try {
                Properties prop = new Properties();
                File file = new File("../controlsfx-build.properties");
                if (file.exists()) {
                    prop.load(new FileReader(file));
                    String version = prop.getProperty("controlsfx_version");
                    if (version != null && !version.isEmpty()) {
                        return version;
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
    }

    static {
        controlsFX = VersionChecker.class.getPackage();
        javaFXVersion = VersionInfo.getVersion();
        controlsFXSpecTitle = VersionChecker.getControlsFXSpecificationTitle();
        controlsFXSpecVersion = VersionChecker.getControlsFXSpecificationVersion();
        controlsFXImpVersion = VersionChecker.getControlsFXImplementationVersion();
    }
}

