/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import com.sun.javafx.scene.control.skin.VirtualScrollBar;
import impl.org.controlsfx.i18n.Localization;
import impl.org.controlsfx.spreadsheet.GridRow;
import impl.org.controlsfx.spreadsheet.GridViewSkin;
import impl.org.controlsfx.spreadsheet.HorizontalHeader;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.NodeOrientation;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import org.controlsfx.control.spreadsheet.Grid;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class VerticalHeader
extends StackPane {
    public static final int PICKER_SIZE = 16;
    private static final int DRAG_RECT_HEIGHT = 5;
    private static final String TABLE_ROW_KEY = "TableRow";
    private static final String PICKER_INDEX = "PickerIndex";
    private static final String TABLE_LABEL_KEY = "Label";
    public static final double DEFAULT_VERTICAL_HEADER_WIDTH = 30.0;
    private final SpreadsheetHandle handle;
    private final SpreadsheetView spreadsheetView;
    private double horizontalHeaderHeight;
    private final DoubleProperty verticalHeaderWidth = new SimpleDoubleProperty(30.0);
    private Rectangle clip;
    private ContextMenu blankContextMenu;
    private double lastY = 0.0;
    private static double dragAnchorY = 0.0;
    private final List<Rectangle> dragRects = new ArrayList<Rectangle>();
    private final List<Label> labelList = new ArrayList<Label>();
    private GridViewSkin skin;
    private boolean resizing = false;
    private final Stack<Label> pickerPile;
    private final Stack<Label> pickerUsed;
    private final EventHandler<MouseEvent> rectMousePressed = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent me) {
            if (me.getClickCount() != 2 || !me.isPrimaryButtonDown()) {
                dragAnchorY = me.getSceneY();
                VerticalHeader.this.resizing = true;
            }
            me.consume();
        }
    };
    private final EventHandler<MouseEvent> rectMouseDragged = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent me) {
            Rectangle rect = (Rectangle)me.getSource();
            GridRow row = (GridRow)((Object)rect.getProperties().get((Object)VerticalHeader.TABLE_ROW_KEY));
            Label label = (Label)rect.getProperties().get((Object)VerticalHeader.TABLE_LABEL_KEY);
            VerticalHeader.this.rowResizing(row, label, me);
            me.consume();
        }
    };
    private final EventHandler<MouseEvent> rectMouseReleased = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent me) {
            VerticalHeader.this.lastY = 0.0;
            VerticalHeader.this.resizing = false;
            VerticalHeader.this.requestLayout();
            me.consume();
        }
    };
    private final EventHandler<MouseEvent> pickerMouseEvent = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent mouseEvent) {
            Label picker = (Label)mouseEvent.getSource();
            VerticalHeader.this.spreadsheetView.getRowPickerCallback().call((Object)((Integer)picker.getProperties().get((Object)VerticalHeader.PICKER_INDEX)));
        }
    };
    private final InvalidationListener layout = new InvalidationListener(){

        public void invalidated(Observable arg0) {
            VerticalHeader.this.requestLayout();
        }
    };

    public VerticalHeader(SpreadsheetHandle handle) {
        this.handle = handle;
        this.spreadsheetView = handle.getView();
        this.pickerPile = new Stack();
        this.pickerUsed = new Stack();
    }

    void init(GridViewSkin skin, HorizontalHeader horizontalHeader) {
        this.skin = skin;
        horizontalHeader.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> arg0, Number oldHeight, Number newHeight) {
                VerticalHeader.this.horizontalHeaderHeight = newHeight.doubleValue();
                VerticalHeader.this.requestLayout();
            }
        });
        this.handle.getView().gridProperty().addListener((ChangeListener)new ChangeListener<Grid>(){

            public void changed(ObservableValue<? extends Grid> arg0, Grid arg1, Grid arg2) {
                VerticalHeader.this.requestLayout();
            }
        });
        this.clip = new Rectangle(this.getVerticalHeaderWidth(), this.snapSize(((TableView)skin.getSkinnable()).getHeight()));
        this.clip.relocate(this.snappedTopInset(), this.snappedLeftInset());
        this.clip.setSmooth(false);
        this.clip.heightProperty().bind((ObservableValue)((TableView)skin.getSkinnable()).heightProperty());
        this.clip.widthProperty().bind((ObservableValue)this.verticalHeaderWidth);
        this.setClip((Node)this.clip);
        this.spreadsheetView.showRowHeaderProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldValue, Boolean newValue) {
                VerticalHeader.this.requestLayout();
            }
        });
        this.spreadsheetView.showColumnHeaderProperty().addListener(this.layout);
        this.spreadsheetView.getFixedRows().addListener(this.layout);
        this.spreadsheetView.fixingRowsAllowedProperty().addListener(this.layout);
        this.spreadsheetView.heightProperty().addListener(this.layout);
        skin.getSelectedRows().addListener(this.layout);
        this.blankContextMenu = new ContextMenu();
    }

    public double getVerticalHeaderWidth() {
        return this.verticalHeaderWidth.get();
    }

    public double computeHeaderWidth() {
        double width = 0.0;
        if (!this.spreadsheetView.getRowPickers().isEmpty()) {
            width += 16.0;
        }
        if (this.spreadsheetView.isShowRowHeader()) {
            width += 30.0;
        }
        return width;
    }

    protected void layoutChildren() {
        if (this.resizing) {
            return;
        }
        if ((this.spreadsheetView.isShowRowHeader() || !this.spreadsheetView.getRowPickers().isEmpty()) && this.skin.getCellsSize() > 0) {
            VirtualScrollBar hbar;
            Label label;
            double x = this.snappedLeftInset();
            this.pickerPile.addAll(this.pickerUsed.subList(0, this.pickerUsed.size()));
            this.pickerUsed.clear();
            if (!this.spreadsheetView.getRowPickers().isEmpty()) {
                this.verticalHeaderWidth.setValue((Number)16);
                x += 16.0;
            } else {
                this.verticalHeaderWidth.setValue((Number)0);
            }
            if (this.spreadsheetView.isShowRowHeader()) {
                this.verticalHeaderWidth.setValue((Number)(this.getVerticalHeaderWidth() + 30.0));
            }
            this.getChildren().clear();
            int cellSize = this.skin.getCellsSize();
            int rowCount = 0;
            rowCount = this.addVisibleRows(rowCount, x, cellSize);
            if (this.spreadsheetView.isShowRowHeader()) {
                rowCount = this.addFixedRows(rowCount, x, cellSize);
            }
            if (this.spreadsheetView.showColumnHeaderProperty().get()) {
                label = this.getLabel(rowCount++);
                label.setText("");
                label.resize(this.getVerticalHeaderWidth(), this.horizontalHeaderHeight);
                label.layoutYProperty().unbind();
                label.setLayoutY(0.0);
                label.setLayoutX(0.0);
                label.getStyleClass().clear();
                label.setContextMenu(this.blankContextMenu);
                this.getChildren().add((Object)label);
            }
            if ((hbar = this.handle.getCellsViewSkin().getHBar()).isVisible()) {
                label = this.getLabel(rowCount++);
                label.setText("");
                label.resize(this.getVerticalHeaderWidth(), hbar.getHeight());
                label.layoutYProperty().unbind();
                label.relocate(this.snappedLeftInset(), this.getHeight() - hbar.getHeight());
                label.getStyleClass().clear();
                label.setContextMenu(this.blankContextMenu);
                this.getChildren().add((Object)label);
            }
        } else {
            this.getChildren().clear();
        }
    }

    private int addFixedRows(int rowCount, double x, int cellSize) {
        double spaceUsedByFixedRows = 0.0;
        if (!this.spreadsheetView.getFixedRows().isEmpty() && cellSize != 0) {
            for (int j = 0; j < this.spreadsheetView.getFixedRows().size(); ++j) {
                int rowIndex = (Integer)this.spreadsheetView.getFixedRows().get(j);
                if (!this.handle.getCellsViewSkin().getCurrentlyFixedRow().contains((Object)rowIndex)) break;
                Label label = this.getLabel(rowCount++);
                label.setText(this.getRowHeader(rowIndex));
                label.resize(this.getVerticalHeaderWidth(), this.skin.getRowHeight(rowIndex));
                label.setContextMenu(this.getRowContextMenu(rowIndex));
                label.layoutYProperty().unbind();
                if (this.spreadsheetView.showColumnHeaderProperty().get()) {
                    label.relocate(this.snappedLeftInset(), this.snappedTopInset() + this.horizontalHeaderHeight + spaceUsedByFixedRows);
                } else {
                    label.relocate(this.snappedLeftInset(), this.snappedTopInset() + spaceUsedByFixedRows);
                }
                ObservableList css = label.getStyleClass();
                if (this.skin.getSelectedRows().contains((Object)rowIndex)) {
                    css.addAll((Object[])new String[]{"selected"});
                } else {
                    css.removeAll((Object[])new String[]{"selected"});
                }
                css.addAll((Object[])new String[]{"fixed"});
                spaceUsedByFixedRows += this.skin.getRowHeight(rowIndex);
                this.getChildren().add((Object)label);
            }
        }
        return rowCount;
    }

    private int addVisibleRows(int rowCount, double x, int cellSize) {
        double y = this.snappedTopInset();
        if (this.spreadsheetView.showColumnHeaderProperty().get()) {
            y += this.horizontalHeaderHeight;
        }
        if (cellSize != 0) {
            y += this.skin.getRow(0).getLocalToParentTransform().getTy();
        }
        int modelRowCount = this.spreadsheetView.getGrid().getRowCount();
        int i = 0;
        GridRow row = this.skin.getRow(i);
        while (cellSize != 0 && row != null && row.getIndex() < modelRowCount) {
            int rowIndex = row.getIndex();
            if (this.spreadsheetView.getRowPickers().contains((Object)rowIndex)) {
                Label picker = this.getPicker(rowIndex);
                picker.resize(16.0, row.getHeight());
                picker.layoutYProperty().bind((ObservableValue)row.layoutYProperty().add(this.horizontalHeaderHeight));
                this.getChildren().add((Object)picker);
            }
            if (this.spreadsheetView.isShowRowHeader()) {
                Label label = this.getLabel(rowCount++);
                label.setText(this.getRowHeader(rowIndex));
                label.resize(30.0, row.getHeight());
                label.setLayoutX(x);
                label.layoutYProperty().bind((ObservableValue)row.layoutYProperty().add(this.horizontalHeaderHeight));
                label.setContextMenu(this.getRowContextMenu(rowIndex));
                this.getChildren().add((Object)label);
                ObservableList css = label.getStyleClass();
                if (this.skin.getSelectedRows().contains((Object)rowIndex)) {
                    css.addAll((Object[])new String[]{"selected"});
                } else {
                    css.removeAll((Object[])new String[]{"selected"});
                }
                if (this.spreadsheetView.getFixedRows().contains((Object)rowIndex)) {
                    css.addAll((Object[])new String[]{"fixed"});
                } else {
                    css.removeAll((Object[])new String[]{"fixed"});
                }
                y += row.getHeight();
                Rectangle dragRect = this.getDragRect(rowCount++);
                dragRect.getProperties().put((Object)TABLE_ROW_KEY, (Object)row);
                dragRect.getProperties().put((Object)TABLE_LABEL_KEY, (Object)label);
                dragRect.setWidth(label.getWidth());
                dragRect.relocate(this.snappedLeftInset() + x, y - 5.0);
                this.getChildren().add((Object)dragRect);
            }
            row = this.skin.getRow(++i);
        }
        return rowCount;
    }

    private void rowResizing(GridRow gridRow, Label label, MouseEvent me) {
        double draggedY = me.getSceneY() - dragAnchorY;
        if (gridRow.getEffectiveNodeOrientation() == NodeOrientation.RIGHT_TO_LEFT) {
            draggedY = -draggedY;
        }
        double delta = draggedY - this.lastY;
        Double newHeight = gridRow.getHeight() + delta;
        this.handle.getCellsViewSkin().rowHeightMap.put((Object)gridRow.getIndex(), (Object)newHeight);
        label.resize(this.getVerticalHeaderWidth(), newHeight.doubleValue());
        gridRow.setPrefHeight(newHeight);
        gridRow.requestLayout();
        this.lastY = draggedY;
    }

    private Label getLabel(int rowNumber) {
        if (this.labelList.isEmpty() || this.labelList.size() <= rowNumber) {
            final Label label = new Label();
            this.labelList.add(label);
            label.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent arg0) {
                    if (arg0.isPrimaryButtonDown()) {
                        try {
                            int row = Integer.parseInt(label.getText().substring(0, label.getText().length() - 1));
                            TableView.TableViewSelectionModel<ObservableList<SpreadsheetCell>> sm = VerticalHeader.this.spreadsheetView.getSelectionModel();
                            TableView.TableViewFocusModel fm = VerticalHeader.this.handle.getGridView().getFocusModel();
                            sm.clearAndSelect(row - 1, fm.getFocusedCell().getTableColumn());
                        }
                        catch (NumberFormatException | StringIndexOutOfBoundsException runtimeException) {
                            // empty catch block
                        }
                    }
                }
            });
            return label;
        }
        return this.labelList.get(rowNumber);
    }

    private Label getPicker(int rowNumber) {
        Label picker;
        if (this.pickerPile.isEmpty()) {
            picker = new Label();
            picker.getStyleClass().add((Object)"picker-label");
            picker.setOnMouseClicked(this.pickerMouseEvent);
        } else {
            picker = this.pickerPile.pop();
        }
        this.pickerUsed.push(picker);
        picker.getProperties().put((Object)PICKER_INDEX, (Object)rowNumber);
        return picker;
    }

    private Rectangle getDragRect(int rowNumber) {
        if (this.dragRects.isEmpty() || this.dragRects.size() <= rowNumber) {
            Rectangle rect = new Rectangle();
            rect.setWidth(this.getVerticalHeaderWidth());
            rect.setHeight(5.0);
            rect.setFill((Paint)Color.TRANSPARENT);
            rect.setSmooth(false);
            rect.setOnMousePressed(this.rectMousePressed);
            rect.setOnMouseDragged(this.rectMouseDragged);
            rect.setOnMouseReleased(this.rectMouseReleased);
            rect.setCursor(Cursor.V_RESIZE);
            this.dragRects.add(rect);
            return rect;
        }
        return this.dragRects.get(rowNumber);
    }

    private ContextMenu getRowContextMenu(final Integer row) {
        if (this.spreadsheetView.isRowFixable(row)) {
            ContextMenu contextMenu = new ContextMenu();
            MenuItem fixItem = new MenuItem(Localization.localize(Localization.asKey("spreadsheet.header.menu.fix")));
            fixItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent arg0) {
                    if (VerticalHeader.this.spreadsheetView.getFixedRows().contains((Object)row)) {
                        VerticalHeader.this.spreadsheetView.getFixedRows().remove((Object)row);
                    } else {
                        VerticalHeader.this.spreadsheetView.getFixedRows().add((Object)row);
                    }
                }
            });
            contextMenu.getItems().add((Object)fixItem);
            return contextMenu;
        }
        return this.blankContextMenu;
    }

    private String getRowHeader(int index) {
        return this.spreadsheetView.getGrid().getRowHeaders().size() > index ? (String)this.spreadsheetView.getGrid().getRowHeaders().get(index) : String.valueOf(index + 1);
    }
}

