/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import com.sun.javafx.scene.control.skin.NestedTableColumnHeader;
import com.sun.javafx.scene.control.skin.TableColumnHeader;
import com.sun.javafx.scene.control.skin.TableViewSkinBase;
import impl.org.controlsfx.spreadsheet.GridViewSkin;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TableColumnBase;
import javafx.scene.input.MouseEvent;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class HorizontalHeaderColumn
extends NestedTableColumnHeader {
    public HorizontalHeaderColumn(TableViewSkinBase<?, ?, ?, ?, ?, ?> skin, TableColumnBase<?, ?> tc) {
        super(skin, tc);
    }

    protected TableColumnHeader createTableColumnHeader(final TableColumnBase col) {
        final TableViewSkinBase tableViewSkin = this.getTableViewSkin();
        if (col.getColumns().isEmpty()) {
            TableColumnHeader columnHeader = new TableColumnHeader(tableViewSkin, col);
            columnHeader.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent arg0) {
                    if (arg0.getClickCount() == 2 && arg0.isPrimaryButtonDown()) {
                        ((GridViewSkin)tableViewSkin).resize(col);
                    }
                }
            });
            return columnHeader;
        }
        return new HorizontalHeaderColumn(this.getTableViewSkin(), col);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.layoutFixedColumns();
    }

    public void layoutFixedColumns() {
        SpreadsheetHandle handle = ((GridViewSkin)this.getTableViewSkin()).handle;
        SpreadsheetView spreadsheetView = handle.getView();
        if (handle.getCellsViewSkin() == null) {
            return;
        }
        double hbarValue = handle.getCellsViewSkin().getHBar().getValue();
        int labelHeight = (int)((Node)this.getChildren().get(0)).prefHeight(-1.0);
        double fixedColumnWidth = 0.0;
        double x = this.snappedLeftInset();
        int max = this.getColumnHeaders().size();
        for (int j = 0; j < max; ++j) {
            TableColumnHeader n = (TableColumnHeader)this.getColumnHeaders().get(j);
            double prefWidth = this.snapSize(n.prefWidth(-1.0));
            n.setPrefHeight(24.0);
            if (spreadsheetView.getFixedColumns().indexOf(spreadsheetView.getColumns().get(j)) != -1) {
                double tableCellX = 0.0;
                if (hbarValue + fixedColumnWidth > x) {
                    tableCellX = Math.abs(hbarValue - x + fixedColumnWidth);
                    n.toFront();
                    fixedColumnWidth += prefWidth;
                }
                n.relocate(x + tableCellX, (double)labelHeight + this.snappedTopInset());
            }
            x += prefWidth;
        }
    }
}

