/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import com.sun.javafx.scene.control.skin.NestedTableColumnHeader;
import com.sun.javafx.scene.control.skin.TableColumnHeader;
import com.sun.javafx.scene.control.skin.TableHeaderRow;
import com.sun.javafx.scene.control.skin.TableViewSkinBase;
import impl.org.controlsfx.spreadsheet.GridViewSkin;
import impl.org.controlsfx.spreadsheet.HorizontalHeaderColumn;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.scene.Node;
import javafx.scene.control.TableView;
import javafx.scene.input.MouseEvent;
import javafx.scene.shape.Rectangle;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetColumn;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class HorizontalHeader
extends TableHeaderRow {
    final GridViewSkin gridViewSkin;
    private boolean working = true;
    private final ChangeListener<Boolean> verticalHeaderListener = new ChangeListener<Boolean>(){

        public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
            HorizontalHeader.this.updateTableWidth();
        }
    };
    private final ChangeListener<Boolean> horizontalHeaderVisibilityListener = new ChangeListener<Boolean>(){

        public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
            HorizontalHeader.this.updateHorizontalHeaderVisibility(arg2);
        }
    };
    private final ListChangeListener<SpreadsheetColumn> fixedColumnsListener = new ListChangeListener<SpreadsheetColumn>(){

        public void onChanged(ListChangeListener.Change<? extends SpreadsheetColumn> change) {
            while (change.next()) {
                for (SpreadsheetColumn remitem : change.getRemoved()) {
                    HorizontalHeader.this.unfixColumn(remitem);
                }
                for (SpreadsheetColumn additem : change.getAddedSubList()) {
                    HorizontalHeader.this.fixColumn(additem);
                }
            }
            HorizontalHeader.this.updateHighlightSelection();
        }
    };
    private final InvalidationListener selectionListener = new InvalidationListener(){

        public void invalidated(Observable valueModel) {
            HorizontalHeader.this.updateHighlightSelection();
        }
    };

    public HorizontalHeader(GridViewSkin skin) {
        super((TableViewSkinBase)skin);
        this.gridViewSkin = skin;
    }

    public void init() {
        final SpreadsheetView spv = this.gridViewSkin.handle.getView();
        this.updateHorizontalHeaderVisibility(spv.isShowColumnHeader());
        spv.showRowHeaderProperty().addListener(this.verticalHeaderListener);
        spv.showColumnHeaderProperty().addListener(this.horizontalHeaderVisibilityListener);
        this.gridViewSkin.getSelectedColumns().addListener(this.selectionListener);
        spv.getFixedColumns().addListener(this.fixedColumnsListener);
        Platform.runLater(() -> {
            for (SpreadsheetColumn column : spv.getFixedColumns()) {
                this.fixColumn(column);
            }
            this.requestLayout();
            for (final TableColumnHeader i : this.getRootHeader().getColumnHeaders()) {
                EventHandler<MouseEvent> mouseEventHandler = new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent arg0) {
                        if (arg0.isPrimaryButtonDown()) {
                            TableView.TableViewSelectionModel<ObservableList<SpreadsheetCell>> sm = HorizontalHeader.this.gridViewSkin.handle.getView().getSelectionModel();
                            TableView.TableViewFocusModel fm = HorizontalHeader.this.gridViewSkin.handle.getGridView().getFocusModel();
                            sm.clearAndSelect(fm.getFocusedCell().getRow(), i.getTableColumn());
                        }
                    }
                };
                ((Node)i.getChildrenUnmodifiable().get(0)).setOnMousePressed((EventHandler)new WeakEventHandler((EventHandler)mouseEventHandler));
            }
        });
        this.getRootHeader().getColumnHeaders().addListener(new InvalidationListener(){

            public void invalidated(Observable o) {
                for (SpreadsheetColumn fixItem : spv.getFixedColumns()) {
                    HorizontalHeader.this.fixColumn(fixItem);
                }
                HorizontalHeader.this.updateHighlightSelection();
            }
        });
    }

    public HorizontalHeaderColumn getRootHeader() {
        return (HorizontalHeaderColumn)super.getRootHeader();
    }

    protected void updateTableWidth() {
        Rectangle clip;
        super.updateTableWidth();
        double padding = 0.0;
        if (this.working && this.gridViewSkin != null && this.gridViewSkin.spreadsheetView != null && this.gridViewSkin.spreadsheetView.showRowHeaderProperty().get()) {
            padding += this.gridViewSkin.verticalHeader.getVerticalHeaderWidth();
        }
        clip.setWidth((clip = (Rectangle)this.getClip()).getWidth() == 0.0 ? 0.0 : clip.getWidth() - padding);
    }

    protected void updateScrollX() {
        super.updateScrollX();
        this.gridViewSkin.horizontalPickers.updateScrollX();
        if (this.working) {
            this.requestLayout();
            this.getRootHeader().layoutFixedColumns();
        }
    }

    protected NestedTableColumnHeader createRootHeader() {
        return new HorizontalHeaderColumn(this.getTableSkin(), null);
    }

    private void fixColumn(SpreadsheetColumn column) {
        this.addStyleHeader(this.gridViewSkin.spreadsheetView.getColumns().indexOf((Object)column));
    }

    private void unfixColumn(SpreadsheetColumn column) {
        this.removeStyleHeader(this.gridViewSkin.spreadsheetView.getColumns().indexOf((Object)column));
    }

    private void removeStyleHeader(Integer i) {
        if (this.getRootHeader().getColumnHeaders().size() > i) {
            ((TableColumnHeader)this.getRootHeader().getColumnHeaders().get(i.intValue())).getStyleClass().removeAll((Object[])new String[]{"fixed"});
        }
    }

    private void addStyleHeader(Integer i) {
        if (this.getRootHeader().getColumnHeaders().size() > i) {
            ((TableColumnHeader)this.getRootHeader().getColumnHeaders().get(i.intValue())).getStyleClass().addAll((Object[])new String[]{"fixed"});
        }
    }

    private void updateHighlightSelection() {
        for (TableColumnHeader i : this.getRootHeader().getColumnHeaders()) {
            i.getStyleClass().removeAll((Object[])new String[]{"selected"});
        }
        ObservableList<Integer> selectedColumns = this.gridViewSkin.getSelectedColumns();
        for (Integer i : selectedColumns) {
            if (this.getRootHeader().getColumnHeaders().size() <= i) continue;
            ((TableColumnHeader)this.getRootHeader().getColumnHeaders().get(i.intValue())).getStyleClass().addAll((Object[])new String[]{"selected"});
        }
    }

    private void updateHorizontalHeaderVisibility(boolean visible) {
        this.working = visible;
        this.setManaged(this.working);
        if (!visible) {
            this.getStyleClass().add((Object)"invisible");
        } else {
            this.getStyleClass().remove((Object)"invisible");
            this.requestLayout();
            this.getRootHeader().layoutFixedColumns();
            this.updateHighlightSelection();
        }
    }
}

