/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import com.sun.javafx.scene.control.skin.VirtualFlow;
import com.sun.javafx.scene.control.skin.VirtualScrollBar;
import impl.org.controlsfx.spreadsheet.GridRow;
import impl.org.controlsfx.spreadsheet.GridViewSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.TableRow;
import javafx.scene.layout.Region;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

final class GridVirtualFlow<T extends IndexedCell<?>>
extends VirtualFlow<T> {
    private static final Comparator<GridRow> ROWCMP = new Comparator<GridRow>(){

        @Override
        public int compare(GridRow o1, GridRow o2) {
            int rhs;
            int lhs = o1.getIndex();
            return lhs < (rhs = o2.getIndex()) ? -1 : 1;
        }
    };
    private SpreadsheetView spreadSheetView;
    private final GridViewSkin gridViewSkin;
    private final ArrayList<T> myFixedCells = new ArrayList();
    private final List<Node> sheetChildren;
    private final ChangeListener<Number> hBarValueChangeListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> ov, Number t, Number t1) {
            ((GridVirtualFlow)GridVirtualFlow.this).gridViewSkin.hBarValue.clear();
        }
    };

    public GridVirtualFlow(GridViewSkin gridViewSkin) {
        this.gridViewSkin = gridViewSkin;
        ChangeListener<Number> listenerY = new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> ov, Number t, Number t1) {
                GridVirtualFlow.this.layoutTotal();
            }
        };
        this.getVbar().valueProperty().addListener((ChangeListener)listenerY);
        this.getHbar().valueProperty().addListener(this.hBarValueChangeListener);
        this.widthProperty().addListener(this.hBarValueChangeListener);
        this.getHbar().setUnitIncrement(10.0);
        this.sheetChildren = this.findSheetChildren();
    }

    private List<Node> findSheetChildren() {
        Region region;
        if (!this.getChildren().isEmpty() && this.getChildren().get(0) instanceof Region && !(region = (Region)this.getChildren().get(0)).getChildrenUnmodifiable().isEmpty() && region.getChildrenUnmodifiable().get(0) instanceof Group) {
            return ((Group)region.getChildrenUnmodifiable().get(0)).getChildren();
        }
        return new ArrayList<Node>();
    }

    public void init(SpreadsheetView spv) {
        this.spreadSheetView = spv;
        spv.getFixedRows().addListener((ListChangeListener)new ListChangeListener<Integer>(){

            public void onChanged(ListChangeListener.Change<? extends Integer> arg0) {
                while (arg0.next()) {
                    if (!arg0.wasRemoved()) continue;
                    List list = arg0.getRemoved();
                    block1: for (Integer i : list) {
                        for (IndexedCell cell : GridVirtualFlow.this.myFixedCells) {
                            if (cell.getIndex() != i.intValue()) continue;
                            cell.setManaged(false);
                            cell.setVisible(false);
                            GridVirtualFlow.this.myFixedCells.remove(cell);
                            continue block1;
                        }
                    }
                }
            }
        });
    }

    public void show(int index) {
        super.show(index);
        this.layoutTotal();
        this.layoutFixedRows();
    }

    public void scrollTo(int index) {
        if (!this.getCells().isEmpty() && this.spreadSheetView.getFixedRows().size() > 0) {
            for (double offset = this.gridViewSkin.getFixedRowHeight(); offset >= 0.0 && index > 0; offset -= this.spreadSheetView.getGrid().getRowHeight(--index)) {
            }
        }
        super.scrollTo(index);
        this.layoutTotal();
        this.layoutFixedRows();
    }

    public double adjustPixels(double delta) {
        double returnValue = super.adjustPixels(delta);
        this.layoutTotal();
        this.layoutFixedRows();
        return returnValue;
    }

    protected void layoutChildren() {
        if (this.spreadSheetView != null && (this.spreadSheetView.getEditingCell() == null || this.spreadSheetView.getEditingCell().getRow() == -1)) {
            this.sortRows();
            super.layoutChildren();
            this.layoutTotal();
            this.layoutFixedRows();
        }
    }

    protected void layoutTotal() {
        this.sortRows();
        if (this.getCells().isEmpty()) {
            this.reconfigureCells();
        }
        for (GridRow cell : this.getCells()) {
            if (cell == null || this.gridViewSkin.hBarValue.get(cell.getIndex()) && !this.gridViewSkin.rowToLayout.get(cell.getIndex())) continue;
            cell.requestLayout();
        }
    }

    protected VirtualScrollBar getVerticalBar() {
        return this.getVbar();
    }

    protected VirtualScrollBar getHorizontalBar() {
        return this.getHbar();
    }

    protected List<T> getCells() {
        return super.getCells();
    }

    private void layoutFixedRows() {
        if (this.spreadSheetView.getFixedRows().size() > 0 && this.getFirstVisibleCellWithinViewPort() != null) {
            this.sortRows();
            Object cell = null;
            block0: for (int i = this.spreadSheetView.getFixedRows().size() - 1; i >= 0; --i) {
                IndexedCell virtualFlowCells;
                Integer fixedRowIndex = (Integer)this.spreadSheetView.getFixedRows().get(i);
                IndexedCell lastCell = this.getLastVisibleCellWithinViewPort();
                if (lastCell != null && fixedRowIndex > lastCell.getIndex()) {
                    if (cell == null) continue;
                    cell.setVisible(false);
                    cell.setManaged(false);
                    continue;
                }
                Iterator<T> iterator = this.getCells().iterator();
                while (iterator.hasNext() && (virtualFlowCells = (IndexedCell)iterator.next()).getIndex() <= fixedRowIndex) {
                    if (virtualFlowCells.getIndex() != fixedRowIndex.intValue()) continue;
                    cell = this.containsRows(fixedRowIndex);
                    if (cell != null) {
                        cell.setVisible(false);
                        cell.setManaged(false);
                    }
                    virtualFlowCells.toFront();
                    continue block0;
                }
                cell = this.containsRows(fixedRowIndex);
                if (cell == null) {
                    cell = (IndexedCell)this.getCreateCell().call((Object)this);
                    cell.getProperties().put((Object)"newcell", null);
                    this.setCellIndex((IndexedCell)cell, fixedRowIndex);
                    this.resizeCellSize((IndexedCell)cell);
                    this.myFixedCells.add(cell);
                }
                if (!this.sheetChildren.contains(cell)) {
                    this.sheetChildren.add((Node)cell);
                }
                cell.setManaged(true);
                cell.setVisible(true);
                cell.toFront();
                cell.requestLayout();
            }
        }
    }

    private T containsRows(int i) {
        for (IndexedCell cell : this.myFixedCells) {
            if (cell.getIndex() != i) continue;
            return (T)cell;
        }
        return null;
    }

    private void sortRows() {
        List<T> temp = this.getCells();
        ArrayList<T> tset = new ArrayList<T>(temp);
        Collections.sort(tset, ROWCMP);
        for (TableRow r : tset) {
            r.toFront();
        }
    }
}

