/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import com.sun.javafx.scene.control.skin.TableRowSkin;
import impl.org.controlsfx.spreadsheet.CellView;
import impl.org.controlsfx.spreadsheet.GridRow;
import impl.org.controlsfx.spreadsheet.SpreadsheetGridView;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import java.util.ArrayList;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import org.controlsfx.control.spreadsheet.Grid;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetColumn;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class GridRowSkin
extends TableRowSkin<ObservableList<SpreadsheetCell>> {
    private final SpreadsheetHandle handle;

    public GridRowSkin(SpreadsheetHandle handle, GridRow gridRow) {
        super((TableRow)gridRow);
        this.handle = handle;
    }

    protected void handleControlPropertyChanged(String p) {
        if ("ITEM".equals(p)) {
            this.updateCells = true;
            ((TableRow)this.getSkinnable()).requestLayout();
        } else if (!"INDEX".equals(p)) {
            super.handleControlPropertyChanged(p);
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        SpreadsheetView spreadsheetView = this.handle.getView();
        SpreadsheetGridView gridView = this.handle.getGridView();
        Grid grid = spreadsheetView.getGrid();
        GridRow control = (GridRow)this.getSkinnable();
        int index = control.getIndex();
        if (index < 0 || index >= gridView.getItems().size()) {
            control.setOpacity(0.0);
            return;
        }
        control.setOpacity(1.0);
        if (spreadsheetView.getColumns().size() != gridView.getColumns().size()) {
            return;
        }
        this.checkState();
        if (this.cellsMap.isEmpty()) {
            return;
        }
        ObservableList visibleLeafColumns = this.getVisibleLeafColumns();
        if (visibleLeafColumns.isEmpty()) {
            super.layoutChildren(x, y, w, h);
            return;
        }
        this.handle.getCellsViewSkin().hBarValue.set(index, true);
        double headerWidth = gridView.getWidth();
        double verticalPadding = this.snappedTopInset() + this.snappedBottomInset();
        double horizontalPadding = this.snappedLeftInset() + this.snappedRightInset();
        double controlHeight = this.getTableRowHeight(index);
        double tableCellY = 0.0;
        int positionY = spreadsheetView.getFixedRows().indexOf((Object)index);
        double space = 0.0;
        for (int o = 0; o < positionY; ++o) {
            space += this.getTableRowHeight((Integer)spreadsheetView.getFixedRows().get(o));
        }
        if (positionY != -1 && ((TableRow)this.getSkinnable()).getLocalToParentTransform().getTy() <= space) {
            tableCellY = space - ((TableRow)this.getSkinnable()).getLocalToParentTransform().getTy();
            this.handle.getCellsViewSkin().getCurrentlyFixedRow().add((Object)index);
        } else {
            this.handle.getCellsViewSkin().getCurrentlyFixedRow().remove((Object)index);
        }
        int rightPlace = 0;
        double fixedColumnWidth = 0.0;
        ArrayList<CellView> fixedCells = new ArrayList<CellView>();
        block7: for (int column = 0; column < this.cells.size(); ++column) {
            boolean isVisible;
            CellView tableCell = (CellView)((Object)this.cells.get(column));
            tableCell.setOpacity(1.0);
            double width = this.snapSize(tableCell.prefWidth(-1.0)) - this.snapSize(horizontalPadding);
            double height = controlHeight;
            height = this.snapSize(height) - this.snapSize(verticalPadding);
            double tableCellX = 0.0;
            double hbarValue = this.handle.getCellsViewSkin().getHBar().getValue();
            SpreadsheetCell cellSpan = (SpreadsheetCell)((ObservableList)grid.getRows().get(index)).get(column);
            boolean bl = isVisible = !this.isInvisible(x, width, hbarValue, headerWidth, cellSpan.getColumnSpan());
            if (((SpreadsheetColumn)spreadsheetView.getColumns().get(column)).isFixed() && hbarValue + fixedColumnWidth > x) {
                tableCellX = Math.abs(hbarValue - x + fixedColumnWidth);
                fixedColumnWidth += tableCell.getWidth();
                isVisible = true;
                fixedCells.add(tableCell);
            }
            if (isVisible) {
                if (tableCell.getParent() == null) {
                    this.getChildren().add(rightPlace, (Object)tableCell);
                }
                ++rightPlace;
                SpreadsheetView.SpanType spanType = grid.getSpanType(spreadsheetView, index, column);
                switch (spanType) {
                    case ROW_SPAN_INVISIBLE: 
                    case BOTH_INVISIBLE: {
                        tableCell.setOpacity(0.0);
                        tableCell.resize(width, height);
                        tableCell.relocate(x + tableCellX, this.snappedTopInset() + tableCellY);
                        x += width;
                        continue block7;
                    }
                    case COLUMN_SPAN_INVISIBLE: {
                        tableCell.setOpacity(0.0);
                        tableCell.resize(width, height);
                        tableCell.relocate(x + tableCellX, this.snappedTopInset() + tableCellY);
                        continue block7;
                    }
                    case ROW_VISIBLE: {
                        TableView.TableViewSelectionModel<ObservableList<SpreadsheetCell>> sm = spreadsheetView.getSelectionModel();
                        TableColumn col = (TableColumn)gridView.getColumns().get(column);
                        TablePosition<ObservableList<SpreadsheetCell>, ?> selectedPosition = this.isSelectedRange(index, col, column);
                        if (selectedPosition != null && this.handle.getCellsViewSkin().containsRow(index) && selectedPosition.getRow() != index) {
                            sm.clearSelection(selectedPosition.getRow(), selectedPosition.getTableColumn());
                            sm.select(index, col);
                        }
                    }
                    case NORMAL_CELL: {
                        tableCell.show();
                    }
                    default: {
                        if (cellSpan != null) {
                            if (cellSpan.getColumnSpan() > 1) {
                                int colSpan = cellSpan.getColumnSpan();
                                int max1 = this.cells.size() - column;
                                for (int i = 1; i < colSpan && i < max1; ++i) {
                                    width += this.snapSize(((SpreadsheetColumn)spreadsheetView.getColumns().get(column + i)).getWidth());
                                }
                            }
                            if (cellSpan.getRowSpan() > 1) {
                                height = 0.0;
                                int maxRow = cellSpan.getRow() + cellSpan.getRowSpan();
                                for (int i = cellSpan.getRow(); i < maxRow; ++i) {
                                    height += this.snapSize(this.getTableRowHeight(i));
                                }
                            }
                        }
                        tableCell.resize(width, height);
                        double spaceBetweenTopAndMe = 0.0;
                        for (int p = cellSpan.getRow(); p < index; ++p) {
                            spaceBetweenTopAndMe += this.getTableRowHeight(p);
                        }
                        tableCell.relocate(x + tableCellX, this.snappedTopInset() - spaceBetweenTopAndMe + tableCellY);
                        break;
                    }
                }
            } else {
                this.getChildren().remove((Object)tableCell);
            }
            x += width;
        }
        for (CellView cell : fixedCells) {
            cell.toFront();
        }
    }

    private double getTableRowHeight(int i) {
        return this.handle.getCellsViewSkin().getRowHeight(i);
    }

    private boolean isInvisible(double x, double width, double hbarValue, double headerWidth, int columnSpan) {
        return x + width < hbarValue && columnSpan == 1 || x > hbarValue + headerWidth;
    }

    public TablePosition<ObservableList<SpreadsheetCell>, ?> isSelectedRange(int row, TableColumn<ObservableList<SpreadsheetCell>, ?> column, int col) {
        if (column == null && row >= 0) {
            return null;
        }
        SpreadsheetGridView tableView = this.handle.getGridView();
        SpreadsheetView spreadsheetView = this.handle.getView();
        SpreadsheetCell cellSpan = (SpreadsheetCell)((ObservableList)tableView.getItems().get(row)).get(col);
        int infRow = cellSpan.getRow();
        int supRow = infRow + cellSpan.getRowSpan();
        int infCol = cellSpan.getColumn();
        int supCol = infCol + cellSpan.getColumnSpan();
        for (TablePosition tp : spreadsheetView.getSelectionModel().getSelectedCells()) {
            if (tp.getRow() < infRow || tp.getRow() >= supRow || tp.getColumn() < infCol || tp.getColumn() >= supCol) continue;
            return tp;
        }
        return null;
    }
}

