/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import impl.org.controlsfx.spreadsheet.CellView;
import impl.org.controlsfx.spreadsheet.GridRowSkin;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.control.TableRow;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class GridRow
extends TableRow<ObservableList<SpreadsheetCell>> {
    private final SpreadsheetHandle handle;
    private final InvalidationListener setPrefHeightListener = new InvalidationListener(){

        public void invalidated(Observable o) {
            GridRow.this.setPrefHeight(GridRow.this.computePrefHeight(-1.0));
        }
    };

    public GridRow(SpreadsheetHandle handle) {
        this.handle = handle;
        this.indexProperty().addListener(this.setPrefHeightListener);
        handle.getView().gridProperty().addListener(this.setPrefHeightListener);
        handle.getCellsViewSkin().rowHeightMap.addListener((MapChangeListener)new MapChangeListener<Integer, Double>(){

            public void onChanged(MapChangeListener.Change<? extends Integer, ? extends Double> change) {
                if (change.wasAdded() && ((Integer)change.getKey()).intValue() == GridRow.this.getIndex()) {
                    GridRow.this.setPrefHeight((Double)change.getValueAdded());
                    GridRow.this.requestLayout();
                } else if (change.wasRemoved() && ((Integer)change.getKey()).intValue() == GridRow.this.getIndex()) {
                    GridRow.this.setPrefHeight(GridRow.this.computePrefHeight(-1.0));
                    GridRow.this.requestLayout();
                }
            }
        });
    }

    public void putFixedColumnToBack() {
        ArrayList<Node> tset = new ArrayList<Node>((Collection<Node>)this.getChildren());
        tset.sort(new Comparator<Node>(){

            @Override
            public int compare(Node o1, Node o2) {
                int rhs;
                if (((CellView)o1).getItem() == null || ((CellView)o2).getItem() == null) {
                    return -1;
                }
                int lhs = GridRow.this.getTableView().getColumns().indexOf((Object)((CellView)o1).getTableColumn());
                if (lhs < (rhs = GridRow.this.getTableView().getColumns().indexOf((Object)((CellView)o2).getTableColumn()))) {
                    return -1;
                }
                if (lhs > rhs) {
                    return 1;
                }
                return 0;
            }
        });
        this.getChildren().setAll(tset);
    }

    public void addCell(CellView cell) {
        this.getChildren().add((Object)cell);
    }

    public void removeCell(CellView gc) {
        this.getChildren().remove((Object)gc);
    }

    SpreadsheetView getSpreadsheetView() {
        return this.handle.getView();
    }

    void setHoverPublic(boolean hover) {
        this.setHover(hover);
    }

    CellView getGridCell(int col) {
        for (Node node : this.getChildrenUnmodifiable()) {
            CellView cellView = (CellView)node;
            SpreadsheetCell cell = (SpreadsheetCell)cellView.getItem();
            if (cell.getColumn() != col) continue;
            return cellView;
        }
        return null;
    }

    protected double computePrefHeight(double width) {
        return this.handle.getCellsViewSkin().getRowHeight(this.getIndex());
    }

    protected Skin<?> createDefaultSkin() {
        return new GridRowSkin(this.handle, this);
    }
}

