/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import impl.org.controlsfx.spreadsheet.CellView;
import impl.org.controlsfx.spreadsheet.GridRow;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TablePosition;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetCellEditor;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class GridCellEditor {
    private final SpreadsheetHandle handle;
    private SpreadsheetCell modelCell;
    private CellView viewCell;
    private final SpreadsheetEditor spreadsheetEditor;
    private boolean editing = false;
    private SpreadsheetCellEditor spreadsheetCellEditor;
    private CellView lastHover = null;
    private KeyCode lastKeyPressed;
    private static final double MAX_EDITOR_HEIGHT = 50.0;
    private final EventHandler<KeyEvent> enterKeyPressed = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent t) {
            GridCellEditor.this.lastKeyPressed = t.getCode();
        }
    };
    private final InvalidationListener endEditionListener = new InvalidationListener(){

        public void invalidated(Observable observable) {
            GridCellEditor.this.endEdit(true);
        }
    };

    public GridCellEditor(SpreadsheetHandle handle) {
        this.handle = handle;
        this.spreadsheetEditor = new SpreadsheetEditor();
    }

    public void updateDataCell(SpreadsheetCell cell) {
        this.modelCell = cell;
    }

    public void updateSpreadsheetCell(CellView cell) {
        this.viewCell = cell;
    }

    public void updateSpreadsheetCellEditor(SpreadsheetCellEditor spreadsheetCellEditor) {
        this.spreadsheetCellEditor = spreadsheetCellEditor;
    }

    public CellView getLastHover() {
        return this.lastHover;
    }

    public void setLastHover(CellView lastHover) {
        this.lastHover = lastHover;
    }

    public void endEdit(boolean commitValue) {
        if (commitValue && this.editing) {
            SpreadsheetView view = this.handle.getView();
            boolean match = this.modelCell.getCellType().match(this.spreadsheetCellEditor.getControlValue());
            if (match && this.viewCell != null) {
                TablePosition position;
                Object value = this.modelCell.getCellType().convertValue(this.spreadsheetCellEditor.getControlValue());
                view.getGrid().setCellValue(this.modelCell.getRow(), this.modelCell.getColumn(), value);
                this.editing = false;
                this.viewCell.commitEdit(this.modelCell);
                this.end();
                this.spreadsheetCellEditor.end();
                if (this.lastKeyPressed == KeyCode.ENTER && (position = this.handle.getGridView().getFocusModel().getFocusedCell()) != null) {
                    this.handle.getGridView().getSelectionModel().clearAndSelect(position.getRow() + 1, position.getTableColumn());
                }
            }
        }
        if (this.viewCell != null && this.editing) {
            this.editing = false;
            this.viewCell.cancelEdit();
            this.end();
            this.spreadsheetCellEditor.end();
        }
    }

    public boolean isEditing() {
        return this.editing;
    }

    public SpreadsheetCell getModelCell() {
        return this.modelCell;
    }

    void startEdit() {
        this.editing = true;
        this.handle.getGridView().addEventFilter(KeyEvent.KEY_PRESSED, this.enterKeyPressed);
        this.spreadsheetEditor.startEdit();
        this.handle.getCellsViewSkin().getVBar().valueProperty().addListener(this.endEditionListener);
        this.handle.getCellsViewSkin().getHBar().valueProperty().addListener(this.endEditionListener);
        this.viewCell.setGraphic((Node)this.spreadsheetCellEditor.getEditor());
        Object value = this.modelCell.getItem();
        Double maxHeight = Math.max(this.handle.getCellsViewSkin().getRowHeight(this.viewCell.getIndex()), 50.0);
        this.spreadsheetCellEditor.getEditor().setMaxHeight(maxHeight.doubleValue());
        this.spreadsheetCellEditor.getEditor().setPrefWidth(this.viewCell.getWidth());
        if (this.handle.getGridView().getEditWithKey()) {
            this.handle.getGridView().setEditWithKey(false);
            this.spreadsheetCellEditor.startEdit("");
        } else {
            this.spreadsheetCellEditor.startEdit(value);
        }
        this.spreadsheetCellEditor.getEditor().focusedProperty().addListener(this.endEditionListener);
    }

    private void end() {
        this.spreadsheetEditor.end();
        this.spreadsheetCellEditor.getEditor().focusedProperty().removeListener(this.endEditionListener);
        this.handle.getCellsViewSkin().getVBar().valueProperty().removeListener(this.endEditionListener);
        this.handle.getCellsViewSkin().getHBar().valueProperty().removeListener(this.endEditionListener);
        this.handle.getGridView().removeEventFilter(KeyEvent.KEY_PRESSED, this.enterKeyPressed);
        this.modelCell = null;
        this.viewCell = null;
    }

    private class SpreadsheetEditor {
        private GridRow original;
        private boolean isMoved;

        private SpreadsheetEditor() {
        }

        private int getCellCount() {
            return GridCellEditor.this.handle.getCellsViewSkin().getCellsSize();
        }

        private boolean addCell(CellView cell) {
            GridRow lastRow = GridCellEditor.this.handle.getCellsViewSkin().getRow(this.getCellCount() - 1);
            if (lastRow.getIndex() >= GridCellEditor.this.handle.getView().getGrid().getRowCount()) {
                lastRow = GridCellEditor.this.handle.getCellsViewSkin().getRow(GridCellEditor.this.handle.getView().getGrid().getRowCount() - 1);
            }
            if (lastRow != null) {
                lastRow.addCell(cell);
                return true;
            }
            return false;
        }

        public void startEdit() {
            if (GridCellEditor.this.modelCell != null && GridCellEditor.this.modelCell.getRowSpan() > 1 && GridCellEditor.this.modelCell.getRow() != this.getCellCount() - 1) {
                this.original = (GridRow)GridCellEditor.this.viewCell.getTableRow();
                double temp = GridCellEditor.this.viewCell.getLocalToSceneTransform().getTy();
                this.isMoved = this.addCell(GridCellEditor.this.viewCell);
                if (this.isMoved) {
                    GridCellEditor.this.viewCell.setTranslateY(temp - GridCellEditor.this.viewCell.getLocalToSceneTransform().getTy());
                    this.original.putFixedColumnToBack();
                }
            }
        }

        public void end() {
            if (GridCellEditor.this.modelCell != null && GridCellEditor.this.modelCell.getRowSpan() > 1) {
                GridCellEditor.this.viewCell.setTranslateY(0.0);
                if (this.isMoved) {
                    this.original.addCell(GridCellEditor.this.viewCell);
                    this.original.putFixedColumnToBack();
                }
            }
        }
    }
}

