/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import com.sun.javafx.scene.control.skin.TableCellSkin;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.TableCell;
import javafx.scene.layout.Region;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;

public class CellViewSkin
extends TableCellSkin<ObservableList<SpreadsheetCell>, SpreadsheetCell> {
    private static final int TRIANGLE_SIZE = 8;
    private Region commentTriangle = null;
    private final ChangeListener<Boolean> triangleListener = new ChangeListener<Boolean>(){

        public void changed(ObservableValue<? extends Boolean> arg0, Boolean oldValue, Boolean newValue) {
            ((TableCell)CellViewSkin.this.getSkinnable()).requestLayout();
        }
    };
    private final ChangeListener<SpreadsheetCell> itemChangeListener = new ChangeListener<SpreadsheetCell>(){

        public void changed(ObservableValue<? extends SpreadsheetCell> arg0, SpreadsheetCell oldCell, SpreadsheetCell newCell) {
            if (oldCell != null) {
                oldCell.commentedProperty().removeListener(CellViewSkin.this.triangleListener);
            }
            if (newCell != null) {
                newCell.commentedProperty().addListener((ChangeListener)new WeakChangeListener(CellViewSkin.this.triangleListener));
            }
        }
    };

    public CellViewSkin(TableCell<ObservableList<SpreadsheetCell>, SpreadsheetCell> tableCell) {
        super(tableCell);
        tableCell.itemProperty().addListener((ChangeListener)new WeakChangeListener(this.itemChangeListener));
        if (tableCell.getItem() != null) {
            ((SpreadsheetCell)tableCell.getItem()).commentedProperty().addListener((ChangeListener)new WeakChangeListener(this.triangleListener));
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        if (((TableCell)this.getSkinnable()).getItem() != null) {
            this.layoutTriangle(((SpreadsheetCell)((TableCell)this.getSkinnable()).getItem()).isCommented());
        }
    }

    private void layoutTriangle(boolean isCommented) {
        if (isCommented) {
            if (this.commentTriangle == null) {
                this.commentTriangle = new Region();
            }
            if (!this.getChildren().contains((Object)this.commentTriangle)) {
                this.getChildren().add((Object)this.commentTriangle);
            }
            this.commentTriangle.resize(8.0, 8.0);
            this.commentTriangle.getStyleClass().add((Object)"comment");
            this.commentTriangle.relocate(((TableCell)this.getSkinnable()).getWidth() - 8.0, this.snappedTopInset() - 1.0);
        } else if (this.commentTriangle != null) {
            this.getChildren().remove((Object)this.commentTriangle);
            this.commentTriangle = null;
        }
        ((TableCell)this.getSkinnable()).requestLayout();
    }
}

