/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import impl.org.controlsfx.spreadsheet.CellViewSkin;
import impl.org.controlsfx.spreadsheet.GridCellEditor;
import impl.org.controlsfx.spreadsheet.GridRow;
import impl.org.controlsfx.spreadsheet.GridViewSkin;
import impl.org.controlsfx.spreadsheet.SpreadsheetHandle;
import java.util.Optional;
import javafx.animation.FadeTransition;
import javafx.application.Platform;
import javafx.beans.binding.When;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.SetChangeListener;
import javafx.collections.WeakSetChangeListener;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;
import org.controlsfx.control.spreadsheet.Grid;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetCellEditor;
import org.controlsfx.control.spreadsheet.SpreadsheetCellType;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class CellView
extends TableCell<ObservableList<SpreadsheetCell>, SpreadsheetCell> {
    private final SpreadsheetHandle handle;
    private static final String ANCHOR_PROPERTY_KEY = "table.anchor";
    private static final int TOOLTIP_MAX_WIDTH = 400;
    private static final int WRAP_HEIGHT = 35;
    private static final Duration FADE_DURATION = Duration.millis((double)500.0);
    private final ChangeListener<Number> wrapHeightChangeListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> ov, Number t, Number t1) {
            if (t1.doubleValue() > 35.0) {
                CellView.this.setWrapText(true);
            } else {
                CellView.this.setWrapText(false);
            }
        }
    };
    private final ChangeListener<Node> graphicListener = new ChangeListener<Node>(){

        public void changed(ObservableValue<? extends Node> arg0, Node arg1, Node newGraphic) {
            CellView.this.setCellGraphic((SpreadsheetCell)CellView.this.getItem());
        }
    };
    private final WeakChangeListener<Node> weakGraphicListener = new WeakChangeListener(this.graphicListener);
    private final SetChangeListener<String> styleClassListener = new SetChangeListener<String>(){

        public void onChanged(SetChangeListener.Change<? extends String> arg0) {
            if (arg0.wasAdded()) {
                CellView.this.getStyleClass().add(arg0.getElementAdded());
            } else if (arg0.wasRemoved()) {
                CellView.this.getStyleClass().remove(arg0.getElementRemoved());
            }
        }
    };
    private final WeakSetChangeListener<String> weakStyleClassListener = new WeakSetChangeListener(this.styleClassListener);
    private final EventHandler<MouseEvent> startFullDragEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent arg0) {
            CellView.this.startFullDrag();
        }
    };
    private final EventHandler<MouseEvent> dragMouseEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent arg0) {
            CellView.this.dragSelect(arg0);
        }
    };
    private final ChangeListener<Boolean> hoverChangeListener = new ChangeListener<Boolean>(){

        public void changed(ObservableValue<? extends Boolean> ov, Boolean t, Boolean t1) {
            int row = CellView.this.getIndex();
            if (CellView.this.getItem() == null) {
                CellView.this.getTableRow().requestLayout();
            } else if (((SpreadsheetCell)CellView.this.getItem()).getRowSpan() > 1) {
                if (t1.booleanValue() && row != ((SpreadsheetCell)CellView.this.getItem()).getRow()) {
                    CellView.this.hoverGridCell((SpreadsheetCell)CellView.this.getItem());
                } else if (!t1.booleanValue() && row != ((SpreadsheetCell)CellView.this.getItem()).getRow()) {
                    CellView.this.unHoverGridCell();
                }
            }
        }
    };
    private final ChangeListener<SpreadsheetCell> itemChangeListener = new ChangeListener<SpreadsheetCell>(){

        public void changed(ObservableValue<? extends SpreadsheetCell> arg0, SpreadsheetCell oldItem, SpreadsheetCell newItem) {
            if (oldItem != null) {
                oldItem.getStyleClass().removeListener((SetChangeListener)CellView.this.weakStyleClassListener);
                oldItem.graphicProperty().removeListener((ChangeListener)CellView.this.weakGraphicListener);
            }
            if (newItem != null) {
                CellView.this.getStyleClass().clear();
                CellView.this.getStyleClass().setAll(newItem.getStyleClass());
                newItem.getStyleClass().addListener((SetChangeListener)CellView.this.weakStyleClassListener);
                CellView.this.setCellGraphic(newItem);
                newItem.graphicProperty().addListener((ChangeListener)CellView.this.weakGraphicListener);
            }
        }
    };

    static TablePositionBase<?> getAnchor(Control table, TablePositionBase<?> focusedCell) {
        return CellView.hasAnchor(table) ? (TablePositionBase)table.getProperties().get((Object)ANCHOR_PROPERTY_KEY) : focusedCell;
    }

    static boolean hasAnchor(Control table) {
        return table.getProperties().get((Object)ANCHOR_PROPERTY_KEY) != null;
    }

    public CellView(SpreadsheetHandle handle) {
        this.handle = handle;
        this.hoverProperty().addListener(this.hoverChangeListener);
        this.addEventHandler(MouseEvent.DRAG_DETECTED, (EventHandler)new WeakEventHandler(this.startFullDragEventHandler));
        this.setOnMouseDragEntered((EventHandler)new WeakEventHandler(this.dragMouseEventHandler));
        this.itemProperty().addListener(this.itemChangeListener);
        this.heightProperty().addListener(this.wrapHeightChangeListener);
    }

    public void startEdit() {
        if (!this.isEditable()) {
            return;
        }
        if (this.handle.getGridView().getEditWithEnter()) {
            this.handle.getGridView().setEditWithEnter(false);
            return;
        }
        int column = this.getTableView().getColumns().indexOf((Object)this.getTableColumn());
        int row = this.getIndex();
        SpreadsheetView spv = this.handle.getView();
        Grid grid = spv.getGrid();
        SpreadsheetView.SpanType type = grid.getSpanType(spv, row, column);
        if (type == SpreadsheetView.SpanType.NORMAL_CELL || type == SpreadsheetView.SpanType.ROW_VISIBLE) {
            if (!this.getTableRow().isManaged()) {
                return;
            }
            GridCellEditor editor = this.getEditor((SpreadsheetCell)this.getItem(), spv);
            if (editor != null) {
                super.startEdit();
                this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                editor.startEdit();
            }
        }
    }

    public void commitEdit(SpreadsheetCell newValue) {
        FadeTransition fadeTransition = new FadeTransition(FADE_DURATION, (Node)this);
        fadeTransition.setFromValue(0.0);
        fadeTransition.setToValue(1.0);
        fadeTransition.play();
        if (!this.isEditing()) {
            return;
        }
        super.commitEdit((Object)newValue);
        this.setContentDisplay(ContentDisplay.LEFT);
        this.updateItem(newValue, false);
        if (this.getTableView() != null) {
            this.getTableView().requestFocus();
        }
    }

    public void cancelEdit() {
        if (!this.isEditing()) {
            return;
        }
        super.cancelEdit();
        this.setContentDisplay(ContentDisplay.LEFT);
        this.updateItem((SpreadsheetCell)this.getItem(), false);
        if (this.getTableView() != null) {
            this.getTableView().requestFocus();
        }
    }

    public void updateItem(SpreadsheetCell item, boolean empty) {
        boolean emptyRow;
        boolean bl = emptyRow = this.getTableView().getItems().size() < this.getIndex() + 1;
        if (!this.isEditing()) {
            super.updateItem((Object)item, empty && emptyRow);
        }
        if (empty && this.isSelected()) {
            this.updateSelected(false);
        }
        if (empty && emptyRow) {
            this.setText(null);
            this.setContentDisplay(null);
        } else if (!this.isEditing() && item != null) {
            this.show(item);
            if (item.getGraphic() == null) {
                this.setGraphic(null);
            }
            if (this.isHover()) {
                this.setHoverPublic(false);
            }
        }
    }

    public void show(SpreadsheetCell cell) {
        this.textProperty().bind((ObservableValue)cell.textProperty());
        this.setCellGraphic(cell);
        Optional<String> tooltip = cell.getTooltip();
        if (tooltip.isPresent()) {
            CellView.getValue(() -> {
                Tooltip toolTip = new Tooltip((String)tooltip.get());
                toolTip.setWrapText(true);
                toolTip.setMaxWidth(400.0);
                this.setTooltip(toolTip);
            });
        } else {
            this.setTooltip(null);
        }
        this.setEditable(cell.isEditable());
    }

    public void show() {
        if (this.getItem() != null) {
            this.show((SpreadsheetCell)this.getItem());
        }
    }

    private void setCellGraphic(SpreadsheetCell item) {
        if (this.isEditing()) {
            return;
        }
        if (item.getGraphic() != null) {
            if (item.getGraphic() instanceof ImageView) {
                ImageView image = new ImageView(((ImageView)item.getGraphic()).getImage());
                image.setCache(true);
                image.setPreserveRatio(true);
                image.setSmooth(true);
                image.fitHeightProperty().bind((ObservableValue)new When((ObservableBooleanValue)this.heightProperty().greaterThan(image.getImage().getHeight())).then(image.getImage().getHeight()).otherwise((ObservableNumberValue)this.heightProperty()));
                image.fitWidthProperty().bind((ObservableValue)new When((ObservableBooleanValue)this.widthProperty().greaterThan(image.getImage().getWidth())).then(image.getImage().getWidth()).otherwise((ObservableNumberValue)this.widthProperty()));
                this.setGraphic((Node)image);
            } else if (item.getGraphic() instanceof Node) {
                this.setGraphic(item.getGraphic());
            }
        } else {
            this.setGraphic(null);
        }
    }

    private void setHoverPublic(boolean hover) {
        this.setHover(hover);
        ((GridRow)this.getTableRow()).setHoverPublic(hover);
    }

    private GridCellEditor getEditor(SpreadsheetCell cell, SpreadsheetView spv) {
        SpreadsheetCellType cellType = cell.getCellType();
        Optional<SpreadsheetCellEditor> cellEditor = spv.getEditor(cellType);
        if (cellEditor.isPresent()) {
            GridCellEditor editor = this.handle.getCellsViewSkin().getSpreadsheetCellEditorImpl();
            if (editor.isEditing()) {
                return null;
            }
            editor.updateSpreadsheetCell(this);
            editor.updateDataCell(cell);
            editor.updateSpreadsheetCellEditor(cellEditor.get());
            return editor;
        }
        return null;
    }

    private void hoverGridCell(SpreadsheetCell cell) {
        GridRow rightRow;
        GridViewSkin sps = this.handle.getCellsViewSkin();
        GridRow row = sps.getRow(0);
        CellView gridCell = sps.getCellsSize() != 0 && row.getIndex() <= cell.getRow() ? ((rightRow = sps.getRow(cell.getRow() - row.getIndex())) != null ? rightRow.getGridCell(cell.getColumn()) : row.getGridCell(cell.getColumn())) : row.getGridCell(cell.getColumn());
        if (gridCell != null) {
            gridCell.setHoverPublic(true);
            GridCellEditor editor = sps.getSpreadsheetCellEditorImpl();
            editor.setLastHover(gridCell);
        }
    }

    private void unHoverGridCell() {
        GridViewSkin sps = this.handle.getCellsViewSkin();
        GridCellEditor editor = sps.getSpreadsheetCellEditorImpl();
        CellView lastHover = editor.getLastHover();
        if (editor.getLastHover() != null) {
            lastHover.setHoverPublic(false);
        }
    }

    private void dragSelect(MouseEvent e) {
        if (!this.contains(e.getX(), e.getY())) {
            return;
        }
        TableView tableView = this.getTableView();
        if (tableView == null) {
            return;
        }
        int count = tableView.getItems().size();
        if (this.getIndex() >= count) {
            return;
        }
        TableView.TableViewSelectionModel sm = tableView.getSelectionModel();
        if (sm == null) {
            return;
        }
        int row = this.getIndex();
        int column = tableView.getVisibleLeafIndex(this.getTableColumn());
        SpreadsheetCell cell = (SpreadsheetCell)this.getItem();
        int rowCell = cell.getRow() + cell.getRowSpan() - 1;
        int columnCell = cell.getColumn() + cell.getColumnSpan() - 1;
        TableView.TableViewFocusModel fm = tableView.getFocusModel();
        if (fm == null) {
            return;
        }
        TablePosition focusedCell = fm.getFocusedCell();
        MouseButton button = e.getButton();
        if (button == MouseButton.PRIMARY) {
            TablePositionBase<?> anchor = CellView.getAnchor((Control)tableView, focusedCell);
            int minRow = Math.min(anchor.getRow(), row);
            minRow = Math.min(minRow, rowCell);
            int maxRow = Math.max(anchor.getRow(), row);
            maxRow = Math.max(maxRow, rowCell);
            int minColumn = Math.min(anchor.getColumn(), column);
            minColumn = Math.min(minColumn, columnCell);
            int maxColumn = Math.max(anchor.getColumn(), column);
            maxColumn = Math.max(maxColumn, columnCell);
            if (!e.isShortcutDown()) {
                sm.clearSelection();
            }
            if (minColumn != -1 && maxColumn != -1) {
                sm.selectRange(minRow, (TableColumnBase)tableView.getColumns().get(minColumn), maxRow, (TableColumnBase)tableView.getColumns().get(maxColumn));
            }
        }
    }

    static void getValue(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater((Runnable)runnable);
        }
    }

    protected Skin<?> createDefaultSkin() {
        return new CellViewSkin(this);
    }
}

