/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import impl.org.controlsfx.behavior.SnapshotViewBehavior;
import impl.org.controlsfx.tools.MathTools;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.StrokeType;
import org.controlsfx.control.SnapshotView;

public class SnapshotViewSkin
extends BehaviorSkinBase<SnapshotView, SnapshotViewBehavior> {
    private final Pane pane = SnapshotViewSkin.createClippingPane();
    private Node node;
    private final Rectangle selectedArea = new Rectangle();
    private final Rectangle unselectedArea = new Rectangle();
    private final Node mouseNode = this.createMouseNode((Region)this.pane);

    public SnapshotViewSkin(SnapshotView snapshotView) {
        super((Control)snapshotView, (BehaviorBase)new SnapshotViewBehavior(snapshotView));
        this.buildSceneGraph();
        this.initializeAreas();
        this.registerChangeListener((ObservableValue)snapshotView.nodeProperty(), "NODE");
        this.registerChangeListener((ObservableValue)snapshotView.selectionProperty(), "SELECTION");
        this.registerChangeListener((ObservableValue)snapshotView.widthProperty(), "WIDTH");
        this.registerChangeListener((ObservableValue)snapshotView.heightProperty(), "HEIGHT");
    }

    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if ("NODE".equals(p)) {
            this.updateNode();
            this.updateSelection();
        } else if ("WIDTH".equals(p) || "HEIGHT".equals(p)) {
            this.updateSelection();
        } else if ("SELECTION".equals(p)) {
            this.updateSelection();
        }
    }

    private static Pane createClippingPane() {
        Pane pane = new Pane();
        return pane;
    }

    private Node createMouseNode(Region root) {
        Rectangle mouseNode = new Rectangle();
        mouseNode.setFill((Paint)Color.TRANSPARENT);
        mouseNode.setManaged(false);
        mouseNode.widthProperty().bind((ObservableValue)root.widthProperty());
        mouseNode.heightProperty().bind((ObservableValue)root.heightProperty());
        mouseNode.addEventHandler(MouseEvent.ANY, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                SnapshotViewSkin.this.handleMouseEvent(event);
            }
        });
        return mouseNode;
    }

    private void buildSceneGraph() {
        GridPane outerPane = new GridPane();
        this.getChildren().add((Object)outerPane);
        outerPane.setAlignment(Pos.CENTER);
        outerPane.add((Node)this.pane, 0, 0);
        this.pane.getChildren().addAll((Object[])new Node[]{this.unselectedArea, this.selectedArea, this.mouseNode});
        this.updateNode();
    }

    private void updateNode() {
        if (this.node != null) {
            this.pane.getChildren().remove((Object)this.node);
        }
        this.node = ((SnapshotView)this.getSkinnable()).getNode();
        if (this.node != null) {
            this.pane.getChildren().add(0, (Object)this.node);
        }
    }

    private void initializeAreas() {
        this.styleAreas();
        this.bindAreaCoordinatesTogether();
        this.bindAreaVisibilityToSelection();
    }

    private void styleAreas() {
        this.selectedArea.setFill((Paint)Color.TRANSPARENT);
        this.selectedArea.setStroke((Paint)Color.WHITESMOKE);
        this.selectedArea.setStrokeWidth(2.0);
        this.selectedArea.setStrokeType(StrokeType.OUTSIDE);
        this.selectedArea.setManaged(false);
        this.unselectedArea.setFill((Paint)Color.TRANSPARENT);
        this.unselectedArea.setStroke((Paint)new Color(0.0, 0.0, 0.0, 0.5));
        this.unselectedArea.strokeWidthProperty().bind((ObservableValue)Bindings.max((ObservableNumberValue)this.pane.widthProperty(), (ObservableNumberValue)this.pane.heightProperty()));
        this.unselectedArea.setStrokeType(StrokeType.OUTSIDE);
        this.unselectedArea.setManaged(false);
    }

    private void bindAreaCoordinatesTogether() {
        this.unselectedArea.xProperty().bind((ObservableValue)this.selectedArea.xProperty());
        this.unselectedArea.yProperty().bind((ObservableValue)this.selectedArea.yProperty());
        this.unselectedArea.widthProperty().bind((ObservableValue)this.selectedArea.widthProperty());
        this.unselectedArea.heightProperty().bind((ObservableValue)this.selectedArea.heightProperty());
    }

    private void bindAreaVisibilityToSelection() {
        ReadOnlyBooleanProperty selectionValid = ((SnapshotView)this.getSkinnable()).selectionValidProperty();
        BooleanProperty selectionActive = ((SnapshotView)this.getSkinnable()).selectionActiveProperty();
        BooleanBinding validAndVisible = Bindings.and((ObservableBooleanValue)selectionValid, (ObservableBooleanValue)selectionActive);
        this.selectedArea.visibleProperty().bind((ObservableValue)validAndVisible);
        this.unselectedArea.visibleProperty().bind((ObservableValue)validAndVisible);
    }

    private Rectangle2D getImageSelection() {
        return ((SnapshotView)this.getSkinnable()).getSelection();
    }

    private void updateSelection() {
        boolean showSelection;
        boolean bl = showSelection = ((SnapshotView)this.getSkinnable()).getNode() != null && ((SnapshotView)this.getSkinnable()).isSelectionValid();
        if (showSelection) {
            this.setTransformedSelection();
        } else {
            this.setSelectionDirectly(0.0, 0.0, 0.0, 0.0);
        }
    }

    private void setTransformedSelection() {
        double newHeight;
        boolean tooHigh;
        boolean tooWide;
        Node n = ((SnapshotView)this.getSkinnable()).getNode();
        double imageViewWidth = n == null ? 0.0 : n.getBoundsInLocal().getWidth();
        double imageViewHeight = n == null ? 0.0 : n.getBoundsInLocal().getHeight();
        double widthRatio = imageViewWidth / n.prefWidth(-1.0);
        double heightRatio = imageViewHeight / n.prefHeight(-1.0);
        Rectangle2D selection = this.getImageSelection();
        double newX = MathTools.inInterval(0.0, widthRatio * selection.getMinX(), imageViewWidth);
        double newY = MathTools.inInterval(0.0, heightRatio * selection.getMinY(), imageViewHeight);
        double newWidth = widthRatio * selection.getWidth();
        boolean bl = tooWide = newX + newWidth > imageViewWidth;
        if (tooWide) {
            newWidth = imageViewWidth - newX;
        }
        boolean bl2 = tooHigh = newY - (newHeight = heightRatio * selection.getHeight()) > imageViewHeight;
        if (tooHigh) {
            newHeight = imageViewHeight - newY;
        }
        this.setSelectionDirectly(newX, newY, newWidth, newHeight);
    }

    private void setSelectionDirectly(double x, double y, double width, double height) {
        this.selectedArea.setX(x);
        this.selectedArea.setY(y);
        this.selectedArea.setWidth(width);
        this.selectedArea.setHeight(height);
    }

    private void handleMouseEvent(MouseEvent event) {
        boolean imageExists = ((SnapshotView)this.getSkinnable()).getNode() != null;
        Cursor newCursor = imageExists ? ((SnapshotViewBehavior)this.getBehavior()).handleSelectionEvent(event) : Cursor.DEFAULT;
        this.mouseNode.setCursor(newCursor);
    }
}

