/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import impl.org.controlsfx.i18n.Localization;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.event.ActionEvent;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Accordion;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import org.controlsfx.control.PropertySheet;
import org.controlsfx.control.SegmentedButton;
import org.controlsfx.control.action.AbstractAction;
import org.controlsfx.control.action.ActionUtils;
import org.controlsfx.control.textfield.TextFields;
import org.controlsfx.property.editor.AbstractPropertyEditor;
import org.controlsfx.property.editor.PropertyEditor;

public class PropertySheetSkin
extends BehaviorSkinBase<PropertySheet, BehaviorBase<PropertySheet>> {
    private static final int MIN_COLUMN_WIDTH = 100;
    private final BorderPane content = new BorderPane();
    private final ScrollPane scroller = new ScrollPane();
    private final ToolBar toolbar = new ToolBar();
    private final SegmentedButton modeButton = ActionUtils.createSegmentedButton(new ActionChangeMode(PropertySheet.Mode.NAME), new ActionChangeMode(PropertySheet.Mode.CATEGORY));
    private final TextField searchField = TextFields.createClearableTextField();

    public PropertySheetSkin(PropertySheet control) {
        super((Control)control, new BehaviorBase((Control)control, Collections.emptyList()));
        this.scroller.setFitToWidth(true);
        this.toolbar.managedProperty().bind((ObservableValue)this.toolbar.visibleProperty());
        this.modeButton.managedProperty().bind((ObservableValue)this.modeButton.visibleProperty());
        ((ToggleButton)this.modeButton.getButtons().get(((PropertySheet.Mode)((Object)((PropertySheet)this.getSkinnable()).modeProperty().get())).ordinal())).setSelected(true);
        this.toolbar.getItems().add((Object)this.modeButton);
        this.searchField.setPromptText(Localization.localize(Localization.asKey("property.sheet.search.field.prompt")));
        this.searchField.setMinWidth(0.0);
        HBox.setHgrow((Node)this.searchField, (Priority)Priority.SOMETIMES);
        this.searchField.managedProperty().bind((ObservableValue)this.searchField.visibleProperty());
        this.toolbar.getItems().add((Object)this.searchField);
        this.content.setTop((Node)this.toolbar);
        this.content.setCenter((Node)this.scroller);
        this.getChildren().add((Object)this.content);
        this.registerChangeListener((ObservableValue)control.modeProperty(), "MODE");
        this.registerChangeListener((ObservableValue)control.propertyEditorFactory(), "EDITOR-FACTORY");
        this.registerChangeListener((ObservableValue)control.titleFilter(), "FILTER");
        this.registerChangeListener((ObservableValue)this.searchField.textProperty(), "FILTER-UI");
        this.registerChangeListener((ObservableValue)control.modeSwitcherVisibleProperty(), "TOOLBAR-MODE");
        this.registerChangeListener((ObservableValue)control.searchBoxVisibleProperty(), "TOOLBAR-SEARCH");
        control.getItems().addListener((ListChangeListener)new ListChangeListener<PropertySheet.Item>(){

            public void onChanged(ListChangeListener.Change<? extends PropertySheet.Item> change) {
                PropertySheetSkin.this.refreshProperties();
            }
        });
        this.refreshProperties();
        this.updateToolbar();
    }

    protected void handleControlPropertyChanged(String p) {
        super.handleControlPropertyChanged(p);
        if (p == "MODE" || p == "EDITOR-FACTORY" || p == "FILTER") {
            this.refreshProperties();
        } else if (p == "FILTER-UI") {
            ((PropertySheet)this.getSkinnable()).setTitleFilter(this.searchField.getText());
        } else if (p == "TOOLBAR-MODE") {
            this.updateToolbar();
        } else if (p == "TOOLBAR-SEARCH") {
            this.updateToolbar();
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        this.content.resizeRelocate(x, y, w, h);
    }

    private void updateToolbar() {
        this.modeButton.setVisible(((PropertySheet)this.getSkinnable()).isModeSwitcherVisible());
        this.searchField.setVisible(((PropertySheet)this.getSkinnable()).isSearchBoxVisible());
        this.toolbar.setVisible(this.modeButton.isVisible() || this.searchField.isVisible());
    }

    private void refreshProperties() {
        this.scroller.setContent(this.buildPropertySheetContainer());
    }

    private Node buildPropertySheetContainer() {
        switch ((PropertySheet.Mode)((Object)((PropertySheet)this.getSkinnable()).modeProperty().get())) {
            case CATEGORY: {
                TreeMap<String, ArrayList<PropertySheet.Item>> categoryMap = new TreeMap<String, ArrayList<PropertySheet.Item>>();
                for (PropertySheet.Item p : ((PropertySheet)this.getSkinnable()).getItems()) {
                    String category = p.getCategory();
                    ArrayList<PropertySheet.Item> list = (ArrayList<PropertySheet.Item>)categoryMap.get(category);
                    if (list == null) {
                        list = new ArrayList<PropertySheet.Item>();
                        categoryMap.put(category, list);
                    }
                    list.add(p);
                }
                Accordion accordeon = new Accordion();
                for (String category : categoryMap.keySet()) {
                    PropertyPane props = new PropertyPane((List)categoryMap.get(category));
                    if (props.getChildrenUnmodifiable().size() <= 0) continue;
                    TitledPane pane = new TitledPane(category, (Node)props);
                    pane.setExpanded(true);
                    accordeon.getPanes().add((Object)pane);
                }
                if (accordeon.getPanes().size() > 0) {
                    accordeon.setExpandedPane((TitledPane)accordeon.getPanes().get(0));
                }
                return accordeon;
            }
        }
        return new PropertyPane((List<PropertySheet.Item>)((PropertySheet)this.getSkinnable()).getItems());
    }

    private class PropertyPane
    extends GridPane {
        public PropertyPane(List<PropertySheet.Item> properties) {
            this(properties, 0);
        }

        public PropertyPane(List<PropertySheet.Item> properties, int nestingLevel) {
            this.setVgap(5.0);
            this.setHgap(5.0);
            this.setPadding(new Insets(5.0, 15.0, 5.0, (double)(15 + nestingLevel * 10)));
            this.getStyleClass().add((Object)"property-pane");
            this.setItems(properties);
        }

        public void setItems(List<PropertySheet.Item> properties) {
            this.getChildren().clear();
            String filter = ((PropertySheet)PropertySheetSkin.this.getSkinnable()).titleFilter().get();
            filter = filter == null ? "" : filter.trim().toLowerCase();
            int row = 0;
            for (PropertySheet.Item item : properties) {
                String title = item.getName();
                if (!filter.isEmpty() && title.toLowerCase().indexOf(filter) < 0) continue;
                Label label = new Label(title);
                label.setMinWidth(100.0);
                String description = item.getDescription();
                if (description != null && !description.trim().isEmpty()) {
                    label.setTooltip(new Tooltip(description));
                }
                this.add((Node)label, 0, row);
                Node editor = this.getEditor(item);
                if (editor instanceof Region) {
                    ((Region)editor).setMinWidth(100.0);
                    ((Region)editor).setMaxWidth(Double.MAX_VALUE);
                }
                label.setLabelFor(editor);
                this.add(editor, 1, row);
                GridPane.setHgrow((Node)editor, (Priority)Priority.ALWAYS);
                ++row;
            }
        }

        private Node getEditor(PropertySheet.Item item) {
            PropertyEditor editor = (PropertyEditor)((PropertySheet)PropertySheetSkin.this.getSkinnable()).getPropertyEditorFactory().call((Object)item);
            if (editor == null) {
                editor = new AbstractPropertyEditor<Object, TextField>(item, new TextField(), true){
                    {
                        ((TextField)this.getEditor()).setEditable(false);
                        ((TextField)this.getEditor()).setDisable(true);
                    }

                    @Override
                    protected ObservableValue<Object> getObservableValue() {
                        return (ObservableValue)((TextField)this.getEditor()).textProperty();
                    }

                    @Override
                    public void setValue(Object value) {
                        ((TextField)this.getEditor()).setText(value == null ? "" : value.toString());
                    }
                };
            } else if (!item.isEditable()) {
                editor.getEditor().setDisable(true);
            }
            editor.setValue(item.getValue());
            return editor.getEditor();
        }
    }

    private class ActionChangeMode
    extends AbstractAction {
        private final Image CATEGORY_IMAGE;
        private final Image NAME_IMAGE;
        private PropertySheet.Mode mode;

        public ActionChangeMode(PropertySheet.Mode mode) {
            super("");
            this.CATEGORY_IMAGE = new Image("/impl/org/controlsfx/dialog/resources/oxygen/16/format-indent-more.png");
            this.NAME_IMAGE = new Image("/impl/org/controlsfx/dialog/resources/oxygen/16/format-line-spacing-triple.png");
            this.mode = mode;
            if (mode == PropertySheet.Mode.CATEGORY) {
                this.setGraphic((Node)new ImageView(this.CATEGORY_IMAGE));
                this.setLongText(Localization.localize(Localization.asKey("property.sheet.group.mode.bycategory")));
            } else if (mode == PropertySheet.Mode.NAME) {
                this.setGraphic((Node)new ImageView(this.NAME_IMAGE));
                this.setLongText(Localization.localize(Localization.asKey("property.sheet.group.mode.byname")));
            } else {
                this.setText("???");
            }
        }

        public void handle(ActionEvent ae) {
            ((PropertySheet)PropertySheetSkin.this.getSkinnable()).modeProperty().set((Object)this.mode);
        }
    }
}

