/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.skin;

import impl.org.controlsfx.skin.AutoCompletePopup;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.control.Skin;
import javafx.scene.control.cell.TextFieldListCell;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import org.controlsfx.control.textfield.AutoCompletionBinding;

public class AutoCompletePopupSkin<T>
implements Skin<AutoCompletePopup<T>> {
    private final AutoCompletePopup<T> control;
    private final ListView<T> suggestionList;
    final int LIST_CELL_HEIGHT = 24;

    public AutoCompletePopupSkin(AutoCompletePopup<T> control) {
        this.control = control;
        this.suggestionList = new ListView(control.getSuggestions());
        this.suggestionList.getStyleClass().add((Object)"auto-complete-popup");
        this.suggestionList.getStylesheets().add((Object)AutoCompletionBinding.class.getResource("autocompletion.css").toExternalForm());
        this.suggestionList.prefHeightProperty().bind((ObservableValue)Bindings.size((ObservableList)this.suggestionList.getItems()).multiply(24).add(15));
        this.suggestionList.maxHeightProperty().bind((ObservableValue)control.maxHeightProperty());
        this.suggestionList.setCellFactory(TextFieldListCell.forListView(control.getConverter()));
        this.registerEventListener();
    }

    private void registerEventListener() {
        this.suggestionList.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent me) {
                if (me.getButton() == MouseButton.PRIMARY) {
                    AutoCompletePopupSkin.this.onSuggestionChoosen(AutoCompletePopupSkin.this.suggestionList.getSelectionModel().getSelectedItem());
                }
            }
        });
        this.suggestionList.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent ke) {
                switch (ke.getCode()) {
                    case ENTER: {
                        AutoCompletePopupSkin.this.onSuggestionChoosen(AutoCompletePopupSkin.this.suggestionList.getSelectionModel().getSelectedItem());
                        break;
                    }
                }
            }
        });
    }

    private void onSuggestionChoosen(T suggestion) {
        if (suggestion != null) {
            Event.fireEvent(this.control, new AutoCompletePopup.SuggestionEvent<T>(suggestion));
        }
    }

    public Node getNode() {
        return this.suggestionList;
    }

    public AutoCompletePopup<T> getSkinnable() {
        return this.control;
    }

    public void dispose() {
    }
}

