/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;

public class ImplUtils {
    private ImplUtils() {
    }

    public static void injectAsRootPane(Scene scene, Parent injectedParent) {
        Parent originalParent = scene.getRoot();
        scene.setRoot(injectedParent);
        if (originalParent != null) {
            ImplUtils.getChildren(injectedParent).add(0, (Object)originalParent);
            injectedParent.getProperties().putAll((Map)originalParent.getProperties());
        }
    }

    public static void injectPane(Parent parent, Parent injectedParent) {
        ObservableList<Node> ownerParentChildren = ImplUtils.getChildren(parent.getParent());
        int ownerPos = ownerParentChildren.indexOf((Object)parent);
        ownerParentChildren.remove(ownerPos);
        ownerParentChildren.add(ownerPos, (Object)injectedParent);
        if (parent != null) {
            ImplUtils.getChildren(injectedParent).add(0, (Object)parent);
            injectedParent.getProperties().putAll((Map)parent.getProperties());
        }
    }

    public static void stripRootPane(Scene scene, Parent originalParent) {
        Parent oldParent = scene.getRoot();
        ImplUtils.getChildren(oldParent).remove((Object)originalParent);
        originalParent.getStyleClass().remove((Object)"root");
        scene.setRoot(originalParent);
    }

    public static ObservableList<Node> getChildren(Parent p) {
        ObservableList children = null;
        try {
            Method getChildrenMethod = Parent.class.getDeclaredMethod("getChildren", new Class[0]);
            if (getChildrenMethod != null) {
                if (!getChildrenMethod.isAccessible()) {
                    getChildrenMethod.setAccessible(true);
                }
                children = (ObservableList)getChildrenMethod.invoke((Object)p, new Object[0]);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return children;
    }
}

