/*************************************************************************
 * common.c Implementation of some common-using function [part of AVInfo 1.x]
 *
 * Copyright (c) 2003 George Shuklin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *   
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *   
 * You should have received a copy of the GNU General Public License along
 * with this program (see the file COPYING); if not, write to the Free 
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307  USA  or visit http://www.gnu.org/copyleft/gpl.html
 *
 *************************************************************************/
#include "avinfo.h"
#include <stdlib.h>
#include <stdio.h>

int CHARS_PRINT=0;
int MAX_CHARS;

char *ITOA(int value, char *string,int radix){
	if(radix==16)
		sprintf(string,"%x",value);
	else
		sprintf(string,"%d",value);
	return string;
}


#define CI_CMP(a,b)\
	(!\
		(\
			(\
				(a <= 'Z' && a >= 'A' )? \
					a - 'A' + 'a' \
					:\
					a\
			)\
			-\
			(\
				(b <= 'Z' && b >= 'A' )?\
					b - 'A' + 'a'\
					:\
					b\
			)\
		)\
	)

int STRICMP(const char* line1, const char* line2){
/*char '?' used as a "ANY CHAR" substitution, 
'*' == any string to end (LIKE DOS, NOT LIKE UNIX!)*/
	const char* p1=line1,*p2=line2;
	while(
			CI_CMP(*p1,*p2)
			||
			*p1=='?'
			||
			*p2=='?'
			||
			*p2=='*'
			||
			*p1=='*'
			||
			(isdigit(*p1)&&*p2=='#')
			||
			(isdigit(*p2)&&*p1=='#')
			||
			(isalpha(*p1)&&*p2=='$')
			||
			(isalpha(*p2)&&*p1=='$')
		){
		if(!*p1||!*p2||*p1=='*'||*p2=='*') return 0; /*no difference*/
		p1++;
		p2++;
	}
	return *p1-*p2;
}


char* dup( const char* string){
/*Some like strdup - Create copy of string. Traps if line==NULL*/
	int   i    = strlen( string ) + 1;
	char* temp = (char*)malloc( i );

	if( temp != NULL ) memcpy( temp, string, i );
	return temp;

}

int advmemcmp(const unsigned char* base, const unsigned char* pattern, const int number){
/*some like memcmp, but using 0 in pattern as a mask "anybyte"*/
	int c;
	for(c=0;c<number;c++){
		if(!pattern[c]) continue;
		if(pattern[c]!=base[c]) return base[c]-pattern[c];
	}
	return 0; /*ok*/
}


void lowcase(unsigned char* line){
	unsigned char* temp=line;
	while(*temp){
		if(*temp>='A'&&*temp<='Z') *temp=*temp+'a'-'A';
		temp++;
	}
}


void fill(char* line, int c, char pattern){
	int q;
	for(q=0;q<c;q++){
		line[q]=pattern;
	}
}

char* mkstr (unsigned char* buffer, int pos, int size){
	char *retval=malloc(size+1);
	if(retval){
		memcpy(retval,buffer+pos,size);
		retval[size]=0;
	}
	return retval;
}