/*************************************************************************
 * avinfo.c module selection and startup code [part of AVInfo 1.x]
 *
 * Copyright (c) 2003 George Shuklin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *   
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *   
 * You should have received a copy of the GNU General Public License along
 * with this program (see the file COPYING); if not, write to the Free 
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307  USA  or visit http://www.gnu.org/copyleft/gpl.html
 *
 *************************************************************************/
#include "avinfo.h"

int voidparse(FILE* f, int flags){
/*used for unsupported files*/
	return 1;
}


const module_t modules[]={
	{ 
		"wav\0"
		"avi\0"
		"riff\0",
		1,
		&riffparse
	},
	{
		"mpg\0"
		"mpeg\0"
		"m2v\0"
		"m1v\0"
		"vob\0",
		1,
		&mpegparse
	},
	{
		"smi\0"
		"ssa\0"
		"srt\0"
		"sub\0"
		"sami\0"
		"s2k\0",
		1,
		&textparse
	},
	{
		"mp3\0"
		"mp2\0",
		1,
		&mp3parse
	},{
		"mkv\0"
		"mks\0"
		"mka\0",
		1,
		&mkvparse

	},{
		"rm\0"
		"asf\0"
		"wmv\0",
		1,
		&voidparse	/*currently unsupported*/
	},
	{
		"ifo\0",
		1,
		&ifoparse
	},
	{
		"ogg\0"
		"ogm\0",
		1,
		&ogmparse
	}
		
};

#define ASS_PRINT do {\
	lexerctl.c=0;\
	lexerctl.flag=0;\
	lexerctl.active=1;\
	lexerctl.mode=0;\
	lexerctl.l=InitLineCache(output,GetNumericVar("linelength"),1);\
	processed_flag=0;\
	yyparse( &lexerctl );\
	CloseLineCache(lexerctl.l);\
} while (0);


int main( int argc, char* argv[] ){

	int         cnt=0;
	int 		tmp=0;
	int 		flags=0;
	unsigned int 		wait=0; /*delay between file scans*/
	lexerctl_t  lexerctl = { "", 0, 0, 1, 0,NULL };
	FILE*       file=NULL;
	FILE* 		filelist=NULL;
	FILE*		output=NULL;
	char*       curr_ext=NULL;
	int			processed_flag=0;
	char* 		flst_name=NULL;
	char* 		in_name=NULL;
	char* 		force_ext=NULL;
	char* 		ext	= NULL;
	char* 		outputname;
	struct{
		unsigned int total_time;
		unsigned int files_total;
		unsigned int files_processed;
		unsigned int min_x;
		unsigned int min_y;
		unsigned int min_fps;
		unsigned int min_v_bps;
		unsigned int min_a_bps;
		unsigned int sound_hz;
		unsigned int size; /*in 64k blocks*/
	}statistic={0,0,0,0,0,0,0,0,0,0};

	if( SetConfig( argc, argv ) ) return fprintf(stderr,"Error in command line\n");
	outputname=GetROStringVar("output");
	if(!*outputname) output=stdout;
	else {
		output=fopen(outputname,"w");
		if(!output) return fprintf(stderr, "Error opening output file %s\n",outputname);
	}
	flst_name=GetROStringVar("filelist");
	if(*flst_name){
		if(*flst_name=='-'&&!flst_name[1]) filelist=stdin;  /*GNU standart for stdin*/
		else {
			filelist=fopen(flst_name,"r");
			if(!filelist||(int)filelist==-1) return fprintf(stderr,"Error opening filelist: %s, error:%d \n",flst_name,(int)filelist);
		}
	}
	if(filelist) {
		lexerctl.line=GetROStringVar("tplhead");
		if(*lexerctl.line){
			ASS_PRINT;
		}
	}		
	wait=GetNumericVar("wait");
	lexerctl.line=GetROStringVar("template");	
	flags=GetNumericVar("moduleoption"); 
	if(!flags) flags=2; /*todo!! normal default*/
	do{
		if(filelist) {
			in_name=malloc(MAX_PATH+1);
			if(!fgets(in_name,MAX_PATH,filelist)) break;
			in_name[MAX_PATH]=0; /*in case we should get non zero line*/
			tmp=strlen(in_name);
			if(in_name[tmp-1]==0xA||in_name[tmp-1]==0xD) in_name[tmp-1]=0;
			if(in_name[tmp-2]==0xA||in_name[tmp-2]==0xD) in_name[tmp-2]=0;
			SetStringVar("in",dup(in_name));
		}
		else in_name=GetStringVar("in");
		statistic.files_total++;
		NamePrepare(in_name);
		force_ext=GetROStringVar("force_ext");
		ext=GetROStringVar("ext");
		if(!STRCMP(ext,GetROStringVar("ignore"))){FREE(in_name);continue;}
		for( cnt=0; !processed_flag && (cnt < sizeof(modules) / sizeof(modules[0]) ); cnt++ ){
			curr_ext = modules[cnt].mask;
			while( *curr_ext && !processed_flag){
				if((!*force_ext && !STRCMP(curr_ext,ext))||!STRCMP(curr_ext,force_ext)){
					file = fopen( in_name, "rb" );
					if( !file || (int)file==-1 ) {
						if(!filelist) return 1;
					}else{
						fseek( file, 0, SEEK_END );
						SetNumericVar( "size", ftell( file ) );
						rewind( file );
						processed_flag=modules[cnt].func( file , flags);
						fclose(file);
					}
				}
				curr_ext += strlen( curr_ext ) + 1; /* dirty hack. Heh (c) Guu */
			}
		}
		if(processed_flag){
			statistic.files_processed++;
			tmp=GetNumericVar("v1.l");
			if(tmp)
				statistic.total_time+=tmp;
			else statistic.total_time+=GetNumericVar("a1.l");
			tmp=GetNumericVar("v1.x");
			if((!statistic.min_x||statistic.min_x>tmp)&&tmp) statistic.min_x=tmp;
			tmp=GetNumericVar("v1.y");
			if((!statistic.min_y||statistic.min_y>tmp)&&tmp) statistic.min_y=tmp;
			tmp=GetNumericVar("v1.fpsH");
			if((!statistic.min_fps||statistic.min_fps>tmp)&&tmp) statistic.min_fps=tmp;
			tmp=GetNumericVar("v1.bps");
			if((!statistic.min_v_bps||statistic.min_v_bps>tmp)&&tmp) statistic.min_v_bps=tmp;
			tmp=GetNumericVar("a1.bps");
			if((!statistic.min_a_bps||statistic.min_a_bps>tmp)&&tmp) statistic.min_a_bps=tmp;
			tmp=GetNumericVar("a1.freq");
			if((!statistic.sound_hz||statistic.sound_hz>tmp)&&tmp) statistic.sound_hz=tmp;
			statistic.size+=GetNumericVar("size")/65536;
			ASS_PRINT;
			DelVar("stream.*");
			DelVar("a#.*");
			DelVar("v#.*");	
			DelVar("t#.*");
			DelVar("d##.*");
		}
		FREE(in_name);
		/*if(wait) sleep(wait);*/
	}while(filelist); 
	SetNumericVar("total.time",statistic.total_time);
	SetNumericVar("total.files",statistic.files_total);	
	SetNumericVar("total.processed",statistic.files_processed);
	SetNumericVar("total.minx",statistic.min_x);
	SetNumericVar("total.miny",statistic.min_y);
	SetNumericVar("total.minfps",statistic.min_fps);
	SetNumericVar("total.minvbps",statistic.min_v_bps);
	SetNumericVar("total.minabps",statistic.min_a_bps);
	SetNumericVar("total.minfreq",statistic.sound_hz);
	SetNumericVar("total.size",statistic.size/16384); /*in Gb*/
	if(filelist) {
		lexerctl.line=GetROStringVar("tplfoot");
		if(*lexerctl.line){
			ASS_PRINT;
		}
	}
	if(*outputname) fclose(output);
	return 0;
}
