/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.wizard.text.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.ClipBoardManager;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.export.LatexFieldFormatter;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.imports.FreeCiteImporter;
import net.sf.jabref.util.Util;
import net.sf.jabref.wizard.integrity.gui.IntegrityMessagePanel;
import net.sf.jabref.wizard.text.TagToMarkedTextStore;
import net.sf.jabref.wizard.text.gui.BasicAction;
import net.sf.jabref.wizard.text.gui.OverlayPanel;
import net.sf.jabref.wizard.text.gui.PopupListener;

public class TextInputDialog
extends JDialog
implements ActionListener {
    private final JButton okButton = new JButton();
    private final JButton cancelButton = new JButton();
    private final JButton insertButton = new JButton();
    private final JButton parseWithFreeCiteButton = new JButton();
    private final JPanel panel1 = new JPanel();
    private final JPanel buttons = new JPanel();
    private final JPanel rawPanel = new JPanel();
    private final JPanel sourcePanel = new JPanel();
    private final IntegrityMessagePanel warnPanel;
    private JList fieldList;
    private JRadioButton overRadio;
    private final BibtexEntry entry;
    private final JPopupMenu inputMenu = new JPopupMenu();
    private StyledDocument doc;
    private JTextPane textPane;
    private JTextArea preview;
    private final boolean inputChanged;
    private final TagToMarkedTextStore marked;
    private final JabRefFrame _frame;
    private boolean okPressed = false;

    public TextInputDialog(JabRefFrame jabRefFrame, BasePanel basePanel, String string, boolean bl, BibtexEntry bibtexEntry) {
        super(jabRefFrame, string, bl);
        this.warnPanel = new IntegrityMessagePanel(basePanel);
        this.inputChanged = true;
        this._frame = jabRefFrame;
        this.entry = bibtexEntry;
        this.marked = new TagToMarkedTextStore();
        try {
            this.jbInit(jabRefFrame);
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.updateSourceView();
    }

    private void jbInit(JabRefFrame jabRefFrame) {
        this.setModal(true);
        this.getContentPane().setLayout(new BorderLayout());
        String string = Globals.lang("for");
        if (this.entry != null && this.entry.getType() != null) {
            string = string + " " + this.entry.getType().getName();
        }
        this.setTitle(Globals.lang("Plain_text_import") + " " + string);
        this.getContentPane().add((Component)this.panel1, "Center");
        this.initRawPanel();
        this.initButtonPanel();
        this.initSourcePanel();
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (TextInputDialog.this.inputChanged) {
                    TextInputDialog.this.warnPanel.updateView(TextInputDialog.this.entry);
                }
            }
        });
        jTabbedPane.add((Component)this.rawPanel, Globals.lang("Raw_source"));
        jTabbedPane.add((Component)this.sourcePanel, Globals.lang("BibTeX_source"));
        jTabbedPane.add((Component)this.warnPanel, Globals.lang("Messages_and_Hints"));
        this.panel1.setLayout(new BorderLayout());
        this.panel1.add((Component)jTabbedPane, "Center");
        this.panel1.add((Component)this.buttons, "South");
        ActionMap actionMap = this.buttons.getActionMap();
        InputMap inputMap = this.buttons.getInputMap(2);
        inputMap.put(jabRefFrame.prefs().getKey("Close dialog"), "close");
        actionMap.put("close", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TextInputDialog.this.dispose();
            }
        });
    }

    private void initRawPanel() {
        this.rawPanel.setLayout(new BorderLayout());
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        this.doc = this.textPane.getStyledDocument();
        this.addStylesToDocument(this.doc);
        try {
            this.doc.insertString(0, "", this.doc.getStyle("regular"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        OverlayPanel overlayPanel = new OverlayPanel(this.textPane, Globals.lang("Text_Input_Area"));
        overlayPanel.setPreferredSize(new Dimension(450, 255));
        overlayPanel.setMaximumSize(new Dimension(450, Integer.MAX_VALUE));
        PasteAction pasteAction = new PasteAction();
        JMenuItem jMenuItem = new JMenuItem(pasteAction);
        this.inputMenu.add(new MenuHeaderAction());
        this.inputMenu.addSeparator();
        this.inputMenu.add(jMenuItem);
        PopupListener popupListener = new PopupListener(this.inputMenu);
        this.textPane.addMouseListener(popupListener);
        overlayPanel.addMouseListener(popupListener);
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(new ClearAction());
        jToolBar.setBorderPainted(false);
        jToolBar.addSeparator();
        jToolBar.add(pasteAction);
        jToolBar.add(new LoadAction());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jToolBar, "North");
        jPanel.add((Component)overlayPanel, "Center");
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.fill = 2;
        jPanel2.setLayout(gridBagLayout);
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 2), Globals.lang("Input"));
        jPanel2.setBorder(titledBorder);
        jPanel2.setMinimumSize(new Dimension(10, 10));
        this.fieldList = new JList<String>(this.getAllFields());
        this.fieldList.setCellRenderer(new SimpleCellRenderer(this.fieldList.getFont()));
        ListSelectionModel listSelectionModel = this.fieldList.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        listSelectionModel.addListSelectionListener(new FieldListSelectionHandler());
        this.fieldList.addMouseListener(new FieldListMouseListener());
        JScrollPane jScrollPane = new JScrollPane(this.fieldList);
        jScrollPane.setVerticalScrollBarPolicy(20);
        this.insertButton.setText(Globals.lang("Insert"));
        this.insertButton.addActionListener(this);
        this.parseWithFreeCiteButton.setText(Globals.lang("Parse with FreeCite"));
        this.parseWithFreeCiteButton.addActionListener(this);
        JRadioButton jRadioButton = new JRadioButton(Globals.lang("Append"));
        jRadioButton.setToolTipText(Globals.lang("append_the_selected_text_to_bibtex_key"));
        jRadioButton.setMnemonic(65);
        jRadioButton.setSelected(true);
        this.overRadio = new JRadioButton(Globals.lang("Override"));
        this.overRadio.setToolTipText(Globals.lang("override_the_bibtex_key_by_the_selected_text"));
        this.overRadio.setMnemonic(79);
        this.overRadio.setSelected(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(this.overRadio);
        JPanel jPanel3 = new JPanel(new GridLayout(0, 1));
        jPanel3.add(jRadioButton);
        jPanel3.add(this.overRadio);
        JLabel jLabel = new JLabel(Globals.lang("Available fields"));
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel2.add(jLabel);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 8;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel2.add(jScrollPane);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel2.add(jPanel3);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.insertButton, gridBagConstraints);
        jPanel2.add(this.insertButton);
        this.rawPanel.add((Component)jPanel, "Center");
        this.rawPanel.add((Component)jPanel2, "East");
        JLabel jLabel2 = new JLabel("<html><h3>" + Globals.lang("Plain text import") + "</h3><p>" + Globals.lang("This is a simple copy and paste dialog. First load or paste some text into the text input area.<br>After that, you can mark text and assign it to a BibTeX field.") + "</p></html>");
        jLabel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.rawPanel.add((Component)jLabel2, "South");
    }

    private void initButtonPanel() {
        this.okButton.setText(Globals.lang("Accept"));
        this.okButton.addActionListener(this);
        this.cancelButton.setText(Globals.lang("Cancel"));
        this.cancelButton.addActionListener(this);
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder(this.buttons);
        this.buttons.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton((JComponent)this.okButton);
        buttonBarBuilder.addButton((JComponent)this.parseWithFreeCiteButton);
        buttonBarBuilder.addButton((JComponent)this.cancelButton);
        buttonBarBuilder.addGlue();
    }

    private void initSourcePanel() {
        this.preview = new JTextArea();
        this.preview.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.preview);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setPreferredSize(new Dimension(500, 255));
        jScrollPane.setMinimumSize(new Dimension(10, 10));
        this.sourcePanel.setLayout(new BorderLayout());
        this.sourcePanel.add((Component)jScrollPane, "Center");
    }

    private void addStylesToDocument(StyledDocument styledDocument) {
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        Style style2 = styledDocument.addStyle("regular", style);
        StyleConstants.setFontFamily(style, "SansSerif");
        StyleConstants.setFontSize(style, 12);
        Style style3 = styledDocument.addStyle("oldused", style2);
        StyleConstants.setItalic(style3, true);
        StyleConstants.setForeground(style3, Color.blue);
        style3 = styledDocument.addStyle("used", style2);
        StyleConstants.setBold(style3, true);
        StyleConstants.setForeground(style3, Color.blue);
        style3 = styledDocument.addStyle("marked", style2);
        StyleConstants.setBold(style3, true);
        StyleConstants.setForeground(style3, Color.red);
        style3 = styledDocument.addStyle("small", style2);
        StyleConstants.setFontSize(style3, 10);
        style3 = styledDocument.addStyle("large", style2);
        StyleConstants.setFontSize(style3, 16);
    }

    private void insertTextForTag() {
        String string;
        String string2 = (String)this.fieldList.getSelectedValue();
        if (string2 != null && (string = this.textPane.getSelectedText()) != null) {
            int n = this.textPane.getSelectionStart();
            int n2 = this.textPane.getSelectionEnd();
            this.textPane.setSelectionEnd(n);
            this.doc.setCharacterAttributes(n, n2 - n, this.doc.getStyle("marked"), true);
            if (this.overRadio.isSelected()) {
                this.entry.setField(string2, string);
                this.marked.setStyleForTag(string2, "regular", this.doc);
                this.marked.insertPosition(string2, n, n2);
            } else {
                this.marked.appendPosition(string2, n, n2);
                String string3 = this.entry.getField(string2);
                if (string3 != null) {
                    if (string2.hashCode() == "author".hashCode()) {
                        this.entry.setField(string2, string3 + " and " + string);
                    } else {
                        this.entry.setField(string2, string3 + string);
                    }
                } else {
                    this.entry.setField(string2, string);
                }
            }
            this.updateSourceView();
        }
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okButton) {
            this.okPressed = true;
            this.dispose();
        } else if (object == this.cancelButton) {
            this.dispose();
        } else if (object == this.insertButton) {
            this.insertTextForTag();
        } else if (object == this.parseWithFreeCiteButton && this.parseWithFreeCiteAndAddEntries()) {
            this.okPressed = false;
            this.dispose();
        }
    }

    private boolean parseWithFreeCiteAndAddEntries() {
        FreeCiteImporter freeCiteImporter = new FreeCiteImporter();
        String string = this.textPane.getText();
        string = string.replace(Globals.NEWLINE.concat(Globals.NEWLINE), "##NEWLINE##");
        string = string.replace("/".concat(Globals.NEWLINE), "/");
        string = string.replace(Globals.NEWLINE, " ");
        List<BibtexEntry> list = freeCiteImporter.importEntries(string = string.replace("##NEWLINE##", Globals.NEWLINE), (OutputPrinter)JabRef.jrf);
        if (list != null) {
            Util.setAutomaticFields(list, false, false, true);
            for (BibtexEntry bibtexEntry : list) {
                JabRef.jrf.basePanel().insertEntry(bibtexEntry);
            }
            return true;
        }
        return false;
    }

    private void updateSourceView() {
        StringWriter stringWriter = new StringWriter(200);
        try {
            this.entry.write(stringWriter, new LatexFieldFormatter(), false);
            String string = stringWriter.getBuffer().toString();
            this.preview.setText(string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fieldList.clearSelection();
    }

    private String[] getAllFields() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.entry.getRequiredFields();
        String[] stringArray2 = this.entry.getOptionalFields();
        String[] stringArray3 = BibtexFields.getAllFieldNames();
        Collections.addAll(arrayList, stringArray);
        Collections.addAll(arrayList, stringArray2);
        for (String string : stringArray3) {
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private class FieldListMouseListener
    extends MouseAdapter {
        private FieldListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                TextInputDialog.this.insertTextForTag();
            }
        }
    }

    class SimpleCellRenderer
    extends DefaultListCellRenderer {
        private final Font baseFont;
        private final Font usedFont;
        private final ImageIcon okIcon = GUIGlobals.getImage("complete");
        private final ImageIcon needIcon = GUIGlobals.getImage("wrong");

        public SimpleCellRenderer(Font font) {
            this.baseFont = font;
            this.usedFont = this.baseFont.deriveFont(2);
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            String string = object.toString();
            if (TextInputDialog.this.entry.getField(string) != null) {
                this.setForeground(Color.gray);
                this.setFont(this.usedFont);
                this.setIcon(this.okIcon);
                this.setToolTipText("filled");
            } else {
                this.setIcon(this.needIcon);
                this.setToolTipText("field is missing");
            }
            return this;
        }
    }

    class FieldListSelectionHandler
    implements ListSelectionListener {
        private int lastIndex = -1;

        FieldListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            boolean bl;
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            int n = listSelectionModel.getAnchorSelectionIndex();
            if (n != this.lastIndex && !(bl = listSelectionEvent.getValueIsAdjusting())) {
                String string;
                if (this.lastIndex > -1) {
                    string = (String)TextInputDialog.this.fieldList.getModel().getElementAt(this.lastIndex);
                    TextInputDialog.this.marked.setStyleForTag(string, "used", TextInputDialog.this.doc);
                }
                string = (String)TextInputDialog.this.fieldList.getModel().getElementAt(n);
                TextInputDialog.this.marked.setStyleForTag(string, "marked", TextInputDialog.this.doc);
                this.lastIndex = n;
            }
        }
    }

    class MenuHeaderAction
    extends BasicAction {
        public MenuHeaderAction() {
            super("Edit");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    class ClearAction
    extends BasicAction {
        public ClearAction() {
            super("Clear", "Clear_inputarea", GUIGlobals.getIconUrl("new"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TextInputDialog.this.textPane.setText("");
        }
    }

    class LoadAction
    extends BasicAction {
        public LoadAction() {
            super("Open", "Open_file", GUIGlobals.getIconUrl("open"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = FileDialogs.getNewFile((JFrame)TextInputDialog.this._frame, null, null, ".txt", 0, false);
                if (string != null) {
                    File file = new File(string);
                    TextInputDialog.this.doc.remove(0, TextInputDialog.this.doc.getLength());
                    EditorKit editorKit = TextInputDialog.this.textPane.getEditorKit();
                    if (editorKit != null) {
                        editorKit.read(new FileInputStream(file), (Document)TextInputDialog.this.doc, 0);
                        TextInputDialog.this.doc.setLogicalStyle(0, TextInputDialog.this.doc.getStyle("regular"));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class PasteAction
    extends BasicAction {
        public PasteAction() {
            super("Paste", "Paste from clipboard", GUIGlobals.getIconUrl("paste"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = ClipBoardManager.clipBoard.getClipboardContents();
            if (string != null) {
                int n = TextInputDialog.this.textPane.getSelectionStart();
                int n2 = TextInputDialog.this.textPane.getSelectionEnd();
                if (n2 - n > 0) {
                    TextInputDialog.this.textPane.replaceSelection("");
                }
                int n3 = TextInputDialog.this.textPane.getCaretPosition();
                try {
                    TextInputDialog.this.doc.insertString(n3, string, TextInputDialog.this.doc.getStyle("regular"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

