/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.wizard.integrity;

import java.util.Vector;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.wizard.integrity.IntegrityMessage;

public class IntegrityCheck {
    private final Vector<IntegrityMessage> messages = new Vector();

    public Vector<IntegrityMessage> checkBibtexDatabase(BibtexDatabase bibtexDatabase) {
        this.messages.clear();
        if (bibtexDatabase != null) {
            for (BibtexEntry bibtexEntry : bibtexDatabase.getEntries()) {
                this.checkSingleEntry(bibtexEntry);
            }
        }
        return new Vector<IntegrityMessage>(this.messages);
    }

    public Vector<IntegrityMessage> checkBibtexEntry(BibtexEntry bibtexEntry) {
        this.messages.clear();
        this.checkSingleEntry(bibtexEntry);
        return new Vector<IntegrityMessage>(this.messages);
    }

    private void checkSingleEntry(BibtexEntry bibtexEntry) {
        if (bibtexEntry == null) {
            return;
        }
        String string = bibtexEntry.getField("author");
        if (string != null) {
            this.authorNameCheck(string.toString(), "author", bibtexEntry);
        }
        if ((string = bibtexEntry.getField("editor")) != null) {
            this.authorNameCheck(string.toString(), "editor", bibtexEntry);
        }
        if ((string = bibtexEntry.getField("title")) != null) {
            this.titleCheck(string.toString(), "title", bibtexEntry);
        }
        if ((string = bibtexEntry.getField("year")) != null) {
            this.yearCheck(string.toString(), "year", bibtexEntry);
        }
    }

    private void authorNameCheck(String string, String string2, BibtexEntry bibtexEntry) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        int n2 = -1;
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ',': {
                    if (n2 == 5) {
                        stringBuilder.append('a');
                    } else {
                        stringBuilder.append('N');
                    }
                    stringBuilder.append(',');
                    n2 = 0;
                    continue block7;
                }
                case ' ': {
                    if (n2 == 5) {
                        stringBuilder.append('a');
                    } else if (n2 != 0) {
                        stringBuilder.append('N');
                    }
                    n2 = -1;
                    continue block7;
                }
                case 'a': {
                    if (n2 != -1) continue block7;
                    n2 = 2;
                    continue block7;
                }
                case 'n': {
                    if (n2 != 2) continue block7;
                    n2 = 3;
                    continue block7;
                }
                case 'd': {
                    if (n2 != 3) continue block7;
                    n2 = 5;
                    continue block7;
                }
                default: {
                    n2 = 1;
                }
            }
        }
        if (n2 == 5) {
            stringBuilder.append('a');
        } else if (n2 != 0) {
            stringBuilder.append('N');
        }
        n = stringBuilder.length();
        if (n > 0) {
            if (stringBuilder.charAt(0) != 'N') {
                this.messages.add(new IntegrityMessage(1010, bibtexEntry, string2, null));
            }
            if (stringBuilder.charAt(stringBuilder.length() - 1) != 'N') {
                this.messages.add(new IntegrityMessage(1011, bibtexEntry, string2, null));
            }
        }
    }

    private void titleCheck(String string, String string2, BibtexEntry bibtexEntry) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        block5: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '}': {
                    if (n2 == 0) {
                        this.messages.add(new IntegrityMessage(2010, bibtexEntry, string2, null));
                        continue block5;
                    }
                    --n2;
                    continue block5;
                }
                case '{': {
                    ++n2;
                    continue block5;
                }
                case ' ': {
                    continue block5;
                }
                default: {
                    if (n2 != 0 || !Character.isUpperCase(c) || i <= 1) continue block5;
                    ++n3;
                }
            }
        }
        if (n3 > 0) {
            // empty if block
        }
    }

    private void yearCheck(String string, String string2, BibtexEntry bibtexEntry) {
        int n = string.length();
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c)) {
                bl = ++n2 == 4;
                continue;
            }
            if (bl) {
                bl2 = true;
            }
            n2 = 0;
        }
        if (!bl2 && !bl) {
            this.messages.add(new IntegrityMessage(11, bibtexEntry, string2, null));
        }
    }
}

