/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util.logging;

import java.util.LinkedList;
import java.util.Queue;

public class Cache {
    public static final int DEFAULT_CAPACITY = 500;
    private final int capacity;
    private final Queue<String> queue = new LinkedList<String>();
    private String cache = "";
    private boolean cacheRefreshNeeded = true;

    public Cache() {
        this(500);
    }

    public Cache(int n) {
        this.capacity = n;
    }

    public String get() {
        this.ensureCacheIsFresh();
        return this.cache;
    }

    private void ensureCacheIsFresh() {
        if (this.cacheRefreshNeeded) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : this.queue) {
                stringBuilder.append(string);
            }
            this.cache = stringBuilder.toString();
        }
    }

    public void add(String string) {
        this.queue.add(string);
        if (this.isCapacityExceeded()) {
            this.cacheRefreshNeeded = true;
            this.truncateLog();
        } else {
            this.cache = this.cache + string;
        }
    }

    private void truncateLog() {
        while (this.isCapacityExceeded()) {
            this.queue.poll();
        }
    }

    private boolean isCapacityExceeded() {
        return this.queue.size() > this.capacity;
    }
}

