/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

import java.util.Calendar;

public class YearUtil {
    private static final int CURRENT_YEAR = Calendar.getInstance().get(1);

    public static String toFourDigitYear(String string) {
        return YearUtil.toFourDigitYear(string, CURRENT_YEAR);
    }

    static String toFourDigitYear(String string, int n) {
        if (string == null || string.length() != 2) {
            return string;
        }
        try {
            int n2 = Integer.parseInt(string);
            return String.valueOf(new Year(n).toFourDigitYear(n2));
        }
        catch (NumberFormatException numberFormatException) {
            return string;
        }
    }

    private static class Year {
        private final int year;
        private final int century;
        private final int yearShort;

        public Year(int n) {
            this.year = n;
            this.yearShort = this.year % 100;
            this.century = this.year / 100 * 100;
        }

        int toFourDigitYear(int n) {
            if (n == this.yearShort) {
                return this.year;
            }
            if ((n + 100 - this.yearShort) % 100 > 30) {
                if (n < this.yearShort) {
                    return this.century + n;
                }
                return this.century - 100 + n;
            }
            if (n < this.yearShort) {
                return this.century + 100 + n;
            }
            return this.century + n;
        }
    }
}

