/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

import java.util.Arrays;
import java.util.List;
import net.sf.jabref.util.Util;

public class MonthUtil {
    private static final Month NULL_OBJECT = new UnknownMonth();
    private static final List<Month> months = Arrays.asList(new Month("January", "jan", "01", "#jan#", 1, 0), new Month("February", "feb", "02", "#feb#", 2, 1), new Month("March", "mar", "03", "#mar#", 3, 2), new Month("April", "apr", "04", "#apr#", 4, 3), new Month("May", "may", "05", "#may#", 5, 4), new Month("June", "jun", "06", "#jun#", 6, 5), new Month("July", "jul", "07", "#jul#", 7, 6), new Month("August", "aug", "08", "#aug#", 8, 7), new Month("September", "sep", "09", "#sep#", 9, 8), new Month("October", "oct", "10", "#oct#", 10, 9), new Month("November", "nov", "11", "#nov#", 11, 10), new Month("December", "dec", "12", "#dec#", 12, 11));

    public static Month getMonthByNumber(int n) {
        return MonthUtil.getMonthByIndex(n - 1);
    }

    public static Month getMonthByIndex(int n) {
        for (Month month : months) {
            if (month.index != n) continue;
            return month;
        }
        return NULL_OBJECT;
    }

    public static Month getMonthByShortName(String string) {
        for (Month month : months) {
            if (!month.shortName.equalsIgnoreCase(string)) continue;
            return month;
        }
        return NULL_OBJECT;
    }

    public static Month getMonth(String string) {
        Month month;
        if (string == null) {
            return NULL_OBJECT;
        }
        String string2 = string.replace("#", "").trim();
        if (string2.length() > 3) {
            string2 = string2.substring(0, 3);
        }
        if ((month = MonthUtil.getMonthByShortName(string2)).isValid()) {
            return month;
        }
        try {
            int n = Util.intValueOf(string);
            return MonthUtil.getMonthByNumber(n);
        }
        catch (NumberFormatException numberFormatException) {
            return NULL_OBJECT;
        }
    }

    private static class UnknownMonth
    extends Month {
        public UnknownMonth() {
            super(null, null, null, null, 0, -1);
        }

        @Override
        public boolean isValid() {
            return false;
        }
    }

    public static class Month {
        public final String fullName;
        public final String shortName;
        public final String twoDigitNumber;
        public final String bibtexFormat;
        public final int number;
        public final int index;

        public Month(String string, String string2, String string3, String string4, int n, int n2) {
            this.fullName = string;
            this.shortName = string2;
            this.twoDigitNumber = string3;
            this.bibtexFormat = string4;
            this.number = n;
            this.index = n2;
        }

        public boolean isValid() {
            return true;
        }
    }
}

