/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MnemonicAwareAction;
import net.sf.jabref.autocompleter.AutoCompleter;
import net.sf.jabref.gui.AutoCompleteListener;
import net.sf.jabref.specialfields.Printed;
import net.sf.jabref.specialfields.Priority;
import net.sf.jabref.specialfields.Quality;
import net.sf.jabref.specialfields.Rank;
import net.sf.jabref.specialfields.ReadStatus;
import net.sf.jabref.specialfields.Relevance;
import net.sf.jabref.specialfields.SpecialFieldsUtils;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.util.Util;

public class ManageKeywordsAction
extends MnemonicAwareAction {
    private final JabRefFrame frame;
    private JDialog diag = null;
    private JTextField keyword;
    private DefaultListModel keywordListModel;
    private JList keywordList;
    private JRadioButton intersectKeywords;
    private JRadioButton mergeKeywords;
    private boolean cancelled;
    private final TreeSet<String> sortedKeywordsOfAllEntriesBeforeUpdateByUser = new TreeSet();

    public ManageKeywordsAction(JabRefFrame jabRefFrame) {
        this.putValue("Name", "Manage keywords");
        this.frame = jabRefFrame;
    }

    private void createDialog() {
        this.keyword = new JTextField();
        this.keywordListModel = new DefaultListModel();
        this.keywordList = new JList(this.keywordListModel);
        this.keywordList.setVisibleRowCount(8);
        JScrollPane jScrollPane = new JScrollPane(this.keywordList);
        this.diag = new JDialog(this.frame, Globals.lang("Manage keywords"), true);
        JButton jButton = new JButton(Globals.lang("Ok"));
        JButton jButton2 = new JButton(Globals.lang("Cancel"));
        JButton jButton3 = new JButton(Globals.lang("Add"));
        JButton jButton4 = new JButton(Globals.lang("Remove"));
        this.keywordList.setVisibleRowCount(10);
        this.intersectKeywords = new JRadioButton("Display keywords appearing in ALL entries");
        this.mergeKeywords = new JRadioButton("Display keywords appearing in ANY entry");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.intersectKeywords);
        buttonGroup.add(this.mergeKeywords);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ManageKeywordsAction.this.fillKeyWordList();
            }
        };
        this.intersectKeywords.addActionListener(actionListener);
        this.mergeKeywords.addActionListener(actionListener);
        this.intersectKeywords.setSelected(true);
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("fill:200dlu, 4dlu, left:pref, 4dlu, left:pref", ""));
        defaultFormBuilder.appendSeparator(Globals.lang("Keywords of selected entries"));
        defaultFormBuilder.append((Component)this.intersectKeywords, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.mergeKeywords, 5);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)jScrollPane, 3);
        defaultFormBuilder.add(jButton4);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.keyword, 3);
        defaultFormBuilder.append(jButton3);
        defaultFormBuilder.nextLine();
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton((JComponent)jButton);
        buttonBarBuilder.addButton((JComponent)jButton2);
        buttonBarBuilder.addGlue();
        defaultFormBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonBarBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ManageKeywordsAction.this.cancelled = false;
                ManageKeywordsAction.this.diag.dispose();
            }
        });
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ManageKeywordsAction.this.cancelled = true;
                ManageKeywordsAction.this.diag.dispose();
            }
        };
        jButton2.addActionListener(abstractAction);
        final ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = ManageKeywordsAction.this.keyword.getText().trim();
                if (string.isEmpty()) {
                    return;
                }
                if (ManageKeywordsAction.this.keywordListModel.isEmpty()) {
                    ManageKeywordsAction.this.keywordListModel.addElement(string);
                } else {
                    int n;
                    String string2 = (String)ManageKeywordsAction.this.keywordListModel.getElementAt(n);
                    for (n = 0; n < ManageKeywordsAction.this.keywordListModel.size() && string2.compareTo(string) < 0; ++n) {
                    }
                    if (n == ManageKeywordsAction.this.keywordListModel.size()) {
                        ManageKeywordsAction.this.keywordListModel.addElement(string);
                    } else if (string2.compareTo(string) != 0) {
                        ManageKeywordsAction.this.keywordListModel.add(n, string);
                    }
                }
                ManageKeywordsAction.this.keyword.setText(null);
                ManageKeywordsAction.this.keyword.requestFocusInWindow();
            }
        };
        jButton3.addActionListener(actionListener2);
        final ActionListener actionListener3 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String[] stringArray;
                for (String string : stringArray = (String[])ManageKeywordsAction.this.keywordList.getSelectedValues()) {
                    ManageKeywordsAction.this.keywordListModel.removeElement(string);
                }
            }
        };
        jButton4.addActionListener(actionListener3);
        this.keywordList.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 127) {
                    actionListener3.actionPerformed(null);
                }
            }
        });
        AutoCompleter autoCompleter = JabRef.jrf.basePanel().getAutoCompleters().get("keywords");
        AutoCompleteListener autoCompleteListener = new AutoCompleteListener(autoCompleter);
        this.keyword.addKeyListener(autoCompleteListener);
        this.keyword.addFocusListener(autoCompleteListener);
        this.keyword.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    actionListener2.actionPerformed(null);
                }
            }
        });
        ActionMap actionMap = defaultFormBuilder.getPanel().getActionMap();
        InputMap inputMap = defaultFormBuilder.getPanel().getInputMap(2);
        inputMap.put(Globals.prefs.getKey("Close dialog"), "close");
        actionMap.put("close", abstractAction);
        this.diag.getContentPane().add((Component)defaultFormBuilder.getPanel(), "Center");
        this.diag.getContentPane().add((Component)buttonBarBuilder.getPanel(), "South");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object2;
        BasePanel basePanel = this.frame.basePanel();
        if (basePanel == null) {
            return;
        }
        if (basePanel.getSelectedEntries().length == 0) {
            return;
        }
        if (this.diag == null) {
            this.createDialog();
        }
        this.cancelled = true;
        this.fillKeyWordList();
        this.diag.pack();
        Util.placeDialog(this.diag, this.frame);
        this.diag.setVisible(true);
        if (this.cancelled) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        Object object3 = this.keywordListModel.elements();
        while (object3.hasMoreElements()) {
            object2 = (String)object3.nextElement();
            hashSet2.add((String)object2);
            if (this.sortedKeywordsOfAllEntriesBeforeUpdateByUser.contains(object2)) continue;
            hashSet.add((String)object2);
        }
        object3 = new HashSet();
        for (String object4 : this.sortedKeywordsOfAllEntriesBeforeUpdateByUser) {
            if (hashSet2.contains(object4)) continue;
            ((HashSet)object3).add(object4);
        }
        if (hashSet.isEmpty() && ((HashSet)object3).isEmpty()) {
            return;
        }
        if (SpecialFieldsUtils.keywordSyncEnabled() && !hashSet.isEmpty()) {
            object2 = this.createClone(hashSet);
            ((AbstractCollection)object2).retainAll(Priority.getInstance().getKeyWords());
            if (!((HashSet)object2).isEmpty()) {
                ((AbstractCollection)object3).addAll(Priority.getInstance().getKeyWords());
            }
            object2 = this.createClone(hashSet);
            ((AbstractCollection)object2).retainAll(Quality.getInstance().getKeyWords());
            if (!((HashSet)object2).isEmpty()) {
                ((AbstractCollection)object3).addAll(Quality.getInstance().getKeyWords());
            }
            object2 = this.createClone(hashSet);
            ((AbstractCollection)object2).retainAll(Rank.getInstance().getKeyWords());
            if (!((HashSet)object2).isEmpty()) {
                ((AbstractCollection)object3).addAll(Rank.getInstance().getKeyWords());
            }
            object2 = this.createClone(hashSet);
            ((AbstractCollection)object2).retainAll(Relevance.getInstance().getKeyWords());
            if (!((HashSet)object2).isEmpty()) {
                ((AbstractCollection)object3).addAll(Relevance.getInstance().getKeyWords());
            }
            object2 = this.createClone(hashSet);
            ((AbstractCollection)object2).retainAll(ReadStatus.getInstance().getKeyWords());
            if (!((HashSet)object2).isEmpty()) {
                ((AbstractCollection)object3).addAll(ReadStatus.getInstance().getKeyWords());
            }
            object2 = this.createClone(hashSet);
            ((AbstractCollection)object2).retainAll(Printed.getInstance().getKeyWords());
            if (!((HashSet)object2).isEmpty()) {
                ((AbstractCollection)object3).addAll(Printed.getInstance().getKeyWords());
            }
        }
        object2 = basePanel.getSelectedEntries();
        NamedCompound namedCompound = new NamedCompound(Globals.lang("Update keywords"));
        for (Object object : object2) {
            ArrayList<String> arrayList = Util.getSeparatedKeywords((BibtexEntry)object);
            TreeSet<String> treeSet = new TreeSet<String>();
            treeSet.addAll(arrayList);
            treeSet.removeAll((Collection<?>)object3);
            treeSet.addAll(hashSet);
            arrayList.clear();
            arrayList.addAll(treeSet);
            Util.putKeywords((BibtexEntry)object, arrayList, namedCompound);
            if (!SpecialFieldsUtils.keywordSyncEnabled()) continue;
            SpecialFieldsUtils.syncSpecialFieldsFromKeywords((BibtexEntry)object, namedCompound);
        }
        namedCompound.end();
        basePanel.undoManager.addEdit(namedCompound);
        basePanel.markBaseChanged();
    }

    private HashSet<String> createClone(HashSet<String> hashSet) {
        return (HashSet)hashSet.clone();
    }

    private void fillKeyWordList() {
        BasePanel basePanel = this.frame.basePanel();
        BibtexEntry[] bibtexEntryArray = basePanel.getSelectedEntries();
        this.keywordListModel.clear();
        this.sortedKeywordsOfAllEntriesBeforeUpdateByUser.clear();
        if (this.mergeKeywords.isSelected()) {
            for (BibtexEntry bibtexEntry2 : bibtexEntryArray) {
                ArrayList<String> arrayList = Util.getSeparatedKeywords(bibtexEntry2);
                this.sortedKeywordsOfAllEntriesBeforeUpdateByUser.addAll(arrayList);
            }
        } else {
            assert (this.intersectKeywords.isSelected());
            BibtexEntry bibtexEntry = bibtexEntryArray[0];
            ArrayList<String> arrayList = Util.getSeparatedKeywords(bibtexEntry);
            this.sortedKeywordsOfAllEntriesBeforeUpdateByUser.addAll(arrayList);
            for (int i = 1; i < bibtexEntryArray.length; ++i) {
                BibtexEntry bibtexEntry2;
                bibtexEntry2 = bibtexEntryArray[i];
                arrayList = Util.getSeparatedKeywords(bibtexEntry2);
                this.sortedKeywordsOfAllEntriesBeforeUpdateByUser.retainAll(arrayList);
            }
        }
        for (String string : this.sortedKeywordsOfAllEntriesBeforeUpdateByUser) {
            this.keywordListModel.addElement(string);
        }
    }
}

