/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableFieldChange;

public class DOIUtil {
    private static final String REGEXP_PLAINDOI = "\\b(10[.][0-9]{4,}(?:[.][0-9]+)*/(?:(?![\"&\\'])\\S)+)\\b";
    private static final Pattern PATTERN_PLAINDOI = Pattern.compile("\\b(10[.][0-9]{4,}(?:[.][0-9]+)*/(?:(?![\"&\\'])\\S)+)\\b");
    private static final String REGEXP_DOI_WITH_HTTP_PREFIX = "http[s]?://[^\\s]*?\\b(10[.][0-9]{4,}(?:[.][0-9]+)*/(?:(?![\"&\\'])\\S)+)\\b";

    public static boolean checkForDOIwithHTTPprefix(String string) {
        return string != null && string.matches(".*http[s]?://[^\\s]*?\\b(10[.][0-9]{4,}(?:[.][0-9]+)*/(?:(?![\"&\\'])\\S)+)\\b.*");
    }

    public static boolean checkForPlainDOI(String string) {
        return string != null && string.matches(".*\\b(10[.][0-9]{4,}(?:[.][0-9]+)*/(?:(?![\"&\\'])\\S)+)\\b.*");
    }

    public static String getDOI(String string) {
        Matcher matcher = PATTERN_PLAINDOI.matcher(string);
        if (matcher.find()) {
            return matcher.group();
        }
        return string;
    }

    public static void removeDOIfromBibtexEntryField(BibtexEntry bibtexEntry, String string, NamedCompound namedCompound) {
        String string2;
        String string3 = string2 = bibtexEntry.getField(string);
        string3 = string3.replaceAll(REGEXP_DOI_WITH_HTTP_PREFIX, "");
        string3 = string3.replaceAll(REGEXP_PLAINDOI, "");
        if ((string3 = string3.trim()).isEmpty()) {
            string3 = null;
        }
        if (!string2.equals(string3)) {
            namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, string, string2, string3));
            bibtexEntry.setField(string, string3);
        }
    }
}

