/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.util.StringUtil;

public class CaseChangers {
    private static final String SPACE_SEPARATOR = " ";
    public static final LowerCaseChanger LOWER = new LowerCaseChanger();
    public static final UpperCaseChanger UPPER = new UpperCaseChanger();
    public static final UpperFirstCaseChanger UPPER_FIRST = new UpperFirstCaseChanger();
    public static final UpperEachFirstCaseChanger UPPER_EACH_FIRST = new UpperEachFirstCaseChanger();
    public static final TitleCaseChanger TITLE = new TitleCaseChanger();
    public static final List<CaseChanger> ALL = Arrays.asList(LOWER, UPPER, UPPER_FIRST, UPPER_EACH_FIRST, TITLE);

    public static class TitleCaseChanger
    implements CaseChanger {
        private static final Set<String> notToCapitalize;

        @Override
        public String getName() {
            return "Title";
        }

        @Override
        public String changeCase(String string) {
            String string2 = string.toLowerCase();
            String[] stringArray = string2.split("\\s+");
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl;
                String string3 = stringArray[i];
                boolean bl2 = i == 0;
                boolean bl3 = bl = i == stringArray.length - 1;
                stringArray2[i] = bl2 || bl ? StringUtil.nCase(string3) : (notToCapitalize.contains(string3) ? string3 : StringUtil.nCase(string3));
            }
            return StringUtil.join(stringArray2, CaseChangers.SPACE_SEPARATOR);
        }

        static {
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(Arrays.asList("a", "an", "the", "and", "but", "or", "for", "nor", "as", "at", "by", "for", "from", "in", "into", "near", "of", "on", "onto", "to", "with"));
            notToCapitalize = Collections.unmodifiableSet(hashSet);
        }
    }

    public static class UpperEachFirstCaseChanger
    implements CaseChanger {
        @Override
        public String getName() {
            return "Upper Each First";
        }

        @Override
        public String changeCase(String string) {
            String string2 = string.toLowerCase();
            String[] stringArray = string2.split("\\s+");
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2[i] = StringUtil.nCase(stringArray[i]);
            }
            return StringUtil.join(stringArray2, CaseChangers.SPACE_SEPARATOR);
        }
    }

    public static class UpperFirstCaseChanger
    implements CaseChanger {
        private static final Pattern UF_PATTERN = Pattern.compile("\\b\\w");

        @Override
        public String getName() {
            return "Upper first";
        }

        @Override
        public String changeCase(String string) {
            String string2 = string.toLowerCase();
            Matcher matcher = UF_PATTERN.matcher(string2);
            if (matcher.find()) {
                return matcher.replaceFirst(matcher.group(0).toUpperCase());
            }
            return string;
        }
    }

    public static class UpperCaseChanger
    implements CaseChanger {
        @Override
        public String getName() {
            return "UPPER";
        }

        @Override
        public String changeCase(String string) {
            return string.toUpperCase();
        }
    }

    public static class LowerCaseChanger
    implements CaseChanger {
        @Override
        public String getName() {
            return "lower";
        }

        @Override
        public String changeCase(String string) {
            return string.toLowerCase();
        }
    }

    public static interface CaseChanger {
        public String getName();

        public String changeCase(String var1);
    }
}

