/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.undo;

import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexString;
import net.sf.jabref.Globals;

public class UndoableStringChange
extends AbstractUndoableEdit {
    private final BibtexString string;
    private final String oldValue;
    private final String newValue;
    private final boolean nameChange;
    private final BasePanel panel;

    public UndoableStringChange(BasePanel basePanel, BibtexString bibtexString, boolean bl, String string, String string2) {
        this.string = bibtexString;
        this.oldValue = string;
        this.newValue = string2;
        this.nameChange = bl;
        this.panel = basePanel;
    }

    @Override
    public String getUndoPresentationName() {
        return Globals.lang("Undo") + ": " + Globals.lang(this.nameChange ? "change string name" : "change string content");
    }

    @Override
    public String getRedoPresentationName() {
        return Globals.lang("Redo") + ": " + Globals.lang(this.nameChange ? "change string name" : "change string content");
    }

    @Override
    public void undo() {
        super.undo();
        this.panel.assureStringDialogNotEditing();
        if (this.nameChange) {
            this.string.setName(this.oldValue);
        } else {
            this.string.setContent(this.oldValue);
        }
        this.panel.updateStringDialog();
    }

    @Override
    public void redo() {
        super.redo();
        this.panel.assureStringDialogNotEditing();
        if (this.nameChange) {
            this.string.setName(this.newValue);
        } else {
            this.string.setContent(this.newValue);
        }
        this.panel.updateStringDialog();
    }
}

