/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.undo;

import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UndoableFieldChange
extends AbstractUndoableEdit {
    private static final long serialVersionUID = 1L;
    private final BibtexEntry entry;
    private final String field;
    private final String oldValue;
    private final String newValue;
    private static final Log LOGGER = LogFactory.getLog(UndoableFieldChange.class);

    public UndoableFieldChange(BibtexEntry bibtexEntry, String string, String string2, String string3) {
        this.entry = bibtexEntry;
        this.field = string;
        this.oldValue = string2;
        this.newValue = string3;
    }

    @Override
    public String getPresentationName() {
        return Globals.lang("change field");
    }

    @Override
    public String getUndoPresentationName() {
        return Globals.lang("Undo") + ": " + Globals.lang("change field");
    }

    @Override
    public String getRedoPresentationName() {
        return Globals.lang("Redo") + ": " + Globals.lang("change field");
    }

    @Override
    public void undo() {
        super.undo();
        try {
            if (this.oldValue != null) {
                this.entry.setField(this.field, this.oldValue);
            } else {
                this.entry.clearField(this.field);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.info("Cannot perform undo", illegalArgumentException);
        }
    }

    @Override
    public void redo() {
        super.redo();
        try {
            if (this.newValue != null) {
                this.entry.setField(this.field, this.newValue);
            } else {
                this.entry.clearField(this.field);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LOGGER.info("Cannot perform redo", illegalArgumentException);
        }
    }
}

