/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.sql;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import net.sf.jabref.Globals;
import net.sf.jabref.sql.DBStrings;

public class DBConnectDialog
extends JDialog {
    private final JComboBox cmbServerType = new JComboBox();
    private final JTextField txtServerHostname = new JTextField(40);
    private final JTextField txtDatabase = new JTextField(40);
    private final JTextField txtUsername = new JTextField(40);
    private final JPasswordField pwdPassword = new JPasswordField(40);
    private DBStrings dbStrings = new DBStrings();
    private boolean connectToDB = false;

    public DBConnectDialog(JFrame jFrame, DBStrings dBStrings) {
        super(jFrame, Globals.lang("Connect to SQL database"), true);
        this.setResizable(false);
        this.setLocationRelativeTo(jFrame);
        this.dbStrings = dBStrings;
        ArrayList<JLabel> arrayList = new ArrayList<JLabel>();
        JLabel jLabel = new JLabel();
        arrayList.add(jLabel);
        JLabel jLabel2 = new JLabel();
        arrayList.add(jLabel2);
        JLabel jLabel3 = new JLabel();
        arrayList.add(jLabel3);
        JLabel jLabel4 = new JLabel();
        arrayList.add(jLabel4);
        JLabel jLabel5 = new JLabel();
        arrayList.add(jLabel5);
        ArrayList<JComponent> arrayList2 = new ArrayList<JComponent>();
        arrayList2.add(this.cmbServerType);
        arrayList2.add(this.txtServerHostname);
        arrayList2.add(this.txtDatabase);
        arrayList2.add(this.txtUsername);
        arrayList2.add(this.pwdPassword);
        jLabel.setText(Globals.lang("Server Type :"));
        jLabel2.setText(Globals.lang("Server Hostname :"));
        jLabel3.setText(Globals.lang("Database :"));
        jLabel4.setText(Globals.lang("Username :"));
        jLabel5.setText(Globals.lang("Password :"));
        for (JLabel jComponent2 : arrayList) {
            jComponent2.setHorizontalAlignment(4);
        }
        JButton jButton = new JButton();
        jButton.setText(Globals.lang("Connect"));
        JButton jButton2 = new JButton();
        jButton2.setText(Globals.lang("Cancel"));
        String string = this.dbStrings.getServerType();
        String[] stringArray = this.dbStrings.getServerTypes();
        for (String string2 : stringArray) {
            this.cmbServerType.addItem(string2);
        }
        this.cmbServerType.setSelectedItem(string);
        this.txtServerHostname.setText(this.dbStrings.getServerHostname());
        this.txtDatabase.setText(this.dbStrings.getDatabase());
        this.txtUsername.setText(this.dbStrings.getUsername());
        this.pwdPassword.setText(this.dbStrings.getPassword());
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("right:pref, 4dlu, fill:pref", ""));
        defaultFormBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        defaultFormBuilder.append(jLabel);
        defaultFormBuilder.append(this.cmbServerType);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jLabel2);
        defaultFormBuilder.append(this.txtServerHostname);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jLabel3);
        defaultFormBuilder.append(this.txtDatabase);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jLabel4);
        defaultFormBuilder.append(this.txtUsername);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jLabel5);
        defaultFormBuilder.append(this.pwdPassword);
        defaultFormBuilder.nextLine();
        this.getContentPane().add((Component)defaultFormBuilder.getPanel(), "Center");
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton((JComponent)jButton);
        buttonBarBuilder.addButton((JComponent)jButton2);
        buttonBarBuilder.addGlue();
        this.getContentPane().add((Component)buttonBarBuilder.getPanel(), "South");
        this.pack();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = DBConnectDialog.this.checkInput();
                if (string == null) {
                    DBConnectDialog.this.storeSettings();
                    DBConnectDialog.this.setVisible(false);
                    DBConnectDialog.this.setConnectToDB(true);
                } else {
                    JOptionPane.showMessageDialog(null, string, "Input Error", 0);
                }
            }
        };
        jButton.addActionListener(actionListener);
        this.txtDatabase.addActionListener(actionListener);
        this.txtServerHostname.addActionListener(actionListener);
        this.txtUsername.addActionListener(actionListener);
        this.pwdPassword.addActionListener(actionListener);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DBConnectDialog.this.setVisible(false);
                DBConnectDialog.this.dispose();
                DBConnectDialog.this.setConnectToDB(false);
            }
        };
        jButton2.addActionListener(abstractAction);
        ActionMap actionMap = defaultFormBuilder.getPanel().getActionMap();
        InputMap inputMap = defaultFormBuilder.getPanel().getInputMap(2);
        inputMap.put(Globals.prefs.getKey("Close dialog"), "close");
        actionMap.put("close", abstractAction);
    }

    private String checkInput() {
        String[] stringArray = new String[]{"Server Hostname", "Database", "Username"};
        String[] stringArray2 = new String[stringArray.length];
        int n = 0;
        if (this.txtServerHostname.getText().trim().isEmpty()) {
            stringArray2[n] = stringArray[0];
            ++n;
        }
        if (this.txtDatabase.getText().trim().isEmpty()) {
            stringArray2[n] = stringArray[1];
            ++n;
        }
        if (this.txtUsername.getText().trim().isEmpty()) {
            stringArray2[n] = stringArray[2];
            ++n;
        }
        String string = Globals.lang("Please specify the ");
        switch (n) {
            case 0: {
                string = null;
                break;
            }
            case 1: {
                string = string + stringArray2[0] + '.';
                break;
            }
            case 2: {
                string = string + stringArray2[0] + " and " + stringArray2[1] + '.';
                break;
            }
            case 3: {
                string = string + stringArray2[0] + ", " + stringArray2[1] + ", and " + stringArray2[2] + '.';
                break;
            }
        }
        return string;
    }

    private void storeSettings() {
        this.dbStrings.setServerType(this.cmbServerType.getSelectedItem().toString());
        this.dbStrings.setServerHostname(this.txtServerHostname.getText());
        this.dbStrings.setDatabase(this.txtDatabase.getText());
        this.dbStrings.setUsername(this.txtUsername.getText());
        this.dbStrings.storeToPreferences();
        char[] cArray = this.pwdPassword.getPassword();
        String string = "";
        for (char c : cArray) {
            string = string + c;
        }
        this.dbStrings.setPassword(string);
        Arrays.fill(cArray, '0');
    }

    public DBStrings getDBStrings() {
        return this.dbStrings;
    }

    public void setDBStrings(DBStrings dBStrings) {
        this.dbStrings = dBStrings;
    }

    public boolean getConnectToDB() {
        return this.connectToDB;
    }

    private void setConnectToDB(boolean bl) {
        this.connectToDB = bl;
    }
}

