/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.specialfields;

import java.util.ArrayList;
import java.util.List;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.specialfields.Printed;
import net.sf.jabref.specialfields.Priority;
import net.sf.jabref.specialfields.Quality;
import net.sf.jabref.specialfields.Rank;
import net.sf.jabref.specialfields.ReadStatus;
import net.sf.jabref.specialfields.Relevance;
import net.sf.jabref.specialfields.SpecialField;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.util.Util;

public class SpecialFieldsUtils {
    public static final String FIELDNAME_PRIORITY = "priority";
    public static final String FIELDNAME_RANKING = "ranking";
    public static final String FIELDNAME_RELEVANCE = "relevance";
    public static final String FIELDNAME_QUALITY = "qualityassured";
    public static final String FIELDNAME_READ = "readstatus";
    public static final String FIELDNAME_PRINTED = "printed";
    public static final String PREF_SPECIALFIELDSENABLED = "specialFieldsEnabled";
    public static final Boolean PREF_SPECIALFIELDSENABLED_DEFAULT = Boolean.FALSE;
    public static final String PREF_SHOWCOLUMN_RANKING = "showRankingColumn";
    public static final Boolean PREF_SHOWCOLUMN_RANKING_DEFAULT = Boolean.TRUE;
    public static final String PREF_RANKING_COMPACT = "compactRankingColumn";
    public static final Boolean PREF_RANKING_COMPACT_DEFAULT = Boolean.TRUE;
    public static final String PREF_SHOWCOLUMN_PRIORITY = "showPriorityColumn";
    public static final Boolean PREF_SHOWCOLUMN_PRIORITY_DEFAULT = Boolean.FALSE;
    public static final String PREF_SHOWCOLUMN_RELEVANCE = "showRelevanceColumn";
    public static final Boolean PREF_SHOWCOLUMN_RELEVANCE_DEFAULT = Boolean.FALSE;
    public static final String PREF_SHOWCOLUMN_QUALITY = "showQualityColumn";
    public static final Boolean PREF_SHOWCOLUMN_QUALITY_DEFAULT = Boolean.FALSE;
    public static final String PREF_SHOWCOLUMN_READ = "showReadColumn";
    public static final Boolean PREF_SHOWCOLUMN_READ_DEFAULT = Boolean.FALSE;
    public static final String PREF_SHOWCOLUMN_PRINTED = "showPrintedColumn";
    public static final Boolean PREF_SHOWCOLUMN_PRINTED_DEFAULT = Boolean.FALSE;
    public static final String PREF_AUTOSYNCSPECIALFIELDSTOKEYWORDS = "autoSyncSpecialFieldsToKeywords";
    public static final Boolean PREF_AUTOSYNCSPECIALFIELDSTOKEYWORDS_DEFAULT = Boolean.FALSE;
    public static final String PREF_SERIALIZESPECIALFIELDS = "serializeSpecialFields";
    public static final Boolean PREF_SERIALIZESPECIALFIELDS_DEFAULT = Boolean.TRUE;

    public static void updateField(SpecialField specialField, String string, BibtexEntry bibtexEntry, NamedCompound namedCompound, boolean bl) {
        Util.updateField(bibtexEntry, specialField.getFieldName(), string, namedCompound, bl);
        SpecialFieldsUtils.exportFieldToKeywords(specialField, bibtexEntry.getField(specialField.getFieldName()), bibtexEntry, namedCompound);
    }

    private static void exportFieldToKeywords(SpecialField specialField, BibtexEntry bibtexEntry, NamedCompound namedCompound) {
        SpecialFieldsUtils.exportFieldToKeywords(specialField, bibtexEntry.getField(specialField.getFieldName()), bibtexEntry, namedCompound);
    }

    private static void exportFieldToKeywords(SpecialField specialField, String string, BibtexEntry bibtexEntry, NamedCompound namedCompound) {
        if (!SpecialFieldsUtils.keywordSyncEnabled()) {
            return;
        }
        ArrayList<String> arrayList = Util.getSeparatedKeywords(bibtexEntry);
        List<String> list = specialField.getKeyWords();
        int n = -1;
        for (String string2 : list) {
            int n2 = arrayList.indexOf(string2);
            if (n2 < 0) continue;
            n = n2;
            arrayList.remove(n2);
        }
        if (string != null) {
            if (n == -1) {
                arrayList.add(string);
            } else {
                arrayList.add(n, string);
            }
        }
        Util.putKeywords(bibtexEntry, arrayList, namedCompound);
    }

    public static void syncKeywordsFromSpecialFields(BibtexEntry bibtexEntry, NamedCompound namedCompound) {
        SpecialFieldsUtils.exportFieldToKeywords(Priority.getInstance(), bibtexEntry, namedCompound);
        SpecialFieldsUtils.exportFieldToKeywords(Rank.getInstance(), bibtexEntry, namedCompound);
        SpecialFieldsUtils.exportFieldToKeywords(Relevance.getInstance(), bibtexEntry, namedCompound);
        SpecialFieldsUtils.exportFieldToKeywords(Quality.getInstance(), bibtexEntry, namedCompound);
        SpecialFieldsUtils.exportFieldToKeywords(ReadStatus.getInstance(), bibtexEntry, namedCompound);
        SpecialFieldsUtils.exportFieldToKeywords(Printed.getInstance(), bibtexEntry, namedCompound);
    }

    private static void importKeywordsForField(ArrayList<String> arrayList, SpecialField specialField, BibtexEntry bibtexEntry, NamedCompound namedCompound) {
        List<String> list = specialField.getKeyWords();
        String string = null;
        for (String string2 : list) {
            if (!arrayList.contains(string2)) continue;
            string = string2;
            break;
        }
        Util.updateField(bibtexEntry, specialField.getFieldName(), string, namedCompound);
    }

    public static void syncSpecialFieldsFromKeywords(BibtexEntry bibtexEntry, NamedCompound namedCompound) {
        if (bibtexEntry.getField("keywords") == null) {
            return;
        }
        ArrayList<String> arrayList = Util.getSeparatedKeywords(bibtexEntry.getField("keywords"));
        SpecialFieldsUtils.importKeywordsForField(arrayList, Priority.getInstance(), bibtexEntry, namedCompound);
        SpecialFieldsUtils.importKeywordsForField(arrayList, Rank.getInstance(), bibtexEntry, namedCompound);
        SpecialFieldsUtils.importKeywordsForField(arrayList, Quality.getInstance(), bibtexEntry, namedCompound);
        SpecialFieldsUtils.importKeywordsForField(arrayList, Relevance.getInstance(), bibtexEntry, namedCompound);
        SpecialFieldsUtils.importKeywordsForField(arrayList, ReadStatus.getInstance(), bibtexEntry, namedCompound);
        SpecialFieldsUtils.importKeywordsForField(arrayList, Printed.getInstance(), bibtexEntry, namedCompound);
    }

    public static SpecialField getSpecialFieldInstanceFromFieldName(String string) {
        if (string.equals(FIELDNAME_PRIORITY)) {
            return Priority.getInstance();
        }
        if (string.equals(FIELDNAME_QUALITY)) {
            return Quality.getInstance();
        }
        if (string.equals(FIELDNAME_RANKING)) {
            return Rank.getInstance();
        }
        if (string.equals(FIELDNAME_RELEVANCE)) {
            return Relevance.getInstance();
        }
        if (string.equals(FIELDNAME_READ)) {
            return ReadStatus.getInstance();
        }
        if (string.equals(FIELDNAME_PRINTED)) {
            return Printed.getInstance();
        }
        return null;
    }

    public static boolean isSpecialField(String string) {
        return SpecialFieldsUtils.getSpecialFieldInstanceFromFieldName(string) != null;
    }

    public static boolean keywordSyncEnabled() {
        return Globals.prefs.getBoolean(PREF_SPECIALFIELDSENABLED) && Globals.prefs.getBoolean(PREF_AUTOSYNCSPECIALFIELDSTOKEYWORDS);
    }
}

