/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.specialfields;

import net.sf.jabref.BibtexEntry;
import net.sf.jabref.DatabaseChangeEvent;
import net.sf.jabref.DatabaseChangeListener;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRef;
import net.sf.jabref.specialfields.SpecialFieldsUtils;
import net.sf.jabref.undo.NamedCompound;

public class SpecialFieldDatabaseChangeListener
implements DatabaseChangeListener {
    private static SpecialFieldDatabaseChangeListener INSTANCE = null;

    @Override
    public void databaseChanged(DatabaseChangeEvent databaseChangeEvent) {
        if (databaseChangeEvent.getType() == DatabaseChangeEvent.ChangeType.ADDED_ENTRY && SpecialFieldsUtils.keywordSyncEnabled()) {
            BibtexEntry bibtexEntry = databaseChangeEvent.getEntry();
            NamedCompound namedCompound = new NamedCompound(Globals.lang("Synchronized special fields based on keywords"));
            SpecialFieldsUtils.syncSpecialFieldsFromKeywords(bibtexEntry, namedCompound);
            namedCompound.end();
            JabRef.jrf.basePanel().undoManager.addEdit(namedCompound);
        }
    }

    public static SpecialFieldDatabaseChangeListener getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SpecialFieldDatabaseChangeListener();
        }
        return INSTANCE;
    }
}

