/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.specialfields;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.ImageIcon;
import net.sf.jabref.specialfields.SpecialFieldValue;

public abstract class SpecialField {
    public String TEXT_DONE_PATTERN;
    private List<SpecialFieldValue> values;
    private List<String> keywords;
    private HashMap<String, SpecialFieldValue> map;

    void setValues(List<SpecialFieldValue> list) {
        this.values = list;
        this.keywords = new ArrayList<String>();
        this.map = new HashMap();
        for (SpecialFieldValue specialFieldValue : list) {
            if (specialFieldValue.getKeyword() != null) {
                this.keywords.add(specialFieldValue.getKeyword());
            }
            if (specialFieldValue.getFieldValue() == null) continue;
            this.map.put(specialFieldValue.getFieldValue(), specialFieldValue);
        }
    }

    public List<SpecialFieldValue> getValues() {
        return this.values;
    }

    public List<String> getKeyWords() {
        return this.keywords;
    }

    public SpecialFieldValue parse(String string) {
        return this.map.get(string);
    }

    public abstract String getFieldName();

    public abstract ImageIcon getRepresentingIcon();

    public abstract String getMenuString();

    public abstract String getToolTip();

    public boolean isSingleValueField() {
        return false;
    }
}

