/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.search.rules;

import java.util.List;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.export.layout.format.RemoveLatexCommands;
import net.sf.jabref.search.SearchRule;
import net.sf.jabref.search.rules.util.SentenceAnalyzer;

public class ContainBasedSearchRule
implements SearchRule {
    private static final RemoveLatexCommands REMOVE_LATEX_COMMANDS = new RemoveLatexCommands();
    private final boolean caseSensitive;

    public ContainBasedSearchRule(boolean bl) {
        this.caseSensitive = bl;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    @Override
    public boolean validateSearchStrings(String string) {
        return true;
    }

    @Override
    public boolean applyRule(String string, BibtexEntry bibtexEntry) {
        String string2 = string;
        if (!this.caseSensitive) {
            string2 = string2.toLowerCase();
        }
        List<String> list = new SentenceAnalyzer(string2).getWords();
        boolean[] blArray = new boolean[list.size()];
        for (String string3 : bibtexEntry.getAllFields()) {
            String string4 = bibtexEntry.getField(string3);
            if (string4 == null) continue;
            String string5 = REMOVE_LATEX_COMMANDS.format(string4.toString());
            if (!this.caseSensitive) {
                string5 = string5.toLowerCase();
            }
            int n = 0;
            for (String string6 : list) {
                blArray[n] = blArray[n] || string5.contains(string6);
                ++n;
            }
        }
        for (Object object : (Object)blArray) {
            if (object != false) continue;
            return false;
        }
        return true;
    }
}

