/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.remote.server;

import java.io.IOException;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.remote.server.MessageHandler;
import net.sf.jabref.remote.server.RemoteListenerServerThread;

public class RemoteListenerServerLifecycle {
    private RemoteListenerServerThread remoteListenerServerThread = null;

    public void stop() {
        if (this.isOpen()) {
            this.remoteListenerServerThread.interrupt();
            this.remoteListenerServerThread = null;
        }
    }

    public void open(MessageHandler messageHandler, int n) {
        RemoteListenerServerThread remoteListenerServerThread;
        if (this.isOpen()) {
            return;
        }
        try {
            remoteListenerServerThread = new RemoteListenerServerThread(messageHandler, n);
        }
        catch (IOException iOException) {
            if (!iOException.getMessage().startsWith("Address already in use")) {
                iOException.printStackTrace();
            }
            remoteListenerServerThread = null;
        }
        this.remoteListenerServerThread = remoteListenerServerThread;
    }

    public boolean isOpen() {
        return this.remoteListenerServerThread != null;
    }

    public void start() {
        if (this.isOpen() && this.isNotStartedBefore()) {
            JabRefExecutorService.INSTANCE.executeInOwnThread(this.remoteListenerServerThread);
        }
    }

    private boolean isNotStartedBefore() {
        return this.remoteListenerServerThread.getState() == Thread.State.NEW;
    }

    public void openAndStart(MessageHandler messageHandler, int n) {
        this.open(messageHandler, n);
        this.start();
    }
}

