/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.plugin;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import net.sf.jabref.Globals;
import net.sf.jabref.plugin.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.ObjectFactory;
import org.java.plugin.PluginManager;
import org.java.plugin.boot.DefaultPluginsCollector;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.standard.StandardPluginLocation;
import org.java.plugin.util.ExtendedProperties;

public class PluginCore {
    private static PluginManager singleton;
    static final File userPluginDir;
    private static final Log LOGGER;

    private static PluginManager.PluginLocation getLocationInsideJar(String string, String string2) {
        URL uRL = PluginCore.class.getResource(Util.joinPath(string, string2));
        if (uRL == null) {
            return null;
        }
        String string3 = uRL.getProtocol().toLowerCase();
        try {
            if (string3.startsWith("jar")) {
                return new StandardPluginLocation(new URL(uRL.toExternalForm().replaceFirst("!(.*?)$", Util.joinPath("!", string))), uRL);
            }
            if (string3.startsWith("file")) {
                File file = new File(uRL.toURI());
                return new StandardPluginLocation(file.getParentFile(), string2);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        return null;
    }

    private static PluginManager initialize() {
        ObjectFactory objectFactory = ObjectFactory.newInstance();
        PluginManager pluginManager = objectFactory.createManager();
        try {
            Comparable<StringBuilder> comparable;
            DefaultPluginsCollector defaultPluginsCollector = new DefaultPluginsCollector();
            ExtendedProperties extendedProperties = new ExtendedProperties();
            LinkedList<File> linkedList = new LinkedList<File>();
            linkedList.add(new File("./src/resources/plugins"));
            linkedList.add(new File("./plugins"));
            linkedList.add(userPluginDir);
            try {
                comparable = new File(PluginCore.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile();
                if (!((File)comparable).getCanonicalFile().equals(new File(".").getCanonicalFile())) {
                    linkedList.add(new File((File)comparable, "/src/resources/plugins"));
                    linkedList.add(new File((File)comparable, "/plugins"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            comparable = new StringBuilder();
            for (File stringArray2 : linkedList) {
                if (!stringArray2.exists()) continue;
                if (((StringBuilder)comparable).length() > 0) {
                    ((StringBuilder)comparable).append(',');
                }
                ((StringBuilder)comparable).append(stringArray2.getPath());
            }
            extendedProperties.setProperty("org.java.plugin.boot.pluginsRepositories", ((StringBuilder)comparable).toString());
            defaultPluginsCollector.configure(extendedProperties);
            Collection<PluginManager.PluginLocation> collection = defaultPluginsCollector.collectPluginLocations();
            String[] stringArray = new String[]{"/plugins/net.sf.jabref.core/", "/plugins/net.sf.jabref.export.misq/"};
            for (String string : stringArray) {
                PluginManager.PluginLocation pluginLocation = PluginCore.getLocationInsideJar(string, "plugin.xml");
                if (pluginLocation == null) continue;
                collection.add(pluginLocation);
            }
            if (collection.size() <= 0) {
                LOGGER.warn(Globals.lang("No plugins were found in the following folders:") + "\n  " + Util.join(linkedList.toArray(new String[linkedList.size()]), "\n  ", 0, linkedList.size()) + "\n" + Globals.lang("and inside the JabRef-jar:") + "\n  " + Util.join(stringArray, "\n  ", 0, stringArray.length) + "\n" + Globals.lang("At least the plug-in 'net.sf.jabref.core' should be there."));
            } else {
                pluginManager.publishPlugins(collection.toArray(new PluginManager.PluginLocation[collection.size()]));
                Collection<PluginDescriptor> collection2 = pluginManager.getRegistry().getPluginDescriptors();
                comparable = new StringBuilder();
                ((StringBuilder)comparable).append(Globals.lang("Found %0 plugin(s)", String.valueOf(collection2.size()))).append(":\n");
                for (PluginDescriptor pluginDescriptor : pluginManager.getRegistry().getPluginDescriptors()) {
                    ((StringBuilder)comparable).append("  - ").append(pluginDescriptor.getId()).append(" (").append(pluginDescriptor.getLocation()).append(")\n");
                }
                LOGGER.info(((StringBuilder)comparable).toString());
            }
        }
        catch (Exception exception) {
            LOGGER.error(Globals.lang("Error in starting plug-in system. Starting without, but some functionality may be missing.") + "\n" + exception.getLocalizedMessage());
        }
        return pluginManager;
    }

    public static PluginManager getManager() {
        if (singleton == null) {
            singleton = PluginCore.initialize();
        }
        return singleton;
    }

    static {
        userPluginDir = new File(System.getProperty("user.home") + "/.jabref/plugins");
        LOGGER = LogFactory.getLog(PluginCore.class);
    }
}

