/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.oo;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BrowseAction;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.SidePaneComponent;
import net.sf.jabref.SidePaneManager;
import net.sf.jabref.export.layout.Layout;
import net.sf.jabref.export.layout.LayoutHelper;
import net.sf.jabref.external.PushToApplication;
import net.sf.jabref.help.HelpAction;
import net.sf.jabref.oo.AdvancedCiteDialog;
import net.sf.jabref.oo.AutoDetectPaths;
import net.sf.jabref.oo.BibtexEntryNotFoundException;
import net.sf.jabref.oo.BstWrapper;
import net.sf.jabref.oo.CitationManager;
import net.sf.jabref.oo.ConnectionLostException;
import net.sf.jabref.oo.OOBibBase;
import net.sf.jabref.oo.OOBibStyle;
import net.sf.jabref.oo.StyleSelectDialog;
import net.sf.jabref.oo.UndefinedCharacterFormatException;
import net.sf.jabref.oo.UndefinedParagraphFormatException;
import net.sf.jabref.plugin.SidePanePlugin;

public class OpenOfficePanel
extends AbstractWorker
implements SidePanePlugin,
PushToApplication {
    public static final String defaultAuthorYearStylePath = "/resource/openoffice/default_authoryear.jstyle";
    public static final String defaultNumericalStylePath = "/resource/openoffice/default_numerical.jstyle";
    public static boolean postLayoutSupported = true;
    private OOPanel comp;
    private JDialog diag;
    private static JButton connect;
    private static JButton manualConnect;
    private static JButton selectDocument;
    private static final JButton setStyleFile;
    private static final JButton pushEntries;
    private static final JButton pushEntriesInt;
    private static final JButton pushEntriesEmpty;
    private static final JButton pushEntriesAdvanced;
    private static final JButton focus;
    private static JButton update;
    private static final JButton insertFullRef;
    private static final JButton merge;
    private static final JButton manageCitations;
    private static final JButton settingsB;
    private static final JButton help;
    private static final JButton test;
    private JRadioButton inPar;
    private JRadioButton inText;
    private JPanel settings = null;
    private static String styleFile;
    private static OOBibBase ooBase;
    private static JabRefFrame frame;
    private SidePaneManager manager;
    private static OOBibStyle style;
    private static boolean useDefaultAuthoryearStyle;
    private static boolean useDefaultNumericalStyle;
    private StyleSelectDialog styleDialog = null;
    private boolean dialogOkPressed = false;
    private boolean autoDetected = false;
    private String sOffice = null;
    private Throwable connectException = null;
    private static OpenOfficePanel instance;
    private static final Class[] parameters;

    public static OpenOfficePanel getInstance() {
        if (instance == null) {
            instance = new OpenOfficePanel();
        }
        return instance;
    }

    private OpenOfficePanel() {
        ImageIcon imageIcon = new ImageIcon(OpenOfficePanel.class.getResource("/images/connect_no.png"));
        connect = new JButton(imageIcon);
        manualConnect = new JButton(imageIcon);
        connect.setToolTipText(Globals.lang("Connect"));
        manualConnect.setToolTipText(Globals.lang("Manual connect"));
        selectDocument = new JButton(GUIGlobals.getImage("open"));
        selectDocument.setToolTipText(Globals.lang("Select Writer document"));
        update = new JButton(GUIGlobals.getImage("refresh"));
        update.setToolTipText(Globals.lang("Sync OO bibliography"));
        if (Globals.ON_WIN) {
            Globals.prefs.putDefaultValue("ooPath", "C:\\Program Files\\OpenOffice.org 3");
            Globals.prefs.putDefaultValue("ooExecutablePath", "C:\\Program Files\\OpenOffice.org 2.3\\program\\soffice.exe");
            Globals.prefs.putDefaultValue("ooJarsPath", "C:\\Program Files\\OpenOffice.org 2.3\\program\\classes");
        } else if (Globals.ON_MAC) {
            Globals.prefs.putDefaultValue("ooExecutablePath", "/Applications/OpenOffice.org.app/Contents/MacOS/soffice.bin");
            Globals.prefs.putDefaultValue("ooPath", "/Applications/OpenOffice.org.app");
            Globals.prefs.putDefaultValue("ooJarsPath", "/Applications/OpenOffice.org.app/Contents/basis-link");
        } else {
            Globals.prefs.putDefaultValue("ooPath", "/opt/openoffice.org3");
            Globals.prefs.putDefaultValue("ooExecutablePath", "/usr/lib/openoffice/program/soffice");
            Globals.prefs.putDefaultValue("ooJarsPath", "/opt/openoffice.org/basis3.0");
        }
        Globals.prefs.putDefaultValue("connectToOO3", Boolean.TRUE);
        Globals.prefs.putDefaultValue("ooStyleFileLastDir", System.getProperty("user.home"));
        Globals.prefs.putDefaultValue("ooInParCitation", true);
        Globals.prefs.putDefaultValue("syncOOWhenCiting", false);
        Globals.prefs.putDefaultValue("showOOPanel", false);
        Globals.prefs.putDefaultValue("useAllOpenBases", true);
        Globals.prefs.putDefaultValue("ooUseDefaultAuthoryearStyle", true);
        Globals.prefs.putDefaultValue("ooUseDefaultNumericalStyle", false);
        Globals.prefs.putDefaultValue("ooChooseStyleDirectly", false);
        Globals.prefs.putDefaultValue("ooDirectFile", "");
        Globals.prefs.putDefaultValue("ooStyleDirectory", "");
        styleFile = Globals.prefs.get("ooBibliographyStyleFile");
    }

    @Override
    public SidePaneComponent getSidePaneComponent() {
        return this.comp;
    }

    @Override
    public void init(JabRefFrame jabRefFrame, SidePaneManager sidePaneManager) {
        frame = jabRefFrame;
        this.manager = sidePaneManager;
        this.comp = new OOPanel(sidePaneManager, GUIGlobals.getIconUrl("openoffice"), Globals.lang("OpenOffice"));
        try {
            this.initPanel();
            sidePaneManager.register(this.getName(), this.comp);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public JMenuItem getMenuItem() {
        if (Globals.prefs.getBoolean("showOOPanel")) {
            this.manager.show(this.getName());
        }
        JMenuItem jMenuItem = new JMenuItem(Globals.lang("OpenOffice/LibreOffice connection"), GUIGlobals.getImage("openoffice"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OpenOfficePanel.this.manager.show(OpenOfficePanel.this.getName());
            }
        });
        return jMenuItem;
    }

    @Override
    public String getShortcutKey() {
        return null;
    }

    private void initPanel() {
        useDefaultAuthoryearStyle = Globals.prefs.getBoolean("ooUseDefaultAuthoryearStyle");
        useDefaultNumericalStyle = Globals.prefs.getBoolean("ooUseDefaultNumericalStyle");
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OpenOfficePanel.this.connect(true);
            }
        };
        connect.addActionListener(abstractAction);
        manualConnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OpenOfficePanel.this.connect(false);
            }
        });
        selectDocument.setToolTipText(Globals.lang("Select which open Writer document to work on"));
        selectDocument.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ooBase.selectDocument();
                    frame.output(Globals.lang("Connected to document") + ": " + ooBase.getCurrentDocumentTitle());
                }
                catch (Exception exception) {
                    JOptionPane.showMessageDialog(frame, exception.getMessage(), Globals.lang("Error"), 0);
                }
            }
        });
        setStyleFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (OpenOfficePanel.this.styleDialog == null) {
                    OpenOfficePanel.this.styleDialog = new StyleSelectDialog(frame, styleFile);
                }
                OpenOfficePanel.this.styleDialog.setVisible(true);
                if (OpenOfficePanel.this.styleDialog.isOkPressed()) {
                    useDefaultAuthoryearStyle = Globals.prefs.getBoolean("ooUseDefaultAuthoryearStyle");
                    useDefaultNumericalStyle = Globals.prefs.getBoolean("ooUseDefaultNumericalStyle");
                    styleFile = Globals.prefs.get("ooBibliographyStyleFile");
                    try {
                        OpenOfficePanel.this.readStyleFile();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        pushEntries.setToolTipText(Globals.lang("Cite selected entries"));
        pushEntries.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OpenOfficePanel.this.pushEntries(true, true, false);
            }
        });
        pushEntriesInt.setToolTipText(Globals.lang("Cite selected entries with in-text citation"));
        pushEntriesInt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OpenOfficePanel.this.pushEntries(false, true, false);
            }
        });
        pushEntriesEmpty.setToolTipText(Globals.lang("Insert a citation without text (the entry will appear in the reference list)"));
        pushEntriesEmpty.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OpenOfficePanel.this.pushEntries(false, false, false);
            }
        });
        pushEntriesAdvanced.setToolTipText(Globals.lang("Cite selected entries with extra information"));
        pushEntriesAdvanced.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OpenOfficePanel.this.pushEntries(false, true, true);
            }
        });
        focus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ooBase.setFocus();
            }
        });
        update.setToolTipText(Globals.lang("Ensure that the bibliography is up-to-date"));
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    try {
                        if (style == null) {
                            OpenOfficePanel.this.readStyleFile();
                        } else {
                            style.ensureUpToDate();
                        }
                    }
                    catch (Throwable throwable) {
                        JOptionPane.showMessageDialog(frame, Globals.lang("You must select either a valid style file, or use one of the default styles."), Globals.lang("No valid style file defined"), 0);
                        return;
                    }
                    ooBase.updateSortedReferenceMarks();
                    List list = OpenOfficePanel.this.getBaseList();
                    List<String> list2 = ooBase.refreshCiteMarkers(list, style);
                    ooBase.rebuildBibTextSection(list, style);
                    if (list2.size() > 0) {
                        JOptionPane.showMessageDialog(frame, Globals.lang("Your OpenOffice document references the BibTeX key '%0', which could not be found in your current database.", list2.get(0)), Globals.lang("Unable to synchronize bibliography"), 0);
                    }
                }
                catch (UndefinedCharacterFormatException undefinedCharacterFormatException) {
                    OpenOfficePanel.this.reportUndefinedCharacterFormat(undefinedCharacterFormatException);
                }
                catch (UndefinedParagraphFormatException undefinedParagraphFormatException) {
                    OpenOfficePanel.this.reportUndefinedParagraphFormat(undefinedParagraphFormatException);
                }
                catch (ConnectionLostException connectionLostException) {
                    OpenOfficePanel.this.showConnectionLostErrorMessage();
                }
                catch (BibtexEntryNotFoundException bibtexEntryNotFoundException) {
                    JOptionPane.showMessageDialog(frame, Globals.lang("Your OpenOffice document references the BibTeX key '%0', which could not be found in your current database.", bibtexEntryNotFoundException.getBibtexKey()), Globals.lang("Unable to synchronize bibliography"), 0);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        update.addActionListener(abstractAction2);
        insertFullRef.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    OpenOfficePanel.this.insertFullRefs();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        merge.setToolTipText(Globals.lang("Combine pairs of citations that are separated by spaces only"));
        merge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ooBase.combineCiteMarkers(OpenOfficePanel.this.getBaseList(), style);
                }
                catch (UndefinedCharacterFormatException undefinedCharacterFormatException) {
                    OpenOfficePanel.this.reportUndefinedCharacterFormat(undefinedCharacterFormatException);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        settingsB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OpenOfficePanel.this.showSettingsPopup();
            }
        });
        help.addActionListener(new HelpAction(Globals.helpDiag, "OpenOfficeIntegration.html"));
        manageCitations.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    CitationManager citationManager = new CitationManager(frame, ooBase);
                    citationManager.showDialog();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        test.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        selectDocument.setEnabled(false);
        pushEntries.setEnabled(false);
        pushEntriesInt.setEnabled(false);
        pushEntriesEmpty.setEnabled(false);
        pushEntriesAdvanced.setEnabled(false);
        focus.setEnabled(false);
        update.setEnabled(false);
        insertFullRef.setEnabled(false);
        merge.setEnabled(false);
        manageCitations.setEnabled(false);
        test.setEnabled(false);
        this.diag = new JDialog((Frame)null, "OpenOffice panel", false);
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("fill:pref:grow", "p,p,p,p,p,p,p,p,p,p"));
        DefaultFormBuilder defaultFormBuilder2 = new DefaultFormBuilder(new FormLayout("fill:pref:grow, 1dlu, fill:pref:grow, 1dlu, fill:pref:grow, 1dlu, fill:pref:grow, 1dlu, fill:pref:grow", ""));
        defaultFormBuilder2.append(connect);
        defaultFormBuilder2.append(manualConnect);
        defaultFormBuilder2.append(selectDocument);
        defaultFormBuilder2.append(update);
        defaultFormBuilder2.append(help);
        defaultFormBuilder.append(defaultFormBuilder2.getPanel());
        defaultFormBuilder.append(setStyleFile);
        defaultFormBuilder.append(pushEntries);
        defaultFormBuilder.append(pushEntriesInt);
        defaultFormBuilder.append(pushEntriesAdvanced);
        defaultFormBuilder.append(pushEntriesEmpty);
        defaultFormBuilder.append(merge);
        defaultFormBuilder.append(manageCitations);
        defaultFormBuilder.append(settingsB);
        JPanel jPanel = new JPanel();
        this.comp.setContentContainer(jPanel);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)defaultFormBuilder.getPanel(), "Center");
        frame.getTabbedPane().getInputMap(2).put(Globals.prefs.getKey("Refresh OO"), "Refresh OO");
        frame.getTabbedPane().getActionMap().put("Refresh OO", abstractAction2);
    }

    private List<BibtexDatabase> getBaseList() {
        ArrayList<BibtexDatabase> arrayList = new ArrayList<BibtexDatabase>();
        if (Globals.prefs.getBoolean("useAllOpenBases")) {
            for (int i = 0; i < frame.baseCount(); ++i) {
                arrayList.add(frame.baseAt(i).database());
            }
        } else {
            arrayList.add(frame.basePanel().database());
        }
        return arrayList;
    }

    private void connect(boolean bl) {
        int n;
        URL[] uRLArray;
        String string;
        String string2;
        Object object;
        if (bl) {
            object = new AutoDetectPaths(this.diag);
            if (object.runAutodetection()) {
                this.autoDetected = true;
                this.dialogOkPressed = true;
                this.diag.dispose();
            } else if (!object.cancelled()) {
                JOptionPane.showMessageDialog(this.diag, Globals.lang("Autodetection failed"), Globals.lang("Autodetection failed"), 0);
            }
            if (!this.autoDetected) {
                return;
            }
            string2 = Globals.prefs.get("ooUnoilPath");
            string = Globals.prefs.get("ooJurtPath");
            this.sOffice = Globals.prefs.get("ooExecutablePath");
        } else {
            this.showConnectDialog();
            if (!this.dialogOkPressed) {
                return;
            }
            object = Globals.prefs.get("ooPath");
            uRLArray = Globals.prefs.get("ooJarsPath");
            this.sOffice = Globals.prefs.get("ooExecutablePath");
            n = 1;
            if (Globals.ON_WIN) {
                string2 = (String)object + "\\Basis\\program\\classes";
                string = (String)object + "\\URE\\java";
                this.sOffice = (String)object + "\\program\\soffice.exe";
            } else if (Globals.ON_MAC) {
                this.sOffice = (String)object + "/Contents/MacOS/soffice.bin";
                string = (String)object + "/Contents/basis-link/ure-link/share/java";
                string2 = (String)object + "/Contents/basis-link/program/classes";
            } else {
                string2 = (String)uRLArray + "/program/classes";
                string = (String)uRLArray + "/ure-link/share/java";
            }
        }
        try {
            object = new File[]{new File(string2, "unoil.jar"), new File(string, "jurt.jar"), new File(string, "juh.jar"), new File(string, "ridl.jar")};
            uRLArray = new URL[((File[])object).length];
            for (n = 0; n < uRLArray.length; ++n) {
                if (!object[n].exists()) {
                    throw new Exception(Globals.lang("File not found") + ": " + object[n].getPath());
                }
                uRLArray[n] = object[n].toURI().toURL();
            }
            OpenOfficePanel.addURL(uRLArray);
            JDialog jDialog = new AutoDetectPaths(this.diag).showProgressDialog(this.diag, Globals.lang("Connecting"), Globals.lang("Please wait..."), false);
            this.getWorker().run();
            jDialog.dispose();
            this.diag.dispose();
            if (ooBase == null) {
                throw this.connectException;
            }
            if (ooBase.isConnectedToDocument()) {
                frame.output(Globals.lang("Connected to document") + ": " + ooBase.getCurrentDocumentTitle());
            }
            selectDocument.setEnabled(true);
            pushEntries.setEnabled(true);
            pushEntriesInt.setEnabled(true);
            pushEntriesEmpty.setEnabled(true);
            pushEntriesAdvanced.setEnabled(true);
            focus.setEnabled(true);
            update.setEnabled(true);
            insertFullRef.setEnabled(true);
            merge.setEnabled(true);
            manageCitations.setEnabled(true);
            test.setEnabled(true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (throwable instanceof UnsatisfiedLinkError) {
                JOptionPane.showMessageDialog(frame, Globals.lang("Unable to connect. One possible reason is that JabRef and OpenOffice/LibreOffice are not both running in either 32 bit mode or 64 bit mode."));
            }
            JOptionPane.showMessageDialog(frame, Globals.lang("Could not connect to running OpenOffice.\nMake sure you have installed OpenOffice with Java support.\nIf connecting manually, please verify program and library paths.\n\nError message: " + throwable.getMessage()));
        }
    }

    @Override
    public void run() {
        try {
            ooBase = new OOBibBase(this.sOffice, true);
        }
        catch (Throwable throwable) {
            ooBase = null;
            this.connectException = throwable;
        }
    }

    private void readStyleFile() throws Exception {
        if (useDefaultAuthoryearStyle) {
            URL uRL = JabRef.class.getResource(defaultAuthorYearStylePath);
            InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
            style = new OOBibStyle(inputStreamReader);
        } else if (useDefaultNumericalStyle) {
            URL uRL = JabRef.class.getResource(defaultNumericalStylePath);
            InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
            style = new OOBibStyle(inputStreamReader);
        } else {
            style = new OOBibStyle(new File(styleFile));
        }
    }

    private static void addURL(URL[] uRLArray) throws IOException {
        URLClassLoader uRLClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> clazz = URLClassLoader.class;
        try {
            Method method = clazz.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            for (URL uRL : uRLArray) {
                method.invoke((Object)uRLClassLoader, uRL);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    private void updateConnectionParams(String string, String string2, String string3, boolean bl) {
        Globals.prefs.put("ooPath", string);
        Globals.prefs.put("ooExecutablePath", string2);
        Globals.prefs.put("ooJarsPath", string3);
        Globals.prefs.putBoolean("connectToOO3", bl);
    }

    private void showConnectDialog() {
        this.dialogOkPressed = false;
        final JDialog jDialog = new JDialog(frame, Globals.lang("Set connection parameters"), true);
        final JTextField jTextField = new JTextField(30);
        JButton jButton = new JButton(Globals.lang("Browse"));
        jTextField.setText(Globals.prefs.get("ooPath"));
        final JTextField jTextField2 = new JTextField(30);
        JButton jButton2 = new JButton(Globals.lang("Browse"));
        jButton2.addActionListener(BrowseAction.buildForFile(jTextField2));
        final JTextField jTextField3 = new JTextField(30);
        JButton jButton3 = new JButton(Globals.lang("Browse"));
        jButton3.addActionListener(BrowseAction.buildForDir(jTextField3));
        jTextField2.setText(Globals.prefs.get("ooExecutablePath"));
        jTextField3.setText(Globals.prefs.get("ooJarsPath"));
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, fill:pref:grow, 4dlu, fill:pref", ""));
        if (Globals.ON_WIN || Globals.ON_MAC) {
            defaultFormBuilder.append(Globals.lang("Path to OpenOffice directory"));
            defaultFormBuilder.append(jTextField);
            defaultFormBuilder.append(jButton);
            defaultFormBuilder.nextLine();
        } else {
            defaultFormBuilder.append(Globals.lang("Path to OpenOffice executable"));
            defaultFormBuilder.append(jTextField2);
            defaultFormBuilder.append(jButton2);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(Globals.lang("Path to OpenOffice library dir"));
            defaultFormBuilder.append(jTextField3);
            defaultFormBuilder.append(jButton3);
            defaultFormBuilder.nextLine();
        }
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        JButton jButton4 = new JButton(Globals.lang("Ok"));
        JButton jButton5 = new JButton(Globals.lang("Cancel"));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OpenOfficePanel.this.updateConnectionParams(jTextField.getText(), jTextField2.getText(), jTextField3.getText(), true);
                jDialog.dispose();
            }
        };
        jTextField.addActionListener(actionListener);
        jTextField2.addActionListener(actionListener);
        jTextField3.addActionListener(actionListener);
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OpenOfficePanel.this.updateConnectionParams(jTextField.getText(), jTextField2.getText(), jTextField3.getText(), true);
                OpenOfficePanel.this.dialogOkPressed = true;
                jDialog.dispose();
            }
        });
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addButton((JComponent)jButton4);
        buttonBarBuilder.addButton((JComponent)jButton5);
        buttonBarBuilder.addGlue();
        defaultFormBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonBarBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jDialog.getContentPane().add((Component)defaultFormBuilder.getPanel(), "Center");
        jDialog.getContentPane().add((Component)buttonBarBuilder.getPanel(), "South");
        jDialog.pack();
        jDialog.setLocationRelativeTo(frame);
        jDialog.setVisible(true);
    }

    private void pushEntries(boolean bl, boolean bl2, boolean bl3) {
        BibtexEntry[] bibtexEntryArray;
        Object object;
        if (!ooBase.isConnectedToDocument()) {
            JOptionPane.showMessageDialog(frame, Globals.lang("Not connected to any Writer document. Please make sure a document is open, and use the 'Select Writer document' button to connect to it."), Globals.lang("Error"), 0);
            return;
        }
        String string = null;
        if (bl3) {
            object = new AdvancedCiteDialog(frame);
            ((AdvancedCiteDialog)object).showDialog();
            if (((AdvancedCiteDialog)object).cancelled()) {
                return;
            }
            if (((AdvancedCiteDialog)object).getPageInfo().length() > 0) {
                string = ((AdvancedCiteDialog)object).getPageInfo();
            }
            bl = ((AdvancedCiteDialog)object).isInParenthesisCite();
        }
        object = frame.basePanel();
        BibtexDatabase bibtexDatabase = ((BasePanel)object).database();
        if (object != null && (bibtexEntryArray = ((BasePanel)object).getSelectedEntries()).length > 0) {
            try {
                if (style == null) {
                    this.readStyleFile();
                }
                ooBase.insertEntry(bibtexEntryArray, bibtexDatabase, this.getBaseList(), style, bl, bl2, string, Globals.prefs.getBoolean("syncOOWhenCiting"));
            }
            catch (FileNotFoundException fileNotFoundException) {
                JOptionPane.showMessageDialog(frame, Globals.lang("You must select either a valid style file, or use one of the default styles."), Globals.lang("No valid style file defined"), 0);
            }
            catch (ConnectionLostException connectionLostException) {
                this.showConnectionLostErrorMessage();
            }
            catch (UndefinedCharacterFormatException undefinedCharacterFormatException) {
                this.reportUndefinedCharacterFormat(undefinedCharacterFormatException);
            }
            catch (UndefinedParagraphFormatException undefinedParagraphFormatException) {
                this.reportUndefinedParagraphFormat(undefinedParagraphFormatException);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void showConnectionLostErrorMessage() {
        JOptionPane.showMessageDialog(frame, Globals.lang("Connection to OpenOffice has been lost. Please make sure OpenOffice is running, and try to reconnect."), Globals.lang("Connection lost"), 0);
    }

    private void insertFullRefs() {
        try {
            BasePanel basePanel = frame.basePanel();
            BibtexDatabase bibtexDatabase = basePanel.database();
            LinkedHashMap<BibtexEntry, BibtexDatabase> linkedHashMap = new LinkedHashMap<BibtexEntry, BibtexDatabase>();
            if (basePanel != null) {
                BibtexEntry[] bibtexEntryArray = basePanel.getSelectedEntries();
                ArrayList arrayList = new ArrayList();
                for (BibtexEntry bibtexEntry : bibtexEntryArray) {
                    linkedHashMap.put(bibtexEntry, bibtexDatabase);
                }
                ooBase.insertFullReferenceAtViewCursor(linkedHashMap, style, "Default");
            }
        }
        catch (UndefinedParagraphFormatException undefinedParagraphFormatException) {
            this.reportUndefinedParagraphFormat(undefinedParagraphFormatException);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void reportUndefinedParagraphFormat(UndefinedParagraphFormatException undefinedParagraphFormatException) {
        JOptionPane.showMessageDialog(frame, "<html>" + Globals.lang("Your style file specifies the paragraph format '%0', which is undefined in your current OpenOffice document.", undefinedParagraphFormatException.getFormatName()) + "<br>" + Globals.lang("The paragraph format is controlled by the property 'ReferenceParagraphFormat' or 'ReferenceHeaderParagraphFormat' in the style file.") + "</html>", Globals.lang(""), 0);
    }

    private void reportUndefinedCharacterFormat(UndefinedCharacterFormatException undefinedCharacterFormatException) {
        JOptionPane.showMessageDialog(frame, "<html>" + Globals.lang("Your style file specifies the character format '%0', which is undefined in your current OpenOffice document.", undefinedCharacterFormatException.getFormatName()) + "<br>" + Globals.lang("The character format is controlled by the citation property 'CitationCharacterFormat' in the style file.") + "</html>", Globals.lang(""), 0);
    }

    public void insertUsingBST() {
        try {
            BasePanel basePanel = frame.basePanel();
            BibtexDatabase bibtexDatabase = basePanel.database();
            if (basePanel != null) {
                BibtexEntry[] bibtexEntryArray = basePanel.getSelectedEntries();
                ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
                Collections.addAll(arrayList, bibtexEntryArray);
                BstWrapper bstWrapper = new BstWrapper();
                bstWrapper.loadBstFile(new File("/home/usr/share/texmf-tetex/bibtex/bst/ams/amsalpha.bst"));
                Map<String, String> map = bstWrapper.processEntries(arrayList, bibtexDatabase);
                for (String string : map.keySet()) {
                    System.out.println("Key: " + string);
                    System.out.println("Entry: " + map.get(string));
                    ooBase.insertMarkedUpTextAtViewCursor(map.get(string), "Default");
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void showSettingsPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(Globals.lang("Automatically sync bibliography when inserting citations"), Globals.prefs.getBoolean("syncOOWhenCiting"));
        final JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(Globals.lang("Look up BibTeX entries in the active tab only"));
        final JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(Globals.lang("Look up BibTeX entries in all open databases"));
        JMenuItem jMenuItem = new JMenuItem(Globals.lang("Clear connection settings"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButtonMenuItem);
        buttonGroup.add(jRadioButtonMenuItem2);
        if (Globals.prefs.getBoolean("useAllOpenBases")) {
            jRadioButtonMenuItem2.setSelected(true);
        } else {
            jRadioButtonMenuItem.setSelected(true);
        }
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Globals.prefs.putBoolean("syncOOWhenCiting", jCheckBoxMenuItem.isSelected());
            }
        });
        jRadioButtonMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Globals.prefs.putBoolean("useAllOpenBases", jRadioButtonMenuItem2.isSelected());
            }
        });
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Globals.prefs.putBoolean("useAllOpenBases", !jRadioButtonMenuItem.isSelected());
            }
        });
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Globals.prefs.clear("ooPAth");
                Globals.prefs.clear("ooExecutablePath");
                Globals.prefs.clear("ooJarsPath");
                Globals.prefs.clear("connectToOO3");
                Globals.prefs.clear("ooUnoilPath");
                Globals.prefs.clear("ooJurtPath");
                frame.output(Globals.lang("Cleared connection settings."));
            }
        });
        jPopupMenu.add(jCheckBoxMenuItem);
        jPopupMenu.addSeparator();
        jPopupMenu.add(jRadioButtonMenuItem);
        jPopupMenu.add(jRadioButtonMenuItem2);
        jPopupMenu.addSeparator();
        jPopupMenu.add(jMenuItem);
        jPopupMenu.show(settingsB, 0, settingsB.getHeight());
    }

    private void pushEntries(boolean bl, BibtexEntry[] bibtexEntryArray) {
        BibtexDatabase bibtexDatabase = frame.basePanel().database();
        if (bibtexEntryArray.length > 0) {
            String string = null;
            AdvancedCiteDialog advancedCiteDialog = new AdvancedCiteDialog(frame);
            advancedCiteDialog.showDialog();
            if (advancedCiteDialog.cancelled()) {
                return;
            }
            if (advancedCiteDialog.getPageInfo().length() > 0) {
                string = advancedCiteDialog.getPageInfo();
            }
            bl = advancedCiteDialog.isInParenthesisCite();
            try {
                ooBase.insertEntry(bibtexEntryArray, bibtexDatabase, this.getBaseList(), style, bl, true, string, Globals.prefs.getBoolean("syncOOWhenCiting"));
            }
            catch (ConnectionLostException connectionLostException) {
                this.showConnectionLostErrorMessage();
            }
            catch (UndefinedCharacterFormatException undefinedCharacterFormatException) {
                this.reportUndefinedCharacterFormat(undefinedCharacterFormatException);
            }
            catch (UndefinedParagraphFormatException undefinedParagraphFormatException) {
                this.reportUndefinedParagraphFormat(undefinedParagraphFormatException);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public String getName() {
        return "Push to OpenOffice";
    }

    @Override
    public String getApplicationName() {
        return "OpenOffice";
    }

    @Override
    public String getTooltip() {
        return "Push selection to OpenOffice";
    }

    @Override
    public Icon getIcon() {
        return GUIGlobals.getImage("openoffice");
    }

    @Override
    public String getKeyStrokeName() {
        return null;
    }

    @Override
    public JPanel getSettingsPanel() {
        return null;
    }

    private void initSettingsPanel() {
        boolean bl = Globals.prefs.getBoolean("ooInParCitation");
        this.inPar = new JRadioButton(Globals.lang("Use in-parenthesis citation"), bl);
        this.inText = new JRadioButton(Globals.lang("Use in-text citation"), !bl);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.inPar);
        buttonGroup.add(this.inText);
        this.settings = new JPanel();
        this.settings.setLayout(new BorderLayout());
        this.settings.add((Component)this.inPar, "North");
        this.settings.add((Component)this.inText, "South");
    }

    @Override
    public void storeSettings() {
        Globals.prefs.putBoolean("ooInParCitation", this.inPar.isSelected());
    }

    @Override
    public void pushEntries(BibtexDatabase bibtexDatabase, BibtexEntry[] bibtexEntryArray, String string, MetaData metaData) {
        if (ooBase == null) {
            this.connect(true);
        }
        if (ooBase != null) {
            try {
                if (style == null) {
                    this.readStyleFile();
                }
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(frame, Globals.lang("You must select either a valid style file, or use one of the default styles."), Globals.lang("No valid style file defined"), 0);
                return;
            }
            this.pushEntries(Globals.prefs.getBoolean("ooInParCitation"), bibtexEntryArray);
        }
    }

    @Override
    public void operationCompleted(BasePanel basePanel) {
    }

    @Override
    public boolean requiresBibtexKeys() {
        return true;
    }

    static {
        try {
            Layout layout = new LayoutHelper(new StringReader("")).getLayoutFromText("net.sf.jabref.export.layout.format.");
            layout.setPostFormatter(null);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            postLayoutSupported = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        setStyleFile = new JButton(Globals.lang("Select style"));
        pushEntries = new JButton(Globals.lang("Cite"));
        pushEntriesInt = new JButton(Globals.lang("Cite in-text"));
        pushEntriesEmpty = new JButton(Globals.lang("Insert empty citation"));
        pushEntriesAdvanced = new JButton(Globals.lang("Cite special"));
        focus = new JButton("Focus OO document");
        insertFullRef = new JButton("Insert reference text");
        merge = new JButton(Globals.lang("Merge citations"));
        manageCitations = new JButton(Globals.lang("Manage citations"));
        settingsB = new JButton(Globals.lang("Settings"));
        help = new JButton(GUIGlobals.getImage("help"));
        test = new JButton("Test");
        styleFile = null;
        style = null;
        useDefaultAuthoryearStyle = false;
        useDefaultNumericalStyle = false;
        instance = null;
        parameters = new Class[]{URL.class};
    }

    class OOPanel
    extends SidePaneComponent {
        public OOPanel(SidePaneManager sidePaneManager, URL uRL, String string) {
            super(sidePaneManager, uRL, string);
        }

        @Override
        public String getName() {
            return OpenOfficePanel.this.getName();
        }

        @Override
        public void componentClosing() {
            Globals.prefs.putBoolean("showOOPanel", false);
        }

        @Override
        public void componentOpening() {
            Globals.prefs.putBoolean("showOOPanel", true);
        }
    }
}

