/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.oo;

import com.sun.star.awt.FontSlant;
import com.sun.star.beans.Property;
import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XDesktop;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.text.XParagraphCursor;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.export.layout.Layout;
import net.sf.jabref.oo.OOPreFormatter;
import net.sf.jabref.oo.OpenOfficePanel;
import net.sf.jabref.oo.UndefinedParagraphFormatException;

class OOUtil {
    private static final Pattern htmlTag = Pattern.compile("</?[a-z]+>");
    static final OOPreFormatter postformatter = new OOPreFormatter();

    OOUtil() {
    }

    public static void insertFullReferenceAtCurrentLocation(XText xText, XTextCursor xTextCursor, Layout layout, String string, BibtexEntry bibtexEntry, BibtexDatabase bibtexDatabase, String string2) throws Exception {
        String string3 = bibtexEntry.getField("uniq");
        bibtexEntry.setField("uniq", string2);
        String string4 = layout.doLayout(bibtexEntry, bibtexDatabase);
        bibtexEntry.setField("uniq", string3);
        OOUtil.insertOOFormattedTextAtCurrentLocation(xText, xTextCursor, string4, string);
    }

    public static void insertOOFormattedTextAtCurrentLocation(XText xText, XTextCursor xTextCursor, String string, String string2) throws Exception {
        XParagraphCursor xParagraphCursor = UnoRuntime.queryInterface(XParagraphCursor.class, (Object)xTextCursor);
        XPropertySet xPropertySet = UnoRuntime.queryInterface(XPropertySet.class, (Object)xParagraphCursor);
        try {
            xPropertySet.setPropertyValue("ParaStyleName", string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UndefinedParagraphFormatException(string2);
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        Matcher matcher = htmlTag.matcher(string);
        while (matcher.find()) {
            String string3;
            String string4 = string.substring(n, matcher.start());
            if (string4.length() > 0) {
                OOUtil.insertTextAtCurrentLocation(xText, xTextCursor, string4, n3 % 2 > 0, n2 % 2 > 0, n6 > 0, n7 > 0, n4 > 0, n5 > 0);
            }
            if ((string3 = matcher.group()).equals("<b>")) {
                ++n3;
            } else if (string3.equals("</b>")) {
                --n3;
            } else if (string3.equals("<i>") || string3.equals("<em>")) {
                ++n2;
            } else if (string3.equals("</i>") || string3.equals("</em>")) {
                --n2;
            } else if (string3.equals("</monospace>")) {
                n6 = 0;
            } else if (string3.equals("<monospace>")) {
                n6 = 1;
            } else if (string3.equals("</smallcaps>")) {
                n7 = 0;
            } else if (string3.equals("<smallcaps>")) {
                n7 = 1;
            } else if (string3.equals("</sup>")) {
                n4 = 0;
            } else if (string3.equals("<sup>")) {
                n4 = 1;
            } else if (string3.equals("</sub>")) {
                n5 = 0;
            } else if (string3.equals("<sub>")) {
                n5 = 1;
            }
            n = matcher.end();
        }
        if (n < string.length()) {
            OOUtil.insertTextAtCurrentLocation(xText, xTextCursor, string.substring(n), n3 % 2 > 0, n2 % 2 > 0, n6 > 0, n7 > 0, n4 > 0, n5 > 0);
        }
        xTextCursor.collapseToEnd();
    }

    public static void insertParagraphBreak(XText xText, XTextCursor xTextCursor) throws Exception {
        xText.insertControlCharacter(xTextCursor, (short)0, true);
        xTextCursor.collapseToEnd();
    }

    public static void insertTextAtCurrentLocation(XText xText, XTextCursor xTextCursor, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws Exception {
        xText.insertString(xTextCursor, string, true);
        XPropertySet xPropertySet = UnoRuntime.queryInterface(XPropertySet.class, (Object)xTextCursor);
        if (bl) {
            xPropertySet.setPropertyValue("CharWeight", Float.valueOf(150.0f));
        } else {
            xPropertySet.setPropertyValue("CharWeight", Float.valueOf(100.0f));
        }
        if (bl2) {
            xPropertySet.setPropertyValue("CharPosture", FontSlant.ITALIC);
        } else {
            xPropertySet.setPropertyValue("CharPosture", FontSlant.NONE);
        }
        if (bl4) {
            xPropertySet.setPropertyValue("CharCaseMap", (short)4);
        } else {
            xPropertySet.setPropertyValue("CharCaseMap", (short)0);
        }
        if (bl6) {
            xPropertySet.setPropertyValue("CharEscapement", (byte)-101);
            xPropertySet.setPropertyValue("CharEscapementHeight", (byte)58);
        } else if (bl5) {
            xPropertySet.setPropertyValue("CharEscapement", (byte)101);
            xPropertySet.setPropertyValue("CharEscapementHeight", (byte)58);
        } else {
            xPropertySet.setPropertyValue("CharEscapement", (byte)0);
            xPropertySet.setPropertyValue("CharEscapementHeight", (byte)100);
        }
        xTextCursor.collapseToEnd();
    }

    public static void insertTextAtCurrentLocation(XText xText, XTextCursor xTextCursor, String string, String string2) throws Exception {
        xText.insertString(xTextCursor, string, true);
        XParagraphCursor xParagraphCursor = UnoRuntime.queryInterface(XParagraphCursor.class, (Object)xTextCursor);
        XPropertySet xPropertySet = UnoRuntime.queryInterface(XPropertySet.class, (Object)xParagraphCursor);
        try {
            xPropertySet.setPropertyValue("ParaStyleName", string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UndefinedParagraphFormatException(string2);
        }
        xTextCursor.collapseToEnd();
    }

    public static Object getProperty(Object object, String string) throws Exception {
        XPropertySet xPropertySet = UnoRuntime.queryInterface(XPropertySet.class, object);
        return xPropertySet.getPropertyValue(string);
    }

    public static void listProperties(Object object) throws Exception {
        Property[] propertyArray;
        XPropertySet xPropertySet = UnoRuntime.queryInterface(XPropertySet.class, object);
        for (Property property : propertyArray = xPropertySet.getPropertySetInfo().getProperties()) {
            System.out.println(property.Name + " : " + xPropertySet.getPropertyValue(property.Name));
        }
    }

    public static XTextDocument selectComponent(JFrame jFrame, XDesktop xDesktop, List<XTextDocument> list) throws Exception {
        String[] stringArray = new String[list.size()];
        int n = 0;
        for (XTextDocument xTextDocument : list) {
            stringArray[n] = String.valueOf(OOUtil.getProperty(xTextDocument.getCurrentController().getFrame(), "Title"));
            ++n;
        }
        JList<String> jList = new JList<String>(stringArray);
        jList.setSelectionMode(0);
        jList.setSelectedIndex(0);
        int n2 = JOptionPane.showConfirmDialog(jFrame, new JScrollPane(jList), Globals.lang("Select document"), 2);
        if (n2 == 0) {
            return list.get(jList.getSelectedIndex());
        }
        return null;
    }

    public static BibtexEntry createAdaptedEntry(BibtexEntry bibtexEntry) {
        if (bibtexEntry == null) {
            return null;
        }
        BibtexEntry bibtexEntry2 = (BibtexEntry)bibtexEntry.clone();
        for (String string : bibtexEntry2.getAllFields()) {
            if (string.equals("bibtexkey")) continue;
            String string2 = bibtexEntry2.getField(string);
            if (OpenOfficePanel.postLayoutSupported || string2 == null) continue;
            bibtexEntry2.setField(string, postformatter.format(string2));
        }
        return bibtexEntry2;
    }
}

