/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.oo;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.export.layout.Layout;
import net.sf.jabref.export.layout.LayoutFormatter;
import net.sf.jabref.export.layout.LayoutHelper;
import net.sf.jabref.oo.OOPreFormatter;

class OOBibStyle
implements Comparable<OOBibStyle> {
    public static final String UNDEFINED_CITATION_MARKER = "??";
    private String name = null;
    private final SortedSet<String> journals = new TreeSet<String>();
    private final LayoutFormatter fieldFormatter = new OOPreFormatter();
    private Layout defaultBibLayout;
    private final HashMap<String, Layout> bibLayout = new HashMap();
    private final HashMap<String, Object> properties = new HashMap();
    private final HashMap<String, Object> citProperties = new HashMap();
    private final Pattern numPattern = Pattern.compile("-?\\d+");
    private boolean valid = false;
    private static final int NONE = 0;
    private static final int LAYOUT = 1;
    private static final int PROPERTIES = 2;
    private static final int CITATION = 3;
    private static final int NAME = 4;
    private static final int JOURNALS = 5;
    private static final String LAYOUT_MRK = "LAYOUT";
    private static final String PROPERTIES_MARK = "PROPERTIES";
    private static final String CITATION_MARK = "CITATION";
    private static final String NAME_MARK = "NAME";
    private static final String JOURNALS_MARK = "JOURNALS";
    private static final String DEFAULT_MARK = "default";
    private File styleFile = null;
    private static long styleFileModificationTime = Long.MIN_VALUE;
    private final Pattern quoted = Pattern.compile("\".*\"");

    public OOBibStyle(File file) throws Exception {
        this(new FileReader(file));
        this.styleFile = file;
        styleFileModificationTime = file.lastModified();
    }

    public OOBibStyle(Reader reader) throws Exception {
        this.properties.put("Title", "Bibliography");
        this.properties.put("SortAlgorithm", "alphanumeric");
        this.properties.put("IsSortByPosition", Boolean.FALSE);
        this.properties.put("IsNumberEntries", Boolean.FALSE);
        this.properties.put("BracketBefore", "[");
        this.properties.put("BracketAfter", "]");
        this.properties.put("ReferenceParagraphFormat", "Default");
        this.properties.put("ReferenceHeaderParagraphFormat", "Heading 1");
        this.citProperties.put("AuthorField", "author/editor");
        this.citProperties.put("YearField", "year");
        this.citProperties.put("MaxAuthors", 3);
        this.citProperties.put("MaxAuthorsFirst", -1);
        this.citProperties.put("AuthorSeparator", ", ");
        this.citProperties.put("AuthorLastSeparator", " & ");
        this.citProperties.put("AuthorLastSeparatorInText", null);
        this.citProperties.put("EtAlString", " et al.");
        this.citProperties.put("YearSeparator", ", ");
        this.citProperties.put("InTextYearSeparator", " ");
        this.citProperties.put("BracketBefore", "(");
        this.citProperties.put("BracketAfter", ")");
        this.citProperties.put("CitationSeparator", "; ");
        this.citProperties.put("PageInfoSeparator", "; ");
        this.citProperties.put("GroupedNumbersSeparator", "-");
        this.citProperties.put("MinimumGroupingCount", 3);
        this.citProperties.put("FormatCitations", Boolean.FALSE);
        this.citProperties.put("CitationCharacterFormat", "Default");
        this.citProperties.put("ItalicCitations", Boolean.FALSE);
        this.citProperties.put("BoldCitations", Boolean.FALSE);
        this.citProperties.put("SuperscriptCitations", Boolean.FALSE);
        this.citProperties.put("SubscriptCitations", Boolean.FALSE);
        this.citProperties.put("MultiCiteChronological", Boolean.TRUE);
        this.citProperties.put("BibtexKeyCitations", Boolean.FALSE);
        this.citProperties.put("ItalicEtAl", Boolean.FALSE);
        this.initialize(reader);
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.styleFile;
    }

    public Set<String> getJournals() {
        return Collections.unmodifiableSet(this.journals);
    }

    private void initialize(Reader reader) throws IOException {
        this.name = null;
        this.readFormatFile(reader);
    }

    public void ensureUpToDate() throws Exception {
        if (!this.isUpToDate()) {
            this.reload();
        }
    }

    private void reload() throws Exception {
        if (this.styleFile != null) {
            styleFileModificationTime = this.styleFile.lastModified();
            this.initialize(new FileReader(this.styleFile));
        }
    }

    private boolean isUpToDate() {
        if (this.styleFile != null) {
            return this.styleFile.lastModified() == styleFileModificationTime;
        }
        return true;
    }

    private void readFormatFile(Reader reader) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = reader.read()) != -1) {
            stringBuffer.append((char)n);
        }
        String[] stringArray = stringBuffer.toString().split("\n");
        int n2 = 0;
        block8: for (String string : stringArray) {
            String string2 = string;
            if (string2.length() > 0 && string2.charAt(string2.length() - 1) == '\r') {
                string2 = string2.substring(0, string2.length() - 1);
            }
            if (string2.trim().length() == 0 || string2.charAt(0) == '#') continue;
            if (string2.equals(NAME_MARK)) {
                n2 = 4;
                continue;
            }
            if (string2.equals(LAYOUT_MRK)) {
                n2 = 1;
                continue;
            }
            if (string2.equals(PROPERTIES_MARK)) {
                n2 = 2;
                continue;
            }
            if (string2.equals(CITATION_MARK)) {
                n2 = 3;
                continue;
            }
            if (string2.equals(JOURNALS_MARK)) {
                n2 = 5;
                continue;
            }
            switch (n2) {
                case 4: {
                    if (string2.trim().length() > 0) {
                        this.name = string2.trim();
                    }
                }
                case 1: {
                    this.handleStructureLine(string2);
                    continue block8;
                }
                case 2: {
                    this.handlePropertiesLine(string2, this.properties);
                    continue block8;
                }
                case 3: {
                    this.handlePropertiesLine(string2, this.citProperties);
                    continue block8;
                }
                case 5: {
                    this.handleJournalsLine(string2);
                }
            }
        }
        if (n2 != 0) {
            this.valid = true;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    private void handleStructureLine(String string) {
        int n = string.indexOf("=");
        if (n > 0 && n < string.length() - 1) {
            String string2 = string.substring(n + 1);
            boolean bl = string.substring(0, n).equals(DEFAULT_MARK);
            String string3 = string.substring(0, n);
            try {
                Layout layout = new LayoutHelper(new StringReader(string2)).getLayoutFromText("net.sf.jabref.export.layout.format.");
                if (bl) {
                    this.defaultBibLayout = layout;
                } else {
                    this.bibLayout.put(string3.toLowerCase(), layout);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void handlePropertiesLine(String string, HashMap<String, Object> hashMap) {
        int n = string.indexOf("=");
        if (n > 0 && n <= string.length() - 1) {
            String string2 = string.substring(0, n).trim();
            String string3 = string.substring(n + 1);
            if (string3.trim().length() > 2 && this.quoted.matcher(string3.trim()).matches()) {
                string3 = string3.trim().substring(1, string3.trim().length() - 1);
            }
            Object object = string3;
            if (this.numPattern.matcher(string3).matches()) {
                object = Integer.parseInt(string3);
            } else if (string3.toLowerCase().trim().equals("true")) {
                object = Boolean.TRUE;
            } else if (string3.toLowerCase().trim().equals("false")) {
                object = Boolean.FALSE;
            }
            hashMap.put(string2, object);
        }
    }

    private void handleJournalsLine(String string) {
        if (string.trim().length() > 0) {
            this.journals.add(string.trim());
        }
    }

    public Layout getReferenceFormat(String string) {
        Layout layout = this.bibLayout.get(string.toLowerCase());
        if (layout != null) {
            return layout;
        }
        return this.defaultBibLayout;
    }

    public String getNumCitationMarker(int[] nArray, int n, boolean bl) {
        String string = (String)this.citProperties.get("BracketBefore");
        if (bl && this.citProperties.get("BracketBeforeInList") != null) {
            string = (String)this.citProperties.get("BracketBeforeInList");
        }
        String string2 = (String)this.citProperties.get("BracketAfter");
        if (bl && this.citProperties.get("BracketAfterInList") != null) {
            string2 = (String)this.citProperties.get("BracketAfterInList");
        }
        int[] nArray2 = new int[nArray.length];
        System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
        Arrays.sort(nArray2);
        StringBuilder stringBuilder = new StringBuilder(string);
        int n2 = -1;
        int n3 = 0;
        for (int i = 0; i < nArray2.length; ++i) {
            int n4 = nArray2[i];
            if (n2 < 0) {
                if (i < nArray2.length - 1 && nArray2[i + 1] == n4 + 1) {
                    n2 = n4;
                    continue;
                }
                if (i > 0) {
                    stringBuilder.append((String)this.citProperties.get("CitationSeparator"));
                }
                stringBuilder.append(nArray2[i] > 0 ? String.valueOf(nArray2[i]) : UNDEFINED_CITATION_MARKER);
                ++n3;
                continue;
            }
            if (i != nArray2.length - 1 && nArray2[i + 1] == n4 + 1) continue;
            if (n3 > 0) {
                stringBuilder.append((String)this.citProperties.get("CitationSeparator"));
            }
            if (n > 0 && n4 + 1 - n2 >= n) {
                stringBuilder.append(n2);
                stringBuilder.append((String)this.citProperties.get("GroupedNumbersSeparator"));
                stringBuilder.append(n4);
                ++n3;
            } else {
                for (int j = n2; j <= n4; ++j) {
                    stringBuilder.append(j);
                    if (j < n4) {
                        stringBuilder.append((String)this.citProperties.get("CitationSeparator"));
                    }
                    ++n3;
                }
            }
            n2 = -1;
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    public String getCitationMarker(BibtexEntry bibtexEntry, BibtexDatabase bibtexDatabase, boolean bl, String string, int n) {
        return this.getCitationMarker(new BibtexEntry[]{bibtexEntry}, bibtexDatabase, bl, new String[]{string}, new int[]{n});
    }

    public String getCitationMarker(BibtexEntry[] bibtexEntryArray, BibtexDatabase bibtexDatabase, boolean bl, String[] stringArray, int[] nArray) {
        String string;
        int n = -1;
        String string2 = null;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] != null && stringArray[i].length() > 0) {
                    int n2;
                    string = (String)this.citProperties.get("AuthorField");
                    int n3 = (Integer)this.citProperties.get("MaxAuthors");
                    if (n == -1) {
                        n = i;
                        string2 = this.getAuthorYearParenthesisMarker(new BibtexEntry[]{bibtexEntryArray[i]}, bibtexDatabase, string, (String)this.citProperties.get("YearField"), n3, (String)this.citProperties.get("AuthorSeparator"), (String)this.citProperties.get("AuthorLastSeparator"), (String)this.citProperties.get("EtAlString"), (String)this.citProperties.get("YearSeparator"), (String)this.citProperties.get("BracketBefore"), (String)this.citProperties.get("BracketAfter"), (String)this.citProperties.get("CitationSeparator"), null, nArray);
                        continue;
                    }
                    String string3 = this.getAuthorYearParenthesisMarker(new BibtexEntry[]{bibtexEntryArray[i]}, bibtexDatabase, string, (String)this.citProperties.get("YearField"), n3, (String)this.citProperties.get("AuthorSeparator"), (String)this.citProperties.get("AuthorLastSeparator"), (String)this.citProperties.get("EtAlString"), (String)this.citProperties.get("YearSeparator"), (String)this.citProperties.get("BracketBefore"), (String)this.citProperties.get("BracketAfter"), (String)this.citProperties.get("CitationSeparator"), null, nArray);
                    String string4 = this.getCitationMarkerField(bibtexEntryArray[i], bibtexDatabase, string);
                    AuthorList authorList = AuthorList.getAuthorList(string4);
                    int n4 = n2 = i > 0 ? nArray[i - 1] : nArray[0];
                    if (string3.equals(string2) && (authorList.size() <= n3 || nArray[i] == n2)) continue;
                    if (n > -1 && i > n + 1) {
                        this.group(bibtexEntryArray, stringArray, n, i - 1, (String)this.citProperties.get("UniquefierSeparator"));
                    }
                    string2 = string3;
                    n = i;
                    continue;
                }
                if (n > -1 && i > n + 1) {
                    this.group(bibtexEntryArray, stringArray, n, i - 1, (String)this.citProperties.get("UniquefierSeparator"));
                }
                n = -1;
            }
            if (n >= 0) {
                this.group(bibtexEntryArray, stringArray, n, stringArray.length - 1, (String)this.citProperties.get("UniquefierSeparator"));
            }
        }
        if (bl) {
            return this.getAuthorYearParenthesisMarker(bibtexEntryArray, bibtexDatabase, (String)this.citProperties.get("AuthorField"), (String)this.citProperties.get("YearField"), (Integer)this.citProperties.get("MaxAuthors"), (String)this.citProperties.get("AuthorSeparator"), (String)this.citProperties.get("AuthorLastSeparator"), (String)this.citProperties.get("EtAlString"), (String)this.citProperties.get("YearSeparator"), (String)this.citProperties.get("BracketBefore"), (String)this.citProperties.get("BracketAfter"), (String)this.citProperties.get("CitationSeparator"), stringArray, nArray);
        }
        String string5 = (String)this.citProperties.get("AuthorLastSeparator");
        string = (String)this.citProperties.get("AuthorLastSeparatorInText");
        if (string != null) {
            string5 = string;
        }
        return this.getAuthorYearInTextMarker(bibtexEntryArray, bibtexDatabase, (String)this.citProperties.get("AuthorField"), (String)this.citProperties.get("YearField"), (Integer)this.citProperties.get("MaxAuthors"), (String)this.citProperties.get("AuthorSeparator"), string5, (String)this.citProperties.get("EtAlString"), (String)this.citProperties.get("InTextYearSeparator"), (String)this.citProperties.get("BracketBefore"), (String)this.citProperties.get("BracketAfter"), (String)this.citProperties.get("CitationSeparator"), stringArray, nArray);
    }

    private void group(BibtexEntry[] bibtexEntryArray, String[] stringArray, int n, int n2, String string) {
        StringBuilder stringBuilder = new StringBuilder(stringArray[n]);
        for (int i = n + 1; i <= n2; ++i) {
            stringBuilder.append(string);
            stringBuilder.append(stringArray[i]);
            bibtexEntryArray[i] = null;
        }
        stringArray[n] = stringBuilder.toString();
    }

    private String getAuthorYearParenthesisMarker(BibtexEntry[] bibtexEntryArray, BibtexDatabase bibtexDatabase, String string, String string2, int n, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String[] stringArray, int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer(string7);
        for (int i = 0; i < bibtexEntryArray.length; ++i) {
            Object object;
            String string10;
            int n2 = nArray != null ? nArray[i] : -1;
            int n3 = n2 > 0 ? n2 : n;
            BibtexEntry bibtexEntry = bibtexEntryArray[i];
            if (bibtexEntry == null) continue;
            if (i > 0) {
                stringBuffer.append(string9);
            }
            if ((string10 = this.getCitationMarkerField(bibtexEntry, bibtexDatabase, string)) != null) {
                object = AuthorList.getAuthorList(string10);
                stringBuffer.append(this.getAuthorLastName((AuthorList)object, 0));
                if (((AuthorList)object).size() > 1 && (((AuthorList)object).size() <= n3 || n3 < 0)) {
                    for (int j = 1; j < ((AuthorList)object).size() - 1; ++j) {
                        stringBuffer.append(string3);
                        stringBuffer.append(this.getAuthorLastName((AuthorList)object, j));
                    }
                    stringBuffer.append(string4);
                    stringBuffer.append(this.getAuthorLastName((AuthorList)object, ((AuthorList)object).size() - 1));
                } else if (((AuthorList)object).size() > n3) {
                    stringBuffer.append(string5);
                }
                stringBuffer.append(string6);
            }
            if ((object = this.getCitationMarkerField(bibtexEntry, bibtexDatabase, string2)) != null) {
                stringBuffer.append((String)object);
            }
            if (stringArray == null || stringArray[i] == null) continue;
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append(string8);
        return stringBuffer.toString();
    }

    private String getAuthorYearInTextMarker(BibtexEntry[] bibtexEntryArray, BibtexDatabase bibtexDatabase, String string, String string2, int n, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String[] stringArray, int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < bibtexEntryArray.length; ++i) {
            Object object;
            String string10;
            int n2;
            int n3 = nArray != null ? nArray[i] : -1;
            int n4 = n2 = n3 > 0 ? n3 : n;
            if (bibtexEntryArray[i] == null) continue;
            if (i > 0) {
                stringBuffer.append(string9);
            }
            if ((string10 = this.getCitationMarkerField(bibtexEntryArray[i], bibtexDatabase, string)) != null) {
                object = AuthorList.getAuthorList(string10);
                if (((AuthorList)object).size() > 0) {
                    stringBuffer.append(this.getAuthorLastName((AuthorList)object, 0));
                }
                if (((AuthorList)object).size() > 1 && (((AuthorList)object).size() <= n2 || n2 < 0)) {
                    for (int j = 1; j < ((AuthorList)object).size() - 1; ++j) {
                        stringBuffer.append(string3);
                        stringBuffer.append(this.getAuthorLastName((AuthorList)object, j));
                    }
                    stringBuffer.append(string4);
                    stringBuffer.append(this.getAuthorLastName((AuthorList)object, ((AuthorList)object).size() - 1));
                } else if (((AuthorList)object).size() > n2) {
                    stringBuffer.append(string5);
                }
                stringBuffer.append(string6);
            }
            stringBuffer.append(string7);
            object = this.getCitationMarkerField(bibtexEntryArray[i], bibtexDatabase, string2);
            if (object != null) {
                stringBuffer.append((String)object);
            }
            if (stringArray != null && stringArray[i] != null) {
                stringBuffer.append(stringArray[i]);
            }
            stringBuffer.append(string8);
        }
        return stringBuffer.toString();
    }

    private String getCitationMarkerField(BibtexEntry bibtexEntry, BibtexDatabase bibtexDatabase, String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.split("/")) {
            String string3 = BibtexDatabase.getResolvedField(string2, bibtexEntry, bibtexDatabase);
            if (string3 == null || string3.trim().length() <= 0) continue;
            if (this.fieldFormatter != null) {
                string3 = this.fieldFormatter.format(string3);
            }
            return string3;
        }
        return "";
    }

    private String getAuthorLastName(AuthorList authorList, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if (authorList.size() > n) {
            AuthorList.Author author = authorList.getAuthor(n);
            if (author.getVon() != null && author.getVon().length() > 0) {
                String string = author.getVon();
                stringBuilder.append(string);
                stringBuilder.append(' ');
            }
            stringBuilder.append(author.getLast());
        }
        return stringBuilder.toString();
    }

    public String insertPageInfo(String string, String string2) {
        String string3 = this.getStringCitProperty("BracketAfter");
        if (string.endsWith(string3)) {
            String string4 = string.substring(0, string.length() - string3.length());
            return string4 + this.getStringCitProperty("PageInfoSeparator") + string2 + string3;
        }
        return string + this.getStringCitProperty("PageInfoSeparator") + string2;
    }

    public boolean isNumberEntries() {
        return (Boolean)this.getProperty("IsNumberEntries");
    }

    public boolean isSortByPosition() {
        return (Boolean)this.getProperty("IsSortByPosition");
    }

    public boolean isItalicCitations() {
        return (Boolean)this.citProperties.get("ItalicCitations");
    }

    public boolean isBoldCitations() {
        return (Boolean)this.citProperties.get("BoldCitations");
    }

    public boolean isFormatCitations() {
        return (Boolean)this.citProperties.get("FormatCitations");
    }

    public boolean isBibtexKeyCiteMarkers() {
        return (Boolean)this.citProperties.get("BibtexKeyCitations");
    }

    public boolean getBooleanCitProperty(String string) {
        return (Boolean)this.citProperties.get(string);
    }

    public int getIntCitProperty(String string) {
        return (Integer)this.citProperties.get(string);
    }

    public String getStringCitProperty(String string) {
        return (String)this.citProperties.get(string);
    }

    public String getCitationCharacterFormat() {
        return (String)this.citProperties.get("CitationCharacterFormat");
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    @Override
    public int compareTo(OOBibStyle oOBibStyle) {
        return this.getName().compareTo(oOBibStyle.getName());
    }

    public boolean equals(Object object) {
        if (object != null) {
            return this.styleFile.equals(((OOBibStyle)object).styleFile);
        }
        return false;
    }
}

