/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.oo;

import com.sun.star.awt.FontSlant;
import com.sun.star.awt.Point;
import com.sun.star.awt.XWindow;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertyContainer;
import com.sun.star.beans.XPropertySet;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNamed;
import com.sun.star.document.XDocumentPropertiesSupplier;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.Locale;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XBookmarksSupplier;
import com.sun.star.text.XDocumentIndexesSupplier;
import com.sun.star.text.XFootnote;
import com.sun.star.text.XReferenceMarksSupplier;
import com.sun.star.text.XSimpleText;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextRangeCompare;
import com.sun.star.text.XTextSection;
import com.sun.star.text.XTextSectionsSupplier;
import com.sun.star.text.XTextViewCursor;
import com.sun.star.text.XTextViewCursorSupplier;
import com.sun.star.uno.Any;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uno.XInterface;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.FieldComparator;
import net.sf.jabref.Globals;
import net.sf.jabref.export.layout.Layout;
import net.sf.jabref.oo.BibtexEntryNotFoundException;
import net.sf.jabref.oo.ComparableMark;
import net.sf.jabref.oo.ConnectionLostException;
import net.sf.jabref.oo.OOBibStyle;
import net.sf.jabref.oo.OOUtil;
import net.sf.jabref.oo.UndefinedBibtexEntry;
import net.sf.jabref.oo.UndefinedCharacterFormatException;
import net.sf.jabref.oo.UndefinedParagraphFormatException;
import net.sf.jabref.oo.sorting.AuthorYearTitleComparator;
import net.sf.jabref.oo.sorting.YearAuthorTitleComparator;

class OOBibBase {
    private static final String BIB_SECTION_NAME = "JR_bib";
    private static final String BIB_SECTION_END_NAME = "JR_bib_end";
    private static final String BIB_CITATION = "JR_cite";
    private final Pattern citePattern = Pattern.compile("JR_cite\\d*_(\\d*)_(.*)");
    private static final int AUTHORYEAR_PAR = 1;
    private static final int AUTHORYEAR_INTEXT = 2;
    private static final int INVISIBLE_CIT = 3;
    static final String DEFAULT_CONNECTION_STRING = "uno:socket,host=localhost,port=2002;urp;StarOffice.ServiceManager";
    final String[] BIB_TYPES = new String[]{"ARTICLE", "BOOK", "BOOKLET", "CONFERENCE", "INBOOK", "INCOLLECTION", "INPROCEEDINGS", "JOURNAL", "MANUAL", "MASTERTHESIS", "MISC", "PHDTHESIS", "PROCEEDINGS", "TECHREPORT", "UNPUBLISHED", "EMAIL", "WWW", "CUSTOM1", "CUSTOM2", "CUSTOM3", "CUSTOM4", "CUSTOM5"};
    private XMultiServiceFactory mxDocFactory = null;
    private XTextDocument mxDoc = null;
    private XText text = null;
    private XDesktop xDesktop = null;
    private XTextViewCursorSupplier xViewCursorSupplier = null;
    private XComponent xCurrentComponent = null;
    private XComponentLoader xComponentLoader = null;
    private XPropertyContainer userProperties = null;
    private XPropertySet propertySet = null;
    private final boolean atEnd;
    private final AuthorYearTitleComparator entryComparator = new AuthorYearTitleComparator();
    private final YearAuthorTitleComparator yearAuthorTitleComparator = new YearAuthorTitleComparator();
    private final HashMap<String, String> uniquefiers = new HashMap();
    private String[] sortedReferenceMarks = null;

    public OOBibBase(String string, boolean bl) throws Exception {
        this.atEnd = bl;
        this.xDesktop = this.simpleBootstrap(string);
        this.selectDocument();
    }

    public boolean isConnectedToDocument() {
        return this.xCurrentComponent != null;
    }

    public String getCurrentDocumentTitle() {
        if (this.mxDoc != null) {
            try {
                return String.valueOf(OOUtil.getProperty(this.mxDoc.getCurrentController().getFrame(), "Title"));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public void selectDocument() throws Exception {
        List<XTextDocument> list = this.getTextDocuments();
        if (list.isEmpty()) {
            throw new Exception("No Writer documents found");
        }
        XTextDocument xTextDocument = list.size() > 1 ? OOUtil.selectComponent(null, this.xDesktop, list) : list.get(0);
        if (xTextDocument == null) {
            return;
        }
        this.xCurrentComponent = UnoRuntime.queryInterface(XComponent.class, (Object)xTextDocument);
        this.mxDoc = xTextDocument;
        XDocumentIndexesSupplier xDocumentIndexesSupplier = UnoRuntime.queryInterface(XDocumentIndexesSupplier.class, (Object)this.xCurrentComponent);
        XModel xModel = UnoRuntime.queryInterface(XModel.class, (Object)this.xCurrentComponent);
        XController xController = xModel.getCurrentController();
        this.xViewCursorSupplier = UnoRuntime.queryInterface(XTextViewCursorSupplier.class, (Object)xController);
        this.text = this.mxDoc.getText();
        this.mxDocFactory = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)this.mxDoc);
        XDocumentPropertiesSupplier xDocumentPropertiesSupplier = UnoRuntime.queryInterface(XDocumentPropertiesSupplier.class, (Object)this.mxDoc);
        this.userProperties = xDocumentPropertiesSupplier.getDocumentProperties().getUserDefinedProperties();
        this.propertySet = UnoRuntime.queryInterface(XPropertySet.class, (Object)this.userProperties);
    }

    private XDesktop simpleBootstrap(String string) throws Exception {
        Object object;
        Object object2;
        Object object3;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (classLoader instanceof URLClassLoader) {
            object3 = (URLClassLoader)classLoader;
            object2 = URLClassLoader.class;
            try {
                object = ((Class)object2).getDeclaredMethod("addURL", URL.class);
                ((Method)object).setAccessible(true);
                ((Method)object).invoke(object3, new File(string).toURI().toURL());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                throw new IOException("Error, could not add URL to system classloader");
            }
        } else {
            System.out.println("Error occured, URLClassLoader expected but " + classLoader.getClass() + " received. Could not continue.");
        }
        object3 = Bootstrap.bootstrap();
        object2 = object3.getServiceManager();
        object = object2.createInstanceWithContext("com.sun.star.frame.Desktop", (XComponentContext)object3);
        XDesktop xDesktop = UnoRuntime.queryInterface(XDesktop.class, object);
        this.xComponentLoader = UnoRuntime.queryInterface(XComponentLoader.class, object);
        return xDesktop;
    }

    private List<XTextDocument> getTextDocuments() throws Exception {
        ArrayList<XTextDocument> arrayList = new ArrayList<XTextDocument>();
        XEnumerationAccess xEnumerationAccess = this.xDesktop.getComponents();
        XEnumeration xEnumeration = xEnumerationAccess.createEnumeration();
        while (xEnumeration.hasMoreElements()) {
            Object object = xEnumeration.nextElement();
            XComponent xComponent = UnoRuntime.queryInterface(XComponent.class, object);
            XTextDocument xTextDocument = UnoRuntime.queryInterface(XTextDocument.class, (Object)xComponent);
            if (xTextDocument == null) continue;
            arrayList.add(xTextDocument);
        }
        return arrayList;
    }

    public void testCustomProperties() throws Exception {
        XDocumentPropertiesSupplier xDocumentPropertiesSupplier = UnoRuntime.queryInterface(XDocumentPropertiesSupplier.class, (Object)this.mxDoc);
        XPropertyContainer xPropertyContainer = xDocumentPropertiesSupplier.getDocumentProperties().getUserDefinedProperties();
        XPropertySet xPropertySet = UnoRuntime.queryInterface(XPropertySet.class, (Object)xPropertyContainer);
        try {
            xPropertyContainer.addProperty("JR_cite_1_Danielsen1987", (short)0, new Any(Type.STRING, (Object)"Brum"));
        }
        catch (Exception exception) {
            System.out.println("property already exists");
        }
        System.out.println(xPropertySet.getPropertyValue("Test").toString());
    }

    public void setCustomProperty(String string, String string2) throws Exception {
        if (this.propertySet.getPropertySetInfo().hasPropertyByName(string)) {
            this.userProperties.removeProperty(string);
        }
        if (string2 != null) {
            this.userProperties.addProperty(string, (short)128, new Any(Type.STRING, (Object)string2));
        }
    }

    public String getCustomProperty(String string) throws Exception {
        if (this.propertySet.getPropertySetInfo().hasPropertyByName(string)) {
            return this.propertySet.getPropertyValue(string).toString();
        }
        return null;
    }

    public void updateSortedReferenceMarks() throws Exception {
        XReferenceMarksSupplier xReferenceMarksSupplier = UnoRuntime.queryInterface(XReferenceMarksSupplier.class, (Object)this.xCurrentComponent);
        XNameAccess xNameAccess = xReferenceMarksSupplier.getReferenceMarks();
        this.sortedReferenceMarks = this.getSortedReferenceMarks(xNameAccess);
    }

    public void insertEntry(BibtexEntry[] bibtexEntryArray, BibtexDatabase bibtexDatabase, List<BibtexDatabase> list, OOBibStyle oOBibStyle, boolean bl, boolean bl2, String string, boolean bl3) throws Exception {
        try {
            XInterface xInterface;
            Object object;
            XTextViewCursor xTextViewCursor = this.xViewCursorSupplier.getViewCursor();
            if (bibtexEntryArray.length > 1) {
                if (oOBibStyle.getBooleanCitProperty("MultiCiteChronological")) {
                    Arrays.sort(bibtexEntryArray, this.yearAuthorTitleComparator);
                } else {
                    Arrays.sort(bibtexEntryArray, this.entryComparator);
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < bibtexEntryArray.length; ++i) {
                object = bibtexEntryArray[i];
                if (i > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(((BibtexEntry)object).getCiteKey());
            }
            String string2 = stringBuilder.toString();
            object = this.getUniqueReferenceMarkName(string2, bl2 ? (bl ? 1 : 2) : 3);
            if (string != null) {
                System.out.println("Storing page info: " + string);
                this.setCustomProperty((String)object, string);
            }
            String string3 = oOBibStyle.isNumberEntries() ? "-" : oOBibStyle.getCitationMarker(bibtexEntryArray, bibtexDatabase, bl, null, null);
            xTextViewCursor.getText().insertString(xTextViewCursor, " ", false);
            if (oOBibStyle.isFormatCitations()) {
                xInterface = UnoRuntime.queryInterface(XPropertySet.class, (Object)xTextViewCursor);
                String string4 = oOBibStyle.getCitationCharacterFormat();
                try {
                    xInterface.setPropertyValue("CharStyleName", string4);
                }
                catch (Throwable throwable) {
                    xTextViewCursor.goLeft((short)1, true);
                    xTextViewCursor.setString("");
                    throw new UndefinedCharacterFormatException(string4);
                }
            }
            xTextViewCursor.goLeft((short)1, false);
            this.insertReferenceMark((String)object, string3, xTextViewCursor, bl2, oOBibStyle);
            xTextViewCursor.collapseToEnd();
            xTextViewCursor.goRight((short)1, false);
            xInterface = xTextViewCursor.getEnd();
            if (bl3) {
                this.updateSortedReferenceMarks();
                this.refreshCiteMarkers(list, oOBibStyle);
                this.rebuildBibTextSection(list, oOBibStyle);
            }
            try {
                xTextViewCursor.gotoRange((XTextRange)xInterface, false);
            }
            catch (Exception exception) {
                System.out.println("Catch");
                exception.printStackTrace();
            }
        }
        catch (DisposedException disposedException) {
            throw new ConnectionLostException(disposedException.getMessage());
        }
    }

    public List<String> refreshCiteMarkers(List<BibtexDatabase> list, OOBibStyle oOBibStyle) throws Exception {
        try {
            return this.refreshCiteMarkersInternal(list, oOBibStyle);
        }
        catch (DisposedException disposedException) {
            throw new ConnectionLostException(disposedException.getMessage());
        }
    }

    public XNameAccess getReferenceMarks() {
        XReferenceMarksSupplier xReferenceMarksSupplier = UnoRuntime.queryInterface(XReferenceMarksSupplier.class, (Object)this.xCurrentComponent);
        return xReferenceMarksSupplier.getReferenceMarks();
    }

    public String[] getJabRefReferenceMarks(XNameAccess xNameAccess) {
        String[] stringArray = xNameAccess.getElementNames();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            if (!this.citePattern.matcher(string).find()) continue;
            arrayList.add(string);
        }
        stringArray = arrayList.toArray(new String[arrayList.size()]);
        return stringArray;
    }

    private List<String> refreshCiteMarkersInternal(List<BibtexDatabase> list, OOBibStyle oOBibStyle) throws Exception {
        int n;
        Object object;
        String[] stringArray5;
        Object object2;
        Object object3;
        int n2;
        Cloneable cloneable;
        String[] stringArray2;
        List<String> list2 = this.findCitedKeys();
        HashMap<String, BibtexDatabase> hashMap = new HashMap<String, BibtexDatabase>();
        Cloneable cloneable2 = this.findCitedEntries(list, list2, hashMap);
        XNameAccess xNameAccess = this.getReferenceMarks();
        if (oOBibStyle.isSortByPosition()) {
            stringArray2 = this.sortedReferenceMarks;
        } else if (oOBibStyle.isNumberEntries()) {
            cloneable = new TreeMap(this.entryComparator);
            for (Map.Entry object4 : cloneable2.entrySet()) {
                cloneable.put(object4.getKey(), object4.getValue());
            }
            cloneable2 = cloneable;
            list2.clear();
            for (BibtexEntry bibtexEntry : cloneable2.keySet()) {
                list2.add(bibtexEntry.getCiteKey());
            }
            stringArray2 = xNameAccess.getElementNames();
        } else {
            stringArray2 = this.sortedReferenceMarks;
        }
        cloneable = new ArrayList();
        for (String string : stringArray2) {
            if (!this.citePattern.matcher(string).find()) continue;
            ((ArrayList)cloneable).add(string);
        }
        stringArray2 = ((ArrayList)cloneable).toArray(new String[((ArrayList)cloneable).size()]);
        HashMap hashMap2 = new HashMap();
        boolean bl = false;
        String[] stringArray3 = new String[stringArray2.length];
        String[][] stringArrayArray = new String[stringArray2.length][];
        String[][] stringArrayArray2 = new String[stringArray2.length][];
        int n3 = oOBibStyle.getIntCitProperty("MinimumGroupingCount");
        int[] nArray = new int[stringArray2.length];
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            int n4;
            object3 = this.citePattern.matcher(stringArray2[n2]);
            if (!((Matcher)object3).find()) continue;
            String arrayList = ((Matcher)object3).group(1);
            nArray[n2] = n4 = Integer.parseInt(arrayList);
            String[] bibtexEntry = ((Matcher)object3).group(2).split(",");
            stringArrayArray2[n2] = bibtexEntry;
            object2 = new BibtexEntry[bibtexEntry.length];
            for (int i = 0; i < ((BibtexEntry[])object2).length; ++i) {
                stringArray5 = hashMap.get(bibtexEntry[i]);
                object2[i] = null;
                if (stringArray5 != null) {
                    object2[i] = OOUtil.createAdaptedEntry(stringArray5.getEntryByKey(bibtexEntry[i]));
                }
                if (object2[i] != null) continue;
                System.out.println("Bibtex key not found : '" + bibtexEntry[i] + '\'');
                System.out.println("Problem with reference mark: '" + stringArray2[n2] + '\'');
                object2[i] = new UndefinedBibtexEntry(bibtexEntry[i]);
            }
            object = new String[bibtexEntry.length];
            if (oOBibStyle.isBibtexKeyCiteMarkers()) {
                StringBuilder bibtexEntryArray = new StringBuilder();
                stringArrayArray[n2] = new String[bibtexEntry.length];
                for (n = 0; n < bibtexEntry.length; ++n) {
                    stringArrayArray[n2][n] = object2[n].getCiteKey();
                    bibtexEntryArray.append(object2[n].getCiteKey());
                    if (n >= bibtexEntry.length - 1) continue;
                    bibtexEntryArray.append(',');
                }
                stringArray5 = bibtexEntryArray.toString();
            } else if (oOBibStyle.isNumberEntries()) {
                if (oOBibStyle.isSortByPosition()) {
                    int[] throwable = new int[bibtexEntry.length];
                    for (n = 0; n < bibtexEntry.length; ++n) {
                        int n5;
                        if (object2[n] instanceof UndefinedBibtexEntry) {
                            throwable[n] = -1;
                            continue;
                        }
                        throwable[n] = n5 + true;
                        if (hashMap2.containsKey(bibtexEntry[n])) {
                            throwable[n] = (Integer)hashMap2.get(bibtexEntry[n]);
                            continue;
                        }
                        hashMap2.put(bibtexEntry[n], throwable[n]);
                        n5 = throwable[n];
                    }
                    stringArray5 = oOBibStyle.getNumCitationMarker(throwable, n3, false);
                    for (n = 0; n < bibtexEntry.length; ++n) {
                        object[n] = oOBibStyle.getNumCitationMarker(new int[]{throwable[n]}, n3, false);
                    }
                } else {
                    int[] nArray2 = this.findCitedEntryIndex(stringArray2[n2], list2);
                    if (nArray2 == null) {
                        throw new BibtexEntryNotFoundException(stringArray2[n2], Globals.lang("Could not resolve BibTeX entry for citation marker '%0'.", stringArray2[n2]));
                    }
                    stringArray5 = oOBibStyle.getNumCitationMarker(nArray2, n3, false);
                    for (n = 0; n < bibtexEntry.length; ++n) {
                        object[n] = oOBibStyle.getNumCitationMarker(new int[]{nArray2[n]}, n3, false);
                    }
                }
            } else {
                if (((BibtexEntry[])object2).length > 1) {
                    if (oOBibStyle.getBooleanCitProperty("MultiCiteChronological")) {
                        Arrays.sort(object2, this.yearAuthorTitleComparator);
                    } else {
                        Arrays.sort(object2, this.entryComparator);
                    }
                    for (int i = 0; i < ((BibtexEntry[])object2).length; ++i) {
                        stringArrayArray2[n2][i] = object2[i].getCiteKey();
                    }
                }
                stringArray5 = oOBibStyle.getCitationMarker((BibtexEntry[])object2, (BibtexDatabase)cloneable2.get(object2), n4 == 1, null, null);
                for (int i = 0; i < ((BibtexEntry[])object2).length; ++i) {
                    object[i] = oOBibStyle.getCitationMarker(object2[i], (BibtexDatabase)cloneable2.get(object2), true, null, -1);
                }
            }
            stringArray3[n2] = stringArray5;
            stringArrayArray[n2] = object;
        }
        this.uniquefiers.clear();
        if (!oOBibStyle.isBibtexKeyCiteMarkers() && !oOBibStyle.isNumberEntries()) {
            HashMap<BibtexEntry[], Object> hashMap3 = new HashMap<BibtexEntry[], Object>();
            object3 = new HashMap();
            for (int i = 0; i < stringArray3.length; ++i) {
                String[] stringArray4 = stringArrayArray[i];
                for (int j = 0; j < stringArray4.length; ++j) {
                    object2 = stringArray4[j];
                    if (!hashMap3.containsKey(object2)) {
                        object = new ArrayList(1);
                        object.add(stringArrayArray2[i][j]);
                        hashMap3.put((BibtexEntry[])object2, object);
                        stringArray5 = new ArrayList(1);
                        stringArray5.add(i);
                        ((HashMap)object3).put(object2, stringArray5);
                        continue;
                    }
                    if (((List)hashMap3.get(object2)).contains(stringArrayArray2[i][j])) continue;
                    ((List)hashMap3.get(object2)).add(stringArrayArray2[i][j]);
                    ((List)((HashMap)object3).get(object2)).add(i);
                }
            }
            for (Map.Entry entry : hashMap3.entrySet()) {
                List list3 = (List)entry.getValue();
                if (list3.size() <= 1) continue;
                int n6 = 97;
                for (String[] stringArray5 : list3) {
                    this.uniquefiers.put((String)stringArray5, String.valueOf((char)n6));
                    ++n6;
                }
            }
            int n7 = oOBibStyle.getIntCitProperty("MaxAuthorsFirst");
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < stringArrayArray2.length; ++i) {
                boolean bl2 = false;
                object = new int[stringArrayArray2[i].length];
                stringArray5 = new String[stringArrayArray2[i].length];
                BibtexEntry[] bibtexEntryArray = new BibtexEntry[stringArrayArray2[i].length];
                for (n = 0; n < stringArrayArray2[i].length; ++n) {
                    BibtexDatabase bibtexDatabase;
                    String string;
                    object[n] = -1;
                    if (n7 > 0) {
                        if (!hashSet.contains(stringArrayArray2[i][n])) {
                            object[n] = n7;
                        }
                        hashSet.add(stringArrayArray2[i][n]);
                    }
                    if ((string = this.uniquefiers.get(stringArrayArray2[i][n])) != null && string.length() >= 0) {
                        bl2 = true;
                        bibtexDatabase = hashMap.get(stringArrayArray2[i][n]);
                        if (bibtexDatabase != null) {
                            bibtexEntryArray[n] = OOUtil.createAdaptedEntry(bibtexDatabase.getEntryByKey(stringArrayArray2[i][n]));
                        }
                        stringArray5[n] = string;
                        continue;
                    }
                    if (object[n] > 0) {
                        bl2 = true;
                        bibtexDatabase = hashMap.get(stringArrayArray2[i][n]);
                        if (bibtexDatabase != null) {
                            bibtexEntryArray[n] = OOUtil.createAdaptedEntry(bibtexDatabase.getEntryByKey(stringArrayArray2[i][n]));
                        }
                        stringArray5[n] = "";
                        continue;
                    }
                    bibtexDatabase = hashMap.get(stringArrayArray2[i][n]);
                    if (bibtexDatabase != null) {
                        bibtexEntryArray[n] = OOUtil.createAdaptedEntry(bibtexDatabase.getEntryByKey(stringArrayArray2[i][n]));
                    }
                    stringArray5[n] = "";
                }
                if (!bl2) continue;
                stringArray3[i] = oOBibStyle.getCitationMarker(bibtexEntryArray, (BibtexDatabase)cloneable2.get(bibtexEntryArray), nArray[i] == 1, stringArray5, (int[])object);
            }
        }
        n2 = this.getBookmarkRange(BIB_SECTION_NAME) != null ? 1 : 0;
        boolean bl3 = oOBibStyle.isFormatCitations();
        for (int i = 0; i < stringArray2.length; ++i) {
            Object object4 = xNameAccess.getByName(stringArray2[i]);
            XTextContent xTextContent = UnoRuntime.queryInterface(XTextContent.class, object4);
            XTextCursor xTextCursor = xTextContent.getAnchor().getText().createTextCursorByRange(xTextContent.getAnchor());
            if (bl3) {
                bl3 = false;
                object = UnoRuntime.queryInterface(XPropertySet.class, (Object)xTextCursor);
                stringArray5 = oOBibStyle.getCitationCharacterFormat();
                try {
                    object.setPropertyValue("CharStyleName", stringArray5);
                }
                catch (Throwable throwable) {
                    throw new UndefinedCharacterFormatException((String)stringArray5);
                }
            }
            this.text.removeTextContent(xTextContent);
            this.insertReferenceMark(stringArray2[i], stringArray3[i], xTextCursor, nArray[i] != 3, oOBibStyle);
            if (n2 == 0 || this.getBookmarkRange(BIB_SECTION_NAME) != null) continue;
            xTextCursor.collapseToEnd();
            OOUtil.insertParagraphBreak(this.text, xTextCursor);
            this.insertBookMark(BIB_SECTION_NAME, xTextCursor);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (BibtexEntry bibtexEntry : cloneable2.keySet()) {
            String string;
            if (!(bibtexEntry instanceof UndefinedBibtexEntry) || arrayList.contains(string = ((UndefinedBibtexEntry)bibtexEntry).getKey())) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private String[] getSortedReferenceMarks(XNameAccess xNameAccess) throws Exception {
        int n;
        XTextViewCursorSupplier xTextViewCursorSupplier = UnoRuntime.queryInterface(XTextViewCursorSupplier.class, (Object)this.mxDoc.getCurrentController());
        XTextViewCursor xTextViewCursor = xTextViewCursorSupplier.getViewCursor();
        XTextRange xTextRange = xTextViewCursor.getStart();
        String[] stringArray = xNameAccess.getElementNames();
        Point[] pointArray = new Point[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            void object;
            String string = stringArray[i];
            XTextContent xTextContent = UnoRuntime.queryInterface(XTextContent.class, xNameAccess.getByName(string));
            XTextRange xTextRange2 = xTextContent.getAnchor();
            if (UnoRuntime.queryInterface(XFootnote.class, (Object)xTextRange2.getText()) != null) {
                XFootnote xFootnote = UnoRuntime.queryInterface(XFootnote.class, (Object)xTextRange2.getText());
                XTextRange xTextRange3 = xFootnote.getAnchor();
            }
            pointArray[i] = this.findPosition(xTextViewCursor, (XTextRange)object);
        }
        TreeSet<ComparableMark> treeSet = new TreeSet<ComparableMark>();
        for (n = 0; n < pointArray.length; ++n) {
            treeSet.add(new ComparableMark(stringArray[n], pointArray[n]));
        }
        n = 0;
        for (ComparableMark comparableMark : treeSet) {
            stringArray[n] = comparableMark.getName();
            ++n;
        }
        xTextViewCursor.gotoRange(xTextRange, false);
        return stringArray;
    }

    public void rebuildBibTextSection(List<BibtexDatabase> list, OOBibStyle oOBibStyle) throws Exception {
        List<String> list2 = this.findCitedKeys();
        HashMap<String, BibtexDatabase> hashMap = new HashMap<String, BibtexDatabase>();
        AbstractMap abstractMap = this.findCitedEntries(list, list2, hashMap);
        String[] stringArray = this.sortedReferenceMarks;
        if (oOBibStyle.isSortByPosition()) {
            abstractMap = this.getSortedEntriesFromSortedRefMarks(stringArray, abstractMap, hashMap);
        } else {
            TreeMap treeMap = new TreeMap(this.entryComparator);
            for (Map.Entry entry : abstractMap.entrySet()) {
                treeMap.put((BibtexEntry)entry.getKey(), entry.getValue());
            }
            abstractMap = treeMap;
        }
        this.clearBibTextSectionContent2();
        this.populateBibTextSection(abstractMap, oOBibStyle);
    }

    private String getUniqueReferenceMarkName(String string, int n) {
        XReferenceMarksSupplier xReferenceMarksSupplier = UnoRuntime.queryInterface(XReferenceMarksSupplier.class, (Object)this.xCurrentComponent);
        XNameAccess xNameAccess = xReferenceMarksSupplier.getReferenceMarks();
        int n2 = 0;
        String string2 = "JR_cite_" + n + '_' + string;
        while (xNameAccess.hasByName(string2)) {
            string2 = BIB_CITATION + n2 + '_' + n + '_' + string;
            ++n2;
        }
        return string2;
    }

    private LinkedHashMap<BibtexEntry, BibtexDatabase> findCitedEntries(List<BibtexDatabase> list, List<String> list2, HashMap<String, BibtexDatabase> hashMap) {
        LinkedHashMap<BibtexEntry, BibtexDatabase> linkedHashMap = new LinkedHashMap<BibtexEntry, BibtexDatabase>();
        for (String string : list2) {
            boolean bl = false;
            for (BibtexDatabase bibtexDatabase : list) {
                BibtexEntry bibtexEntry = bibtexDatabase.getEntryByKey(string);
                if (bibtexEntry == null) continue;
                linkedHashMap.put(OOUtil.createAdaptedEntry(bibtexEntry), bibtexDatabase);
                hashMap.put(string, bibtexDatabase);
                bl = true;
                break;
            }
            if (bl) continue;
            linkedHashMap.put(new UndefinedBibtexEntry(string), null);
        }
        return linkedHashMap;
    }

    private List<String> findCitedKeys() throws NoSuchElementException, WrappedTargetException {
        XReferenceMarksSupplier xReferenceMarksSupplier = UnoRuntime.queryInterface(XReferenceMarksSupplier.class, (Object)this.xCurrentComponent);
        XNameAccess xNameAccess = xReferenceMarksSupplier.getReferenceMarks();
        String[] stringArray = xNameAccess.getElementNames();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            Object object = xNameAccess.getByName(string);
            XTextContent xTextContent = UnoRuntime.queryInterface(XTextContent.class, object);
            List<String> list = this.parseRefMarkName(string);
            for (String string2 : list) {
                if (arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    private LinkedHashMap<BibtexEntry, BibtexDatabase> getSortedEntriesFromSortedRefMarks(String[] stringArray, Map<BibtexEntry, BibtexDatabase> map, HashMap<String, BibtexDatabase> hashMap) throws BibtexEntryNotFoundException {
        LinkedHashMap<BibtexEntry, BibtexDatabase> linkedHashMap = new LinkedHashMap<BibtexEntry, BibtexDatabase>();
        HashMap<BibtexEntry, BibtexEntry> hashMap2 = new HashMap<BibtexEntry, BibtexEntry>();
        for (String string : stringArray) {
            String[] stringArray2;
            Matcher matcher = this.citePattern.matcher(string);
            if (!matcher.find()) continue;
            for (String string2 : stringArray2 = matcher.group(2).split(",")) {
                BibtexDatabase bibtexDatabase = hashMap.get(string2);
                BibtexEntry bibtexEntry = null;
                if (bibtexDatabase != null) {
                    bibtexEntry = bibtexDatabase.getEntryByKey(string2);
                }
                if (bibtexEntry == null) {
                    System.out.println("Bibtex key not found : '" + string2 + "'");
                    System.out.println("Problem with reference mark: '" + string + "'");
                    linkedHashMap.put(new UndefinedBibtexEntry(string2), null);
                    continue;
                }
                BibtexEntry bibtexEntry2 = (BibtexEntry)hashMap2.get(bibtexEntry);
                if (bibtexEntry2 == null) {
                    bibtexEntry2 = OOUtil.createAdaptedEntry(bibtexEntry);
                    hashMap2.put(bibtexEntry, bibtexEntry2);
                }
                if (linkedHashMap.containsKey(bibtexEntry2)) continue;
                linkedHashMap.put(bibtexEntry2, bibtexDatabase);
            }
        }
        return linkedHashMap;
    }

    private Point findPosition(XTextViewCursor xTextViewCursor, XTextRange xTextRange) {
        xTextViewCursor.gotoRange(xTextRange, false);
        return xTextViewCursor.getPosition();
    }

    public List<String> parseRefMarkName(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Matcher matcher = this.citePattern.matcher(string);
        if (matcher.find()) {
            String[] stringArray;
            for (String string2 : stringArray = matcher.group(2).split(",")) {
                if (arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    private int[] findCitedEntryIndex(String string, List<String> list) {
        Matcher matcher = this.citePattern.matcher(string);
        if (matcher.find()) {
            String[] stringArray = matcher.group(2).split(",");
            int[] nArray = new int[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                int n = list.indexOf(stringArray[i]);
                nArray[i] = n != -1 ? 1 + n : -1;
            }
            return nArray;
        }
        return null;
    }

    public String getCitationContext(XNameAccess xNameAccess, String string, int n, int n2, boolean bl) throws Exception {
        int n3;
        Object object = xNameAccess.getByName(string);
        XTextContent xTextContent = UnoRuntime.queryInterface(XTextContent.class, object);
        XTextCursor xTextCursor = xTextContent.getAnchor().getText().createTextCursorByRange(xTextContent.getAnchor());
        String string2 = xTextCursor.getString();
        int n4 = 8;
        for (n3 = 0; n3 < n; ++n3) {
            try {
                xTextCursor.goLeft((short)1, true);
                if (n3 < n - n4 || !Character.isWhitespace(xTextCursor.getString().charAt(0))) continue;
                break;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        n3 = xTextCursor.getString().length();
        int n5 = n3 - string2.length();
        xTextCursor.collapseToStart();
        for (int i = 0; i < n2 + n3; ++i) {
            try {
                String string3;
                xTextCursor.goRight((short)1, true);
                if (i < n2 + n3 - n4 || !Character.isWhitespace((string3 = xTextCursor.getString()).charAt(string3.length() - 1))) continue;
                break;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        String string4 = xTextCursor.getString();
        if (bl) {
            string4 = string4.substring(0, n5) + "<b>" + string2 + "</b>" + string4.substring(n3);
        }
        return string4.trim();
    }

    private void insertFullReferenceAtCursor(XTextCursor xTextCursor, Map<BibtexEntry, BibtexDatabase> map, OOBibStyle oOBibStyle, String string) throws UndefinedParagraphFormatException, Exception {
        if (!oOBibStyle.isSortByPosition()) {
            TreeMap<BibtexEntry, BibtexDatabase> treeMap = new TreeMap<BibtexEntry, BibtexDatabase>(this.entryComparator);
            for (BibtexEntry bibtexEntry : map.keySet()) {
                treeMap.put(bibtexEntry, map.get(bibtexEntry));
            }
            map = treeMap;
        }
        int n = 1;
        for (BibtexEntry bibtexEntry : map.keySet()) {
            if (bibtexEntry instanceof UndefinedBibtexEntry) continue;
            OOUtil.insertParagraphBreak(this.text, xTextCursor);
            if (oOBibStyle.isNumberEntries()) {
                int n2 = oOBibStyle.getIntCitProperty("MinimumGroupingCount");
                OOUtil.insertTextAtCurrentLocation(this.text, xTextCursor, oOBibStyle.getNumCitationMarker(new int[]{n++}, n2, true), false, false, false, false, false, false);
            }
            Layout layout = oOBibStyle.getReferenceFormat(bibtexEntry.getType().getName());
            try {
                layout.setPostFormatter(OOUtil.postformatter);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            OOUtil.insertFullReferenceAtCurrentLocation(this.text, xTextCursor, layout, string, bibtexEntry, map.get(bibtexEntry), this.uniquefiers.get(bibtexEntry.getCiteKey()));
        }
    }

    public void insertFullReferenceAtViewCursor(Map<BibtexEntry, BibtexDatabase> map, OOBibStyle oOBibStyle, String string) throws Exception {
        XTextViewCursor xTextViewCursor = this.xViewCursorSupplier.getViewCursor();
        this.insertFullReferenceAtCursor(xTextViewCursor, map, oOBibStyle, string);
    }

    public void insertMarkedUpTextAtViewCursor(String string, String string2) throws Exception {
        XTextViewCursor xTextViewCursor = this.xViewCursorSupplier.getViewCursor();
        XTextCursor xTextCursor = this.text.createTextCursorByRange(xTextViewCursor.getEnd());
        OOUtil.insertOOFormattedTextAtCurrentLocation(this.text, xTextCursor, string, string2);
    }

    private boolean createBibTextSection(boolean bl) throws Exception {
        XBookmarksSupplier xBookmarksSupplier = UnoRuntime.queryInterface(XBookmarksSupplier.class, (Object)this.mxDoc);
        if (xBookmarksSupplier.getBookmarks().hasByName(BIB_SECTION_NAME)) {
            System.out.println("Found existing JabRef bookmark");
            return true;
        }
        XTextCursor xTextCursor = this.text.createTextCursor();
        if (bl) {
            xTextCursor.gotoEnd(false);
        }
        OOUtil.insertParagraphBreak(this.text, xTextCursor);
        this.insertBookMark(BIB_SECTION_NAME, xTextCursor);
        return false;
    }

    private void createBibTextSection2(boolean bl) throws Exception {
        XTextCursor xTextCursor = this.text.createTextCursor();
        if (bl) {
            xTextCursor.gotoEnd(false);
        }
        OOUtil.insertParagraphBreak(this.text, xTextCursor);
        XNamed xNamed = UnoRuntime.queryInterface(XNamed.class, this.mxDocFactory.createInstance("com.sun.star.text.TextSection"));
        xNamed.setName(BIB_SECTION_NAME);
        XTextContent xTextContent = UnoRuntime.queryInterface(XTextContent.class, (Object)xNamed);
        this.text.insertTextContent(xTextCursor, xTextContent, false);
    }

    private void clearBibTextSectionContent2() throws Exception {
        boolean bl = false;
        XTextSectionsSupplier xTextSectionsSupplier = UnoRuntime.queryInterface(XTextSectionsSupplier.class, (Object)this.mxDoc);
        try {
            XTextSection xTextSection = (XTextSection)((Any)xTextSectionsSupplier.getTextSections().getByName(BIB_SECTION_NAME)).getObject();
            XTextCursor xTextCursor = this.text.createTextCursorByRange(xTextSection.getAnchor());
            xTextCursor.gotoRange(xTextSection.getAnchor(), false);
            xTextCursor.setString("");
        }
        catch (NoSuchElementException noSuchElementException) {
            this.createBibTextSection2(this.atEnd);
        }
    }

    public void clearBibTextSectionContent() throws Exception {
        XTextRange xTextRange;
        XTextRangeCompare xTextRangeCompare = UnoRuntime.queryInterface(XTextRangeCompare.class, (Object)this.text);
        XTextRange xTextRange2 = this.getBookmarkRange(BIB_SECTION_NAME);
        if (xTextRange2 == null) {
            this.createBibTextSection(this.atEnd);
        }
        if ((xTextRange = this.getBookmarkRange(BIB_SECTION_END_NAME)) == null) {
            return;
        }
        XTextCursor xTextCursor = this.text.createTextCursorByRange(xTextRange2.getEnd());
        xTextCursor.goRight((short)1, true);
        boolean bl = true;
        while (bl && xTextRangeCompare.compareRegionEnds(xTextCursor, xTextRange) > 0) {
            bl = xTextCursor.goRight((short)1, true);
        }
        xTextCursor.setString("");
        xTextCursor.collapseToStart();
        this.removeBookMark(BIB_SECTION_END_NAME);
        if (this.getBookmarkRange(BIB_SECTION_NAME) == null) {
            this.insertBookMark(BIB_SECTION_NAME, xTextCursor);
        }
    }

    private void populateBibTextSection(Map<BibtexEntry, BibtexDatabase> map, OOBibStyle oOBibStyle) throws UndefinedParagraphFormatException, Exception {
        XTextSectionsSupplier xTextSectionsSupplier = UnoRuntime.queryInterface(XTextSectionsSupplier.class, (Object)this.mxDoc);
        XTextSection xTextSection = (XTextSection)((Any)xTextSectionsSupplier.getTextSections().getByName(BIB_SECTION_NAME)).getObject();
        XTextCursor xTextCursor = this.text.createTextCursorByRange(xTextSection.getAnchor());
        OOUtil.insertTextAtCurrentLocation(this.text, xTextCursor, (String)oOBibStyle.getProperty("Title"), (String)oOBibStyle.getProperty("ReferenceHeaderParagraphFormat"));
        this.insertFullReferenceAtCursor(xTextCursor, map, oOBibStyle, (String)oOBibStyle.getProperty("ReferenceParagraphFormat"));
        this.insertBookMark(BIB_SECTION_END_NAME, xTextCursor);
    }

    private XTextContent insertBookMark(String string, XTextCursor xTextCursor) throws Exception {
        Object object = this.mxDocFactory.createInstance("com.sun.star.text.Bookmark");
        XNamed xNamed = UnoRuntime.queryInterface(XNamed.class, object);
        xNamed.setName(string);
        XTextContent xTextContent = UnoRuntime.queryInterface(XTextContent.class, object);
        this.text.insertTextContent(xTextCursor, xTextContent, true);
        xTextCursor.collapseToEnd();
        return xTextContent;
    }

    private void insertReferenceMark(String string, String string2, XTextCursor xTextCursor, boolean bl, OOBibStyle oOBibStyle) throws Exception {
        int n;
        String string3;
        String string4 = this.getCustomProperty(string);
        if (string4 != null) {
            string2 = oOBibStyle.insertPageInfo(string2, string4);
        }
        Object object = this.mxDocFactory.createInstance("com.sun.star.text.ReferenceMark");
        XNamed xNamed = UnoRuntime.queryInterface(XNamed.class, object);
        xNamed.setName(string);
        XTextContent xTextContent = UnoRuntime.queryInterface(XTextContent.class, object);
        if (bl) {
            xTextCursor.setString(string2);
            XPropertySet xPropertySet = UnoRuntime.queryInterface(XPropertySet.class, (Object)xTextCursor);
            xPropertySet.setPropertyValue("CharLocale", new Locale("zxx", "", ""));
            if (oOBibStyle.isFormatCitations()) {
                string3 = oOBibStyle.getCitationCharacterFormat();
                try {
                    xPropertySet.setPropertyValue("CharStyleName", string3);
                }
                catch (Throwable throwable) {
                    throw new UndefinedCharacterFormatException(string3);
                }
            }
        } else {
            xTextCursor.setString("");
        }
        xTextCursor.getText().insertTextContent(xTextCursor, xTextContent, true);
        boolean bl2 = oOBibStyle.getBooleanCitProperty("ItalicEtAl");
        if (bl2 && (n = string2.indexOf(string3 = oOBibStyle.getStringCitProperty("EtAlString"))) >= 0) {
            this.italicizeOrBold(xTextCursor, true, n, n + string3.length());
        }
        xTextCursor.collapseToEnd();
    }

    private void italicizeOrBold(XTextCursor xTextCursor, boolean bl, int n, int n2) throws Exception {
        XTextRange xTextRange = xTextCursor.getStart();
        XTextCursor xTextCursor2 = xTextCursor.getText().createTextCursorByRange(xTextRange);
        xTextCursor2.goRight((short)n, false);
        xTextCursor2.goRight((short)(n2 - n), true);
        XPropertySet xPropertySet = UnoRuntime.queryInterface(XPropertySet.class, (Object)xTextCursor2);
        if (bl) {
            xPropertySet.setPropertyValue("CharPosture", FontSlant.ITALIC);
        } else {
            xPropertySet.setPropertyValue("CharWeight", Float.valueOf(150.0f));
        }
    }

    public void testFootnote() throws Exception {
        XTextViewCursor xTextViewCursor = this.xViewCursorSupplier.getViewCursor();
        this.insertFootnote("jabbes", "Cite text", xTextViewCursor);
    }

    private void insertFootnote(String string, String string2, XTextCursor xTextCursor) throws Exception {
        XFootnote xFootnote = UnoRuntime.queryInterface(XFootnote.class, this.mxDocFactory.createInstance("com.sun.star.text.Footnote"));
        xFootnote.setLabel("");
        XPropertySet xPropertySet = UnoRuntime.queryInterface(XPropertySet.class, (Object)xFootnote);
        xPropertySet.setPropertyValue("ReferenceId", string);
        System.out.println(xPropertySet.getPropertyValue("ReferenceId"));
        XTextContent xTextContent = UnoRuntime.queryInterface(XTextContent.class, (Object)xFootnote);
        this.text.insertTextContent(xTextCursor, xTextContent, false);
        XSimpleText xSimpleText = UnoRuntime.queryInterface(XSimpleText.class, (Object)xFootnote);
        XTextRange xTextRange = UnoRuntime.queryInterface(XTextRange.class, (Object)xSimpleText.createTextCursor());
        xSimpleText.insertString(xTextRange, string2, false);
    }

    private void removeBookMark(String string) throws Exception {
        XBookmarksSupplier xBookmarksSupplier = UnoRuntime.queryInterface(XBookmarksSupplier.class, (Object)this.xCurrentComponent);
        if (xBookmarksSupplier.getBookmarks().hasByName(string)) {
            Object object = xBookmarksSupplier.getBookmarks().getByName(string);
            XTextContent xTextContent = UnoRuntime.queryInterface(XTextContent.class, object);
            this.text.removeTextContent(xTextContent);
        }
    }

    private void removeReferenceMark(String string) throws Exception {
        XReferenceMarksSupplier xReferenceMarksSupplier = UnoRuntime.queryInterface(XReferenceMarksSupplier.class, (Object)this.xCurrentComponent);
        if (xReferenceMarksSupplier.getReferenceMarks().hasByName(string)) {
            Object object = xReferenceMarksSupplier.getReferenceMarks().getByName(string);
            XTextContent xTextContent = UnoRuntime.queryInterface(XTextContent.class, object);
            this.text.removeTextContent(xTextContent);
        }
    }

    private XTextRange getBookmarkRange(String string) throws Exception {
        XBookmarksSupplier xBookmarksSupplier = UnoRuntime.queryInterface(XBookmarksSupplier.class, (Object)this.xCurrentComponent);
        XNameAccess xNameAccess = xBookmarksSupplier.getBookmarks();
        if (!xNameAccess.hasByName(string)) {
            return null;
        }
        Object object = xNameAccess.getByName(string);
        XTextContent xTextContent = UnoRuntime.queryInterface(XTextContent.class, object);
        return xTextContent.getAnchor();
    }

    public void printBookmarkNames() throws Exception {
        XBookmarksSupplier xBookmarksSupplier = UnoRuntime.queryInterface(XBookmarksSupplier.class, (Object)this.xCurrentComponent);
        XNameAccess xNameAccess = xBookmarksSupplier.getBookmarks();
        String[] stringArray = xNameAccess.getElementNames();
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println(i + ". " + stringArray[i]);
        }
    }

    public void setFocus() {
        this.xDesktop.getCurrentFrame().getContainerWindow().setFocus();
    }

    public void combineCiteMarkers(List<BibtexDatabase> list, OOBibStyle oOBibStyle) throws Exception {
        XReferenceMarksSupplier xReferenceMarksSupplier = UnoRuntime.queryInterface(XReferenceMarksSupplier.class, (Object)this.xCurrentComponent);
        XNameAccess xNameAccess = xReferenceMarksSupplier.getReferenceMarks();
        String[] stringArray = this.getSortedReferenceMarks(xNameAccess);
        XTextRangeCompare xTextRangeCompare = UnoRuntime.queryInterface(XTextRangeCompare.class, (Object)this.text);
        int n = 0;
        boolean bl = false;
        while (n < stringArray.length - 1) {
            XTextRange xTextRange = UnoRuntime.queryInterface(XTextContent.class, xNameAccess.getByName(stringArray[n])).getAnchor().getEnd();
            XTextRange xTextRange2 = UnoRuntime.queryInterface(XTextContent.class, xNameAccess.getByName(stringArray[n + 1])).getAnchor().getStart();
            if (xTextRange.getText() != xTextRange2.getText()) {
                ++n;
                continue;
            }
            XTextCursor xTextCursor = xTextRange.getText().createTextCursorByRange(xTextRange);
            xTextCursor.goRight((short)1, true);
            boolean bl2 = true;
            while (bl2 && xTextRangeCompare.compareRegionEnds(xTextCursor, xTextRange2) > 0) {
                bl2 = xTextCursor.goRight((short)1, true);
            }
            String string = xTextCursor.getString();
            if (string.indexOf(10) == -1 && string.trim().isEmpty()) {
                Object object;
                Object object2;
                Object object3;
                if (oOBibStyle.isFormatCitations()) {
                    object3 = UnoRuntime.queryInterface(XPropertySet.class, (Object)xTextCursor);
                    object2 = oOBibStyle.getCitationCharacterFormat();
                    try {
                        object3.setPropertyValue("CharStyleName", object2);
                    }
                    catch (Throwable throwable) {
                        throw new UndefinedCharacterFormatException((String)object2);
                    }
                }
                object3 = this.parseRefMarkName(stringArray[n]);
                object3.addAll(this.parseRefMarkName(stringArray[n + 1]));
                this.removeReferenceMark(stringArray[n]);
                this.removeReferenceMark(stringArray[n + 1]);
                object2 = new ArrayList();
                Object object4 = object3.iterator();
                block4: while (object4.hasNext()) {
                    String string2 = (String)object4.next();
                    for (BibtexDatabase object5 : list) {
                        object = object5.getEntryByKey(string2);
                        if (object == null) continue;
                        ((ArrayList)object2).add(OOUtil.createAdaptedEntry((BibtexEntry)object));
                        continue block4;
                    }
                }
                Collections.sort(object2, new FieldComparator("year"));
                object4 = new StringBuilder();
                int n2 = 0;
                Object object6 = ((ArrayList)object2).iterator();
                while (object6.hasNext()) {
                    BibtexEntry bibtexEntry = (BibtexEntry)((Object)object6.next());
                    if (n2 > 0) {
                        ((StringBuilder)object4).append(',');
                    }
                    ((StringBuilder)object4).append(bibtexEntry.getCiteKey());
                    ++n2;
                }
                object6 = ((StringBuilder)object4).toString();
                boolean bl3 = true;
                object = this.getUniqueReferenceMarkName((String)object6, bl3 ? 1 : 2);
                this.insertReferenceMark((String)object, "tmp", xTextCursor, true, oOBibStyle);
                stringArray[n + 1] = object;
                bl = true;
            }
            ++n;
        }
        if (bl) {
            this.updateSortedReferenceMarks();
            this.refreshCiteMarkers(list, oOBibStyle);
        }
    }

    public void testFrameHandling() throws Exception {
        XController xController = this.mxDoc.getCurrentController();
        PropertyValue[] propertyValueArray = new PropertyValue[2];
        propertyValueArray[0] = new PropertyValue();
        propertyValueArray[0].Name = "Model";
        propertyValueArray[0].Value = this.mxDoc.getCurrentController().getModel();
        propertyValueArray[1] = new PropertyValue();
        propertyValueArray[1].Name = "Hidden";
        propertyValueArray[1].Value = true;
        System.out.println("her");
        XComponent xComponent = this.xComponentLoader.loadComponentFromURL("private:factory/swriter", "_blank", 0, propertyValueArray);
        System.out.println("her2");
        XTextDocument xTextDocument = UnoRuntime.queryInterface(XTextDocument.class, (Object)xComponent);
        System.out.println("newDoc = " + xTextDocument);
        XController xController2 = xTextDocument.getCurrentController();
        XFrame xFrame = xController2.getFrame();
        XWindow xWindow = xFrame.getContainerWindow();
        XWindow xWindow2 = xFrame.getComponentWindow();
        xFrame.dispose();
    }
}

