/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.oo;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.EventTableModel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.sun.star.container.XNameAccess;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.oo.OOBibBase;

class CitationManager {
    private final OOBibBase ooBase;
    private final JDialog diag;
    private final EventList<CitEntry> list;
    private JTable table;
    private EventTableModel<CitEntry> tableModel;
    private final JButton ok = new JButton(Globals.lang("Ok"));
    private final JButton cancel = new JButton(Globals.lang("Cancel"));

    public CitationManager(final JabRefFrame jabRefFrame, OOBibBase oOBibBase) throws Exception {
        this.diag = new JDialog(jabRefFrame, Globals.lang("Manage citations"), true);
        this.ooBase = oOBibBase;
        this.list = new BasicEventList<CitEntry>();
        XNameAccess xNameAccess = oOBibBase.getReferenceMarks();
        String[] stringArray = oOBibBase.getJabRefReferenceMarks(xNameAccess);
        for (String string : stringArray) {
            List<String> list = oOBibBase.parseRefMarkName(string);
            this.list.add(new CitEntry(string, list, "<html>..." + oOBibBase.getCitationContext(xNameAccess, string, 30, 30, true) + "...</html>", oOBibBase.getCustomProperty(string)));
        }
        this.tableModel = new EventTableModel<CitEntry>(this.list, new CitEntryFormat());
        this.table = new JTable(this.tableModel);
        this.diag.add((Component)new JScrollPane(this.table), "Center");
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton((JComponent)this.ok);
        buttonBarBuilder.addButton((JComponent)this.cancel);
        buttonBarBuilder.addGlue();
        buttonBarBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.diag.add((Component)buttonBarBuilder.getPanel(), "South");
        this.diag.pack();
        this.diag.setSize(700, 400);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    CitationManager.this.storeSettings();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(jabRefFrame, Globals.lang("Problem modifying citation"));
                }
                CitationManager.this.diag.dispose();
            }
        };
        this.ok.addActionListener(abstractAction);
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CitationManager.this.diag.dispose();
            }
        };
        this.cancel.addActionListener(abstractAction2);
        buttonBarBuilder.getPanel().getInputMap(2).put(Globals.prefs.getKey("Close dialog"), "close");
        buttonBarBuilder.getPanel().getActionMap().put("close", abstractAction2);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(600);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(90);
        this.table.setPreferredScrollableViewportSize(new Dimension(700, 500));
        this.table.addMouseListener(new TableClickListener());
    }

    private void storeSettings() throws Exception {
        for (CitEntry citEntry : this.list) {
            if (!citEntry.pageInfoChanged()) continue;
            this.ooBase.setCustomProperty(citEntry.refMarkName, citEntry.pageInfo);
        }
    }

    public void showDialog() {
        this.diag.setLocationRelativeTo(this.diag.getParent());
        this.diag.setVisible(true);
    }

    class SingleCitDialog {
        final JDialog diag;
        final JTextField pageInfo = new JTextField(20);
        final JLabel title;
        final JButton ok = new JButton(Globals.lang("Ok"));
        final JButton cancel = new JButton(Globals.lang("Cancel"));
        final CitEntry _entry;

        public SingleCitDialog(CitEntry citEntry) {
            this._entry = citEntry;
            this.title = new JLabel(citEntry.context);
            this.pageInfo.setText(citEntry.pageInfo);
            this.diag = new JDialog(CitationManager.this.diag, Globals.lang("Citation"), true);
            DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(new FormLayout("left:pref, 4dlu, left:150dlu", ""));
            defaultFormBuilder.append((Component)this.title, 3);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(Globals.lang("Extra information (e.g. page number)"));
            defaultFormBuilder.append(this.pageInfo);
            defaultFormBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.diag.getContentPane().add((Component)defaultFormBuilder.getPanel(), "Center");
            ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
            buttonBarBuilder.addGlue();
            buttonBarBuilder.addButton((JComponent)this.ok);
            buttonBarBuilder.addButton((JComponent)this.cancel);
            buttonBarBuilder.addGlue();
            buttonBarBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.diag.add((Component)buttonBarBuilder.getPanel(), "South");
            AbstractAction abstractAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SingleCitDialog.this._entry.pageInfo = SingleCitDialog.this.pageInfo.getText().trim().length() > 0 ? SingleCitDialog.this.pageInfo.getText().trim() : null;
                    CitationManager.this.tableModel.fireTableDataChanged();
                    SingleCitDialog.this.diag.dispose();
                }
            };
            this.ok.addActionListener(abstractAction);
            AbstractAction abstractAction2 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SingleCitDialog.this.diag.dispose();
                }
            };
            this.cancel.addActionListener(abstractAction2);
            defaultFormBuilder.getPanel().getInputMap(2).put(Globals.prefs.getKey("Close dialog"), "close");
            defaultFormBuilder.getPanel().getActionMap().put("close", abstractAction2);
        }

        public void showDialog() {
            this.diag.pack();
            this.diag.setLocationRelativeTo(this.diag.getParent());
            this.diag.setVisible(true);
        }
    }

    private class TableClickListener
    extends MouseAdapter {
        private TableClickListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2 && (n = CitationManager.this.table.rowAtPoint(mouseEvent.getPoint())) >= 0) {
                SingleCitDialog singleCitDialog = new SingleCitDialog((CitEntry)CitationManager.this.list.get(n));
                singleCitDialog.showDialog();
            }
        }
    }

    private class CitEntryFormat
    implements TableFormat<CitEntry> {
        private CitEntryFormat() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return Globals.lang("Citation");
                }
            }
            return Globals.lang("Extra information");
        }

        @Override
        public Object getColumnValue(CitEntry citEntry, int n) {
            switch (n) {
                case 0: {
                    return citEntry.context;
                }
            }
            return citEntry.pageInfo != null ? citEntry.pageInfo : "";
        }
    }

    class CitEntry
    implements Comparable<CitEntry> {
        final String refMarkName;
        String pageInfo;
        final String keyString;
        final String context;
        final String origPageInfo;
        final List<String> keys;

        public CitEntry(String string, List<String> list, String string2, String string3) {
            this.refMarkName = string;
            this.keys = list;
            this.context = string2;
            this.pageInfo = string3;
            this.origPageInfo = string3;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < list.size(); ++i) {
                stringBuilder.append(list.get(i));
                if (i >= list.size() - 1) continue;
                stringBuilder.append(", ");
            }
            this.keyString = stringBuilder.toString();
        }

        public boolean pageInfoChanged() {
            if (this.pageInfo != null && this.origPageInfo == null || this.pageInfo == null && this.origPageInfo != null) {
                return true;
            }
            if (this.pageInfo != null) {
                return this.pageInfo.compareTo(this.origPageInfo) != 0;
            }
            return false;
        }

        @Override
        public int compareTo(CitEntry citEntry) {
            return this.refMarkName.compareTo(citEntry.refMarkName);
        }
    }
}

