/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.msbib;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.msbib.MSBibEntry;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MSBibDatabase {
    private Set<MSBibEntry> entries;

    public MSBibDatabase() {
        this.entries = new HashSet<MSBibEntry>();
    }

    public MSBibDatabase(InputStream inputStream) {
        this.importEntries(inputStream);
    }

    public MSBibDatabase(BibtexDatabase bibtexDatabase) {
        Set<String> set = bibtexDatabase.getKeySet();
        this.addEntries(bibtexDatabase, set);
    }

    public MSBibDatabase(BibtexDatabase bibtexDatabase, Set<String> set) {
        if (set == null) {
            set = bibtexDatabase.getKeySet();
        }
        this.addEntries(bibtexDatabase, set);
    }

    public List<BibtexEntry> importEntries(InputStream inputStream) {
        Object object;
        this.entries = new HashSet<MSBibEntry>();
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        Document document = null;
        try {
            object = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = ((DocumentBuilder)object).parse(inputStream);
        }
        catch (Exception exception) {
            System.out.println("Exception caught..." + exception);
            exception.printStackTrace();
        }
        object = "b:";
        NodeList nodeList = document.getElementsByTagName("b:Sources");
        if (nodeList.getLength() == 0) {
            nodeList = document.getElementsByTagName("Sources");
            object = "";
        }
        if (nodeList.getLength() == 0) {
            return arrayList;
        }
        NodeList nodeList2 = ((Element)nodeList.item(0)).getElementsByTagName((String)object + "Source");
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            MSBibEntry mSBibEntry = new MSBibEntry((Element)nodeList2.item(i), (String)object);
            this.entries.add(mSBibEntry);
            arrayList.add(mSBibEntry.getBibtexRepresentation());
        }
        return arrayList;
    }

    private void addEntries(BibtexDatabase bibtexDatabase, Set<String> set) {
        this.entries = new HashSet<MSBibEntry>();
        for (String string : set) {
            BibtexEntry bibtexEntry = bibtexDatabase.getEntryById(string);
            MSBibEntry mSBibEntry = new MSBibEntry(bibtexEntry);
            this.entries.add(mSBibEntry);
        }
    }

    public Document getDOMrepresentation() {
        Document document = null;
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            document = documentBuilder.newDocument();
            Element element = document.createElement("b:Sources");
            element.setAttribute("SelectedStyle", "");
            element.setAttribute("xmlns", "http://schemas.openxmlformats.org/officeDocument/2006/bibliography");
            element.setAttribute("xmlns:b", "http://schemas.openxmlformats.org/officeDocument/2006/bibliography");
            for (MSBibEntry mSBibEntry : this.entries) {
                Element element2 = mSBibEntry.getDOMrepresentation(document);
                element.appendChild(element2);
            }
            document.appendChild(element);
        }
        catch (Exception exception) {
            System.out.println("Exception caught..." + exception);
            exception.printStackTrace();
        }
        return document;
    }
}

