/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.mods;

import java.util.Vector;
import net.sf.jabref.AuthorList;
import net.sf.jabref.export.layout.WSITools;

public class PersonName {
    private String givenName = null;
    private String surname = null;
    private String middleName = null;

    public PersonName() {
    }

    public PersonName(String string) {
        this.parseName(string);
    }

    public PersonName(String string, String string2, String string3) {
        this.givenName = string;
        this.middleName = string2;
        this.surname = string3;
    }

    private void parseName(String string) {
        int n;
        Vector<String> vector = new Vector<String>();
        String string2 = AuthorList.fixAuthor_lastNameFirst(string, false);
        int n2 = string2.indexOf(",");
        WSITools.tokenize(vector, string2.substring(n2 + 1).trim(), " \n\r");
        if (n2 >= 0) {
            vector.add(string2.substring(0, n2));
        }
        if ((n = vector.size()) == 1) {
            this.surname = vector.get(0);
        } else if (n == 2) {
            this.givenName = vector.get(0);
            this.surname = vector.get(1);
        } else {
            this.givenName = vector.get(0);
            this.middleName = "";
            for (int i = 1; i < n - 1; ++i) {
                this.middleName = this.middleName + ' ' + vector.get(i);
            }
            this.middleName = this.middleName.trim();
            this.surname = vector.get(n - 1);
        }
    }

    public String getGivenNames() {
        String string = "";
        if (this.givenName != null) {
            string = string + this.givenName;
        }
        if (this.middleName != null) {
            string = string + ' ' + this.middleName;
        }
        return string;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String string) {
        this.surname = string;
    }

    public String getFirstname() {
        return this.givenName;
    }

    public void setFirstname(String string) {
        this.givenName = string;
    }

    public String getMiddlename() {
        return this.middleName;
    }

    public void setMiddlename(String string) {
        this.middleName = string;
    }

    public String getFullname() {
        String string = "";
        if (this.givenName != null && !this.givenName.isEmpty()) {
            string = string + this.givenName + ' ';
        }
        if (this.middleName != null && !this.middleName.isEmpty()) {
            string = string + this.middleName + ' ';
        }
        if (this.surname != null && !this.surname.isEmpty()) {
            string = string + this.surname;
        }
        return string.trim();
    }

    public String toString() {
        return this.surname;
    }
}

