/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.mods;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class PageNumbers {
    private String freeform = null;
    private int start;
    private int end;

    public PageNumbers(String string) {
        this.parsePageNums(string);
    }

    private void parsePageNums(String string) {
        Pattern pattern = Pattern.compile("\\s*(\\d+)\\s*-{1,2}\\s*(\\d+)\\s*");
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            this.start = Integer.parseInt(matcher.group(1));
            this.end = Integer.parseInt(matcher.group(2));
        } else {
            this.freeform = string;
        }
    }

    public Element getDOMrepresentation(Document document) {
        Element element = document.createElement("extent");
        element.setAttribute("unit", "page");
        if (this.freeform != null) {
            Text text = document.createTextNode(this.freeform);
            element.appendChild(text);
        } else {
            Element element2 = document.createElement("start");
            Element element3 = document.createElement("end");
            element2.appendChild(document.createTextNode("" + this.start));
            element3.appendChild(document.createTextNode("" + this.end));
            element.appendChild(element2);
            element.appendChild(element3);
        }
        return element;
    }

    public String toString(String string) {
        if (this.freeform != null) {
            return this.freeform;
        }
        return this.start + string + this.end;
    }

    public String toString() {
        return this.toString("--");
    }
}

