/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.labelPattern;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.help.HelpAction;
import net.sf.jabref.help.HelpDialog;
import net.sf.jabref.labelPattern.LabelPattern;
import net.sf.jabref.util.StringUtil;

public class LabelPatternPanel
extends JPanel {
    protected final GridBagLayout gbl = new GridBagLayout();
    protected final GridBagConstraints con = new GridBagConstraints();
    private final HelpAction help;
    protected final JTextField defaultPat = new JTextField();
    private final HashMap<String, JTextField> textFields = new HashMap();

    public LabelPatternPanel(HelpDialog helpDialog) {
        this.help = new HelpAction(helpDialog, "LabelPatterns.html", "Help on key patterns");
        this.buildGUI();
    }

    private void buildGUI() {
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setPreferredSize(new Dimension(100, 100));
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jPanel.setLayout(this.gbl);
        this.setLayout(this.gbl);
        JLabel jLabel = new JLabel(Globals.lang("Entry type"));
        Font font = new Font("plain", 1, 12);
        jLabel.setFont(font);
        this.con.gridx = 0;
        this.con.gridy = 0;
        this.con.gridwidth = 1;
        this.con.gridheight = 1;
        this.con.fill = 3;
        this.con.anchor = 17;
        this.con.insets = new Insets(5, 5, 10, 0);
        this.gbl.setConstraints(jLabel, this.con);
        jPanel.add(jLabel);
        JLabel jLabel2 = new JLabel(Globals.lang("Key pattern"));
        jLabel2.setFont(font);
        this.con.gridx = 1;
        this.con.gridy = 0;
        this.con.gridheight = 1;
        this.con.fill = 2;
        this.con.anchor = 17;
        this.con.insets = new Insets(5, 5, 10, 5);
        this.gbl.setConstraints(jLabel2, this.con);
        jPanel.add(jLabel2);
        this.con.gridy = 1;
        this.con.gridx = 0;
        JLabel jLabel3 = new JLabel(Globals.lang("Default pattern"));
        this.gbl.setConstraints(jLabel3, this.con);
        jPanel.add(jLabel3);
        this.con.gridx = 1;
        this.gbl.setConstraints(this.defaultPat, this.con);
        jPanel.add(this.defaultPat);
        this.con.insets = new Insets(5, 5, 10, 5);
        JButton jButton = new JButton(Globals.lang("Default"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LabelPatternPanel.this.defaultPat.setText((String)Globals.prefs.defaults.get("defaultLabelPattern"));
            }
        });
        this.con.gridx = 2;
        int n = 2;
        this.gbl.setConstraints(jButton, this.con);
        jPanel.add(jButton);
        for (String object2 : BibtexEntryType.getAllTypes()) {
            this.textFields.put(object2, this.addEntryType(jPanel, object2, n));
            ++n;
        }
        this.con.fill = 1;
        this.con.gridx = 0;
        this.con.gridy = 1;
        this.con.gridwidth = 3;
        this.con.weightx = 1.0;
        this.con.weighty = 1.0;
        this.gbl.setConstraints(jScrollPane, this.con);
        this.add(jScrollPane);
        this.con.gridwidth = 1;
        this.con.gridx = 1;
        this.con.gridy = 2;
        this.con.fill = 2;
        this.con.weightx = 0.0;
        this.con.weighty = 0.0;
        this.con.anchor = 14;
        this.con.insets = new Insets(0, 5, 0, 5);
        JButton jButton2 = new JButton(GUIGlobals.getImage("helpSmall"));
        jButton2.setToolTipText(Globals.lang("Help on key patterns"));
        this.gbl.setConstraints(jButton2, this.con);
        this.add(jButton2);
        jButton2.addActionListener(this.help);
        JButton jButton3 = new JButton(Globals.lang("Reset all"));
        this.con.gridx = 2;
        this.con.gridy = 2;
        this.con.weightx = 1.0;
        this.con.weighty = 0.0;
        this.con.anchor = 14;
        this.con.insets = new Insets(20, 5, 0, 5);
        this.gbl.setConstraints(jButton3, this.con);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (String string : LabelPatternPanel.this.textFields.keySet()) {
                    JTextField jTextField = (JTextField)LabelPatternPanel.this.textFields.get(string);
                    jTextField.setText("");
                }
                LabelPatternPanel.this.defaultPat.setText((String)Globals.prefs.defaults.get("defaultLabelPattern"));
            }
        });
        this.add(jButton3);
    }

    private JTextField addEntryType(Container container, String string, int n) {
        JLabel jLabel = new JLabel(StringUtil.nCase(string));
        string = string.toLowerCase();
        this.con.gridx = 0;
        this.con.gridy = n;
        this.con.fill = 1;
        this.con.weightx = 0.0;
        this.con.weighty = 0.0;
        this.con.anchor = 17;
        this.con.insets = new Insets(0, 5, 0, 5);
        this.gbl.setConstraints(jLabel, this.con);
        container.add(jLabel);
        JTextField jTextField = new JTextField();
        jTextField.setColumns(15);
        this.con.gridx = 1;
        this.con.fill = 2;
        this.con.weightx = 1.0;
        this.con.weighty = 0.0;
        this.con.anchor = 10;
        this.con.insets = new Insets(0, 5, 0, 5);
        this.gbl.setConstraints(jTextField, this.con);
        container.add(jTextField);
        JButton jButton = new JButton(Globals.lang("Default"));
        this.con.gridx = 2;
        this.con.fill = 1;
        this.con.weightx = 0.0;
        this.con.weighty = 0.0;
        this.con.anchor = 10;
        this.con.insets = new Insets(0, 5, 0, 5);
        this.gbl.setConstraints(jButton, this.con);
        jButton.setActionCommand(string);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTextField jTextField = (JTextField)LabelPatternPanel.this.textFields.get(actionEvent.getActionCommand());
                jTextField.setText("");
            }
        });
        container.add(jButton);
        return jTextField;
    }

    public LabelPattern getLabelPattern() {
        LabelPattern labelPattern = new LabelPattern();
        for (String string : this.textFields.keySet()) {
            String string2 = this.textFields.get(string).getText();
            if ("".equals(string2.trim())) continue;
            labelPattern.addLabelPattern(string, string2);
        }
        String string = this.defaultPat.getText();
        if (!"".equals(string.trim())) {
            labelPattern.setDefaultValue(string);
        }
        return labelPattern;
    }

    public void setValues(LabelPattern labelPattern) {
        for (String string : this.textFields.keySet()) {
            JTextField jTextField = this.textFields.get(string);
            this.setValue(jTextField, string, labelPattern);
        }
        if (labelPattern.getDefaultValue() == null) {
            this.defaultPat.setText("");
        } else {
            this.defaultPat.setText(labelPattern.getDefaultValue().get(0));
        }
    }

    private void setValue(JTextField jTextField, String string, LabelPattern labelPattern) {
        if (labelPattern.isDefaultValue(string)) {
            jTextField.setText("");
        } else {
            jTextField.setText(labelPattern.getValue(string).get(0));
        }
    }
}

