/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.journals;

import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.journals.UndoableUnabbreviator;
import net.sf.jabref.undo.NamedCompound;

public class UnabbreviateAction
extends AbstractWorker {
    private final BasePanel panel;
    private String message = "";

    public UnabbreviateAction(BasePanel basePanel) {
        this.panel = basePanel;
    }

    @Override
    public void init() {
        this.panel.output("Unabbreviating...");
    }

    @Override
    public void run() {
        BibtexEntry[] bibtexEntryArray = this.panel.getSelectedEntries();
        if (bibtexEntryArray == null) {
            return;
        }
        UndoableUnabbreviator undoableUnabbreviator = new UndoableUnabbreviator(Globals.journalAbbrev);
        NamedCompound namedCompound = new NamedCompound("Unabbreviate journal names");
        int n = 0;
        for (BibtexEntry bibtexEntry : bibtexEntryArray) {
            if (undoableUnabbreviator.unabbreviate(this.panel.database(), bibtexEntry, "journal", namedCompound)) {
                ++n;
            }
            if (!undoableUnabbreviator.unabbreviate(this.panel.database(), bibtexEntry, "journaltitle", namedCompound)) continue;
            ++n;
        }
        if (n > 0) {
            namedCompound.end();
            this.panel.undoManager.addEdit(namedCompound);
            this.panel.markBaseChanged();
            this.message = Globals.lang("Unabbreviated %0 journal names.", String.valueOf(n));
        } else {
            this.message = Globals.lang("No journal names could be unabbreviated.");
        }
    }

    @Override
    public void update() {
        this.panel.output(this.message);
    }
}

