/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import javax.swing.JPanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.ImportInspector;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.imports.SPIRESBibtexFilterReader;

public class SPIRESFetcher
implements EntryFetcher {
    private static final String spiresHost = "www-spires.slac.stanford.edu";

    private String constructUrl(String string) {
        String string2;
        try {
            string2 = URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
        return "http://www-spires.slac.stanford.edu/spires/find/hep/www?rawcmd=find+" + string2 + "&FORMAT=WWWBRIEFBIBTEX&SEQUENCE=";
    }

    public static String constructUrlFromSlaccitation(String string) {
        String string2 = "j";
        String string3 = string.replaceAll("^%%CITATION = ", "").replaceAll(";%%$", "");
        if (string3.matches("^\\w*-\\w*[ /].*")) {
            string2 = "eprint";
        }
        try {
            string3 = URLEncoder.encode(string3, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return "http://www-spires.slac.stanford.edu/spires/find/hep/www?rawcmd=find+" + string2 + "+" + string3;
    }

    public static String constructUrlFromEprint(String string) {
        String string2 = string.replaceAll(" [.*]$", "");
        try {
            string2 = URLEncoder.encode(string2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
        return "http://www-spires.slac.stanford.edu/spires/find/hep/www?rawcmd=find+eprint+" + string2;
    }

    private BibtexDatabase importSpiresEntries(String string, OutputPrinter outputPrinter) {
        String string2 = this.constructUrl(string);
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(string2).openConnection();
            httpURLConnection.setRequestProperty("User-Agent", "Jabref");
            InputStream inputStream = httpURLConnection.getInputStream();
            SPIRESBibtexFilterReader sPIRESBibtexFilterReader = new SPIRESBibtexFilterReader(new InputStreamReader(inputStream));
            ParserResult parserResult = BibtexParser.parse(sPIRESBibtexFilterReader);
            return parserResult.getDatabase();
        }
        catch (IOException iOException) {
            outputPrinter.showMessage(Globals.lang("An Exception ocurred while accessing '%0'", string2) + "\n\n" + iOException.toString(), Globals.lang(this.getKeyName()), 0);
        }
        catch (RuntimeException runtimeException) {
            outputPrinter.showMessage(Globals.lang("An Error occurred while fetching from SPIRES source (%0):", new String[]{string2}) + "\n\n" + runtimeException.getMessage(), Globals.lang(this.getKeyName()), 0);
        }
        return null;
    }

    @Override
    public String getHelpPage() {
        return "Spires.html";
    }

    @Override
    public String getKeyName() {
        return "SPIRES";
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }

    @Override
    public String getTitle() {
        return Globals.menuTitle(this.getKeyName());
    }

    public void cancelled() {
    }

    public void done(int n) {
    }

    @Override
    public void stopFetching() {
    }

    @Override
    public boolean processQuery(String string, ImportInspector importInspector, OutputPrinter outputPrinter) {
        try {
            outputPrinter.setStatus("Fetching entries from Spires");
            BibtexDatabase bibtexDatabase = this.importSpiresEntries(string, outputPrinter);
            outputPrinter.setStatus("Adding fetched entries");
            if (bibtexDatabase.getEntryCount() > 0) {
                for (BibtexEntry bibtexEntry : bibtexDatabase.getEntries()) {
                    importInspector.addEntry(bibtexEntry);
                }
            }
        }
        catch (Exception exception) {
            outputPrinter.showMessage(Globals.lang("Error while fetching from Spires: ") + exception.getMessage());
            exception.printStackTrace();
        }
        return true;
    }
}

