/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.IdGenerator;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

public class OvidImporter
extends ImportFormat {
    private static final Pattern ovid_src_pat = Pattern.compile("Source ([ \\w&\\-,:]+)\\.[ ]+([0-9]+)\\(([\\w\\-]+)\\):([0-9]+\\-?[0-9]+?)\\,.*([0-9][0-9][0-9][0-9])");
    private static final Pattern ovid_src_pat_no_issue = Pattern.compile("Source ([ \\w&\\-,:]+)\\.[ ]+([0-9]+):([0-9]+\\-?[0-9]+?)\\,.*([0-9][0-9][0-9][0-9])");
    private static final Pattern ovid_src_pat_2 = Pattern.compile("([ \\w&\\-,]+)\\. Vol ([0-9]+)\\(([\\w\\-]+)\\) ([A-Za-z]+) ([0-9][0-9][0-9][0-9]), ([0-9]+\\-?[0-9]+)");
    private static final Pattern incollection_pat = Pattern.compile("(.+)\\(([0-9][0-9][0-9][0-9])\\)\\. ([ \\w&\\-,:]+)\\.[ ]+\\(pp. ([0-9]+\\-?[0-9]+?)\\).[A-Za-z0-9, ]+pp\\. ([\\w, ]+): ([\\w, ]+)");
    private static final Pattern book_pat = Pattern.compile("\\(([0-9][0-9][0-9][0-9])\\)\\. [A-Za-z, ]+([0-9]+) pp\\. ([\\w, ]+): ([\\w, ]+)");
    private static final Pattern ovidPattern = Pattern.compile("<[0-9]+>");

    @Override
    public String getFormatName() {
        return "Ovid";
    }

    @Override
    public String getCLIId() {
        return "ovid";
    }

    @Override
    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        for (int i = 0; (string = bufferedReader.readLine()) != null && i < 50; ++i) {
            if (!ovidPattern.matcher(string).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream inputStream, OutputPrinter outputPrinter) throws IOException {
        String string;
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() > 0 && string.charAt(0) != ' ') {
                stringBuilder.append("__NEWFIELD__");
            }
            stringBuilder.append(string);
            stringBuilder.append('\n');
        }
        String[] stringArray = stringBuilder.toString().split("<[0-9]+>");
        for (int i = 1; i < stringArray.length; ++i) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String[] stringArray2 = stringArray[i].split("__NEWFIELD__");
            for (String string2 : stringArray2) {
                boolean bl;
                int n = string2.indexOf(10);
                String string3 = string2.substring(0, n).trim();
                String string4 = string2.substring(n).trim();
                boolean bl2 = bl = string3.indexOf("Author") == 0 && !string3.contains("Author Keywords") && !string3.contains("Author e-mail");
                if (!bl && string4.endsWith(".")) {
                    string4 = string4.substring(0, string4.length() - 1);
                }
                if (bl) {
                    hashMap.put("author", string4);
                    continue;
                }
                if (string3.indexOf("Title") == 0) {
                    if ((string4 = string4.replaceAll("\\[.+\\]", "").trim()).endsWith(".")) {
                        string4 = string4.substring(0, string4.length() - 1);
                    }
                    hashMap.put("title", string4);
                    continue;
                }
                if (string3.indexOf("Chapter Title") == 0) {
                    hashMap.put("chaptertitle", string4);
                    continue;
                }
                if (string3.indexOf("Source") == 0) {
                    Matcher matcher = ovid_src_pat.matcher(string4);
                    if (matcher.find()) {
                        hashMap.put("journal", matcher.group(1));
                        hashMap.put("volume", matcher.group(2));
                        hashMap.put("issue", matcher.group(3));
                        hashMap.put("pages", matcher.group(4));
                        hashMap.put("year", matcher.group(5));
                    } else {
                        matcher = ovid_src_pat_no_issue.matcher(string4);
                        if (matcher.find()) {
                            hashMap.put("journal", matcher.group(1));
                            hashMap.put("volume", matcher.group(2));
                            hashMap.put("pages", matcher.group(3));
                            hashMap.put("year", matcher.group(4));
                        } else {
                            matcher = ovid_src_pat_2.matcher(string4);
                            if (matcher.find()) {
                                hashMap.put("journal", matcher.group(1));
                                hashMap.put("volume", matcher.group(2));
                                hashMap.put("issue", matcher.group(3));
                                hashMap.put("month", matcher.group(4));
                                hashMap.put("year", matcher.group(5));
                                hashMap.put("pages", matcher.group(6));
                            } else {
                                matcher = incollection_pat.matcher(string4);
                                if (matcher.find()) {
                                    hashMap.put("editor", matcher.group(1).replaceAll(" \\(Ed\\)", ""));
                                    hashMap.put("year", matcher.group(2));
                                    hashMap.put("booktitle", matcher.group(3));
                                    hashMap.put("pages", matcher.group(4));
                                    hashMap.put("address", matcher.group(5));
                                    hashMap.put("publisher", matcher.group(6));
                                } else {
                                    matcher = book_pat.matcher(string4);
                                    if (matcher.find()) {
                                        hashMap.put("year", matcher.group(1));
                                        hashMap.put("pages", matcher.group(2));
                                        hashMap.put("address", matcher.group(3));
                                        hashMap.put("publisher", matcher.group(4));
                                    }
                                }
                            }
                        }
                    }
                    if (hashMap.get("pages") == null) continue;
                    hashMap.put("pages", hashMap.get("pages").replaceAll("-", "--"));
                    continue;
                }
                if (string3.equals("Abstract")) {
                    hashMap.put("abstract", string4);
                    continue;
                }
                if (!string3.equals("Publication Type")) continue;
                if (string4.contains("Book")) {
                    hashMap.put("entrytype", "book");
                    continue;
                }
                if (string4.contains("Journal")) {
                    hashMap.put("entrytype", "article");
                    continue;
                }
                if (!string4.contains("Conference Paper")) continue;
                hashMap.put("entrytype", "inproceedings");
            }
            Object object = (String)hashMap.get("author");
            if (object != null && ((String)object).contains(" [Ed]")) {
                hashMap.remove("author");
                hashMap.put("editor", ((String)object).replaceAll(" \\[Ed\\]", ""));
            }
            if ((object = (String)hashMap.get("author")) != null) {
                hashMap.put("author", this.fixNames((String)object));
            }
            if ((object = (String)hashMap.get("editor")) != null) {
                hashMap.put("editor", this.fixNames((String)object));
            }
            String string5 = hashMap.containsKey("entrytype") ? (String)hashMap.get("entrytype") : "other";
            hashMap.remove("entrytype");
            if (string5.equals("book") && hashMap.containsKey("chaptertitle")) {
                string5 = "incollection";
                hashMap.put("title", hashMap.remove("chaptertitle"));
            }
            BibtexEntry bibtexEntry = new BibtexEntry(IdGenerator.next(), Globals.getEntryType(string5));
            bibtexEntry.setField(hashMap);
            arrayList.add(bibtexEntry);
        }
        return arrayList;
    }

    private String fixNames(String string) {
        String string2;
        if (string.indexOf(";") > 0) {
            string2 = string.replaceAll("[^\\.A-Za-z,;\\- ]", "").replaceAll(";", " and");
        } else if (string.indexOf("  ") > 0) {
            String[] stringArray = string.split("  ");
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i > 0) {
                    stringBuilder.append(" and ");
                }
                stringBuilder.append(stringArray[i].replaceFirst(" ", ", "));
            }
            string2 = stringBuilder.toString();
        } else {
            string2 = string;
        }
        return AuthorList.fixAuthor_lastNameFirst(string2);
    }
}

