/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HandleDuplicateWarnings;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.MnemonicAwareAction;
import net.sf.jabref.export.AutoSaveManager;
import net.sf.jabref.external.FileLinksUpgradeWarning;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.imports.CheckForNewEntryTypesAction;
import net.sf.jabref.imports.ImportFormatReader;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.imports.PostOpenAction;
import net.sf.jabref.specialfields.SpecialFieldsUtils;
import net.sf.jabref.util.FileBasedLock;
import net.sf.jabref.util.StringUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class OpenDatabaseAction
extends MnemonicAwareAction {
    private static final long serialVersionUID = 1L;
    private static final Log LOGGER = LogFactory.getLog(OpenDatabaseAction.class);
    private final boolean showDialog;
    private final JabRefFrame frame;
    private static final ArrayList<PostOpenAction> postOpenActions = new ArrayList();

    public OpenDatabaseAction(JabRefFrame jabRefFrame, boolean bl) {
        super(GUIGlobals.getImage("open"));
        this.frame = jabRefFrame;
        this.showDialog = bl;
        this.putValue("Name", "Open database");
        this.putValue("AcceleratorKey", Globals.prefs.getKey("Open database"));
        this.putValue("ShortDescription", Globals.lang("Open BibTeX database"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object2;
        ArrayList<File> arrayList = new ArrayList<File>();
        if (this.showDialog) {
            object2 = FileDialogs.getMultipleFiles(this.frame, new File(Globals.prefs.get("workingDirectory")), ".bib", true);
            if (object2 != null) {
                for (String object3 : object2) {
                    if (object3 == null) continue;
                    arrayList.add(new File(object3));
                }
            }
        } else {
            LOGGER.info("Name " + actionEvent.getActionCommand());
            arrayList.add(new File(StringUtil.makeBibtexExtension(actionEvent.getActionCommand())));
        }
        object2 = null;
        int n = arrayList.size();
        int n2 = 0;
        Object object4 = arrayList.iterator();
        block1: while (object4.hasNext()) {
            File file = (File)object4.next();
            for (int i = 0; i < this.frame.getTabbedPane().getTabCount(); ++i) {
                BasePanel basePanel = this.frame.baseAt(i);
                if (basePanel.getFile() == null || !basePanel.getFile().equals(file)) continue;
                object4.remove();
                if (++n2 != n) continue block1;
                object2 = basePanel;
                continue block1;
            }
        }
        if (arrayList.size() > 0) {
            object4 = Collections.unmodifiableList(arrayList);
            JabRefExecutorService.INSTANCE.execute(new Runnable((List)object4){
                final /* synthetic */ List val$theFiles;
                {
                    this.val$theFiles = list;
                }

                @Override
                public void run() {
                    for (File file : this.val$theFiles) {
                        OpenDatabaseAction.this.openIt(file, true);
                    }
                }
            });
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                this.frame.getFileHistory().newFile(file.getPath());
            }
        } else if (object2 != null) {
            this.frame.output(Globals.lang("File '%0' is already open.", object2.getFile().getPath()));
            this.frame.getTabbedPane().setSelectedComponent((Component)object2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void openIt(File file, boolean bl) {
        int n;
        if (file == null) return;
        if (!file.exists()) return;
        File file2 = file;
        this.frame.output(Globals.lang("Opening") + ": '" + file.getPath() + "'");
        boolean bl2 = false;
        boolean bl3 = AutoSaveManager.newerAutoSaveExists(file);
        if (bl3 && !Globals.prefs.getBoolean("promptBeforeUsingAutosave")) {
            file2 = AutoSaveManager.getAutoSaveFile(file);
            bl2 = true;
        } else if (bl3 && (n = JOptionPane.showConfirmDialog(null, "<html>" + Globals.lang("An autosave file was found for this database. This could indicate ") + Globals.lang("that JabRef didn't shut down cleanly last time the file was used.") + "<br>" + Globals.lang("Do you want to recover the database from the autosave file?") + "</html>", Globals.lang("Recover from autosave"), 0)) == 0) {
            file2 = AutoSaveManager.getAutoSaveFile(file);
            bl2 = true;
        }
        n = 0;
        while (n == 0) {
            Object object;
            ParserResult parserResult;
            String string = file.getPath();
            Globals.prefs.put("workingDirectory", file.getPath());
            String string2 = Globals.prefs.get("defaultEncoding");
            if (FileBasedLock.hasLockFile(file)) {
                long l = FileBasedLock.getLockFileTimeStamp(file);
                if (l != -1L && System.currentTimeMillis() - l > 60000L) {
                    int n2 = JOptionPane.showConfirmDialog(null, "<html>" + Globals.lang("Error opening file") + " '" + string + "'. " + Globals.lang("File is locked by another JabRef instance.") + "<p>" + Globals.lang("Do you want to override the file lock?"), Globals.lang("File locked"), 0);
                    if (n2 != 0) return;
                    FileBasedLock.deleteLockFile(file);
                } else if (!FileBasedLock.waitForFileLock(file, 10)) {
                    JOptionPane.showMessageDialog(null, Globals.lang("Error opening file") + " '" + string + "'. " + Globals.lang("File is locked by another JabRef instance."), Globals.lang("Error"), 0);
                    return;
                }
            }
            String string3 = null;
            try {
                parserResult = OpenDatabaseAction.loadDatabase(file2, string2);
            }
            catch (Exception exception) {
                string3 = exception.getMessage();
                parserResult = null;
            }
            if (parserResult == null || parserResult == ParserResult.INVALID_FORMAT) {
                JOptionPane.showMessageDialog(null, Globals.lang("Error opening file") + " '" + string + "'", Globals.lang("Error"), 0);
                object = "<html>" + string3 + "<p>" + (bl2 ? Globals.lang("Error opening autosave of '%0'. Trying to load '%0' instead.", file.getName()) : "") + "</html>";
                JOptionPane.showMessageDialog(null, object, Globals.lang("Error opening file"), 0);
                if (!bl2) return;
                bl2 = false;
                file2 = file;
                continue;
            }
            n = 1;
            object = this.addNewDatabase(parserResult, file, bl);
            if (bl2) {
                ((BasePanel)object).markNonUndoableBaseChanged();
            }
            ParserResult parserResult2 = parserResult;
            SwingUtilities.invokeLater(new Runnable((BasePanel)object, parserResult2){
                final /* synthetic */ BasePanel val$panel;
                final /* synthetic */ ParserResult val$prf;
                {
                    this.val$panel = basePanel;
                    this.val$prf = parserResult;
                }

                @Override
                public void run() {
                    OpenDatabaseAction.performPostOpenActions(this.val$panel, this.val$prf, true);
                }
            });
        }
    }

    public static void performPostOpenActions(BasePanel basePanel, ParserResult parserResult, boolean bl) {
        for (PostOpenAction postOpenAction : postOpenActions) {
            if (!postOpenAction.isActionNecessary(parserResult)) continue;
            if (bl) {
                basePanel.frame().getTabbedPane().setSelectedComponent(basePanel);
            }
            postOpenAction.performAction(basePanel, parserResult);
        }
    }

    public BasePanel addNewDatabase(ParserResult parserResult, File file, boolean bl) {
        Object object;
        String string = file.getPath();
        BibtexDatabase bibtexDatabase = parserResult.getDatabase();
        MetaData metaData = parserResult.getMetaData();
        if (parserResult.hasWarnings()) {
            object = parserResult.warnings();
            JabRefExecutorService.INSTANCE.execute(new Runnable((String[])object, file){
                final /* synthetic */ String[] val$wrns;
                final /* synthetic */ File val$file;
                {
                    this.val$wrns = stringArray;
                    this.val$file = file;
                }

                @Override
                public void run() {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < this.val$wrns.length; ++i) {
                        stringBuilder.append(i + 1).append(". ").append(this.val$wrns[i]).append("\n");
                    }
                    if (stringBuilder.length() > 0) {
                        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                    }
                    JOptionPane.showMessageDialog(OpenDatabaseAction.this.frame, stringBuilder.toString(), Globals.lang("Warnings") + " (" + this.val$file.getName() + ")", 2);
                }
            });
        }
        object = new BasePanel(this.frame, bibtexDatabase, file, metaData, parserResult.getEncoding());
        SwingUtilities.invokeLater(new OpenItSwingHelper((BasePanel)object, file, bl));
        this.frame.output(Globals.lang("Opened database") + " '" + string + "' " + Globals.lang("with") + " " + bibtexDatabase.getEntryCount() + " " + Globals.lang("entries") + ".");
        return object;
    }

    public static ParserResult loadDatabase(File file, String string) throws IOException {
        Reader reader;
        Object object;
        Reader reader2 = ImportFormatReader.getUTF8Reader(file);
        String string2 = OpenDatabaseAction.checkForEncoding(reader2);
        reader2.close();
        if (string2 == null) {
            object = ImportFormatReader.getUTF16Reader(file);
            string2 = OpenDatabaseAction.checkForEncoding((Reader)object);
            ((Reader)object).close();
        }
        if (string2 != null) {
            try {
                reader = ImportFormatReader.getReader(file, string2);
                string = string2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                reader = ImportFormatReader.getReader(file, string);
            }
        } else {
            reader = ImportFormatReader.getReader(file, string);
        }
        object = new BibtexParser(reader);
        ParserResult parserResult = ((BibtexParser)object).parse();
        parserResult.setEncoding(string);
        parserResult.setFile(file);
        if (SpecialFieldsUtils.keywordSyncEnabled()) {
            for (BibtexEntry bibtexEntry : parserResult.getDatabase().getEntries()) {
                SpecialFieldsUtils.syncSpecialFieldsFromKeywords(bibtexEntry, null);
            }
            LOGGER.info(Globals.lang("Synchronized special fields based on keywords"));
        }
        if (!parserResult.getMetaData().isGroupTreeValid()) {
            parserResult.addWarning(Globals.lang("Group tree could not be parsed. If you save the BibTeX database, all groups will be lost."));
        }
        return parserResult;
    }

    private static String checkForEncoding(Reader reader) {
        String string = null;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            boolean bl = true;
            int n = 0;
            int n2 = 0;
            block2: while (bl) {
                int n3 = reader.read();
                if (n == 0 && (n3 == 37 || Character.isWhitespace((char)n3))) {
                    ++n2;
                } else {
                    stringBuilder.append((char)n3);
                    if (n3 == "This file was created with JabRef".charAt(n)) {
                        ++n;
                    } else {
                        bl = false;
                    }
                }
                if (n != "This file was created with JabRef".length()) continue;
                bl = false;
                while (reader.read() != 10) {
                }
                while ((n3 = reader.read()) == 37 || Character.isWhitespace((char)n3)) {
                }
                if ((char)n3 != "Encoding: ".charAt(0)) continue;
                for (int i = 1; i < "Encoding: ".length(); ++i) {
                    if (reader.read() != "Encoding: ".charAt(i)) continue block2;
                }
                StringBuilder stringBuilder2 = new StringBuilder();
                while ((n3 = reader.read()) != 10) {
                    stringBuilder2.append((char)n3);
                }
                string = stringBuilder2.toString();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string != null ? string.trim() : null;
    }

    static {
        postOpenActions.add(new CheckForNewEntryTypesAction());
        postOpenActions.add(new FileLinksUpgradeWarning());
        postOpenActions.add(new HandleDuplicateWarnings());
    }

    class OpenItSwingHelper
    implements Runnable {
        final BasePanel bp;
        final boolean raisePanel;
        final File file;

        OpenItSwingHelper(BasePanel basePanel, File file, boolean bl) {
            this.bp = basePanel;
            this.raisePanel = bl;
            this.file = file;
        }

        @Override
        public void run() {
            OpenDatabaseAction.this.frame.addTab(this.bp, this.file, this.raisePanel);
        }
    }
}

