/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.util.ArrayList;
import java.util.TreeSet;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.IdGenerator;
import net.sf.jabref.imports.HTMLConverter;
import net.sf.jabref.imports.ImportFormatReader;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

class MedlineHandler
extends DefaultHandler {
    private static final HTMLConverter htmlConverter = new HTMLConverter();
    private final ArrayList<BibtexEntry> bibitems = new ArrayList();
    private boolean inTitle = false;
    private boolean inYear = false;
    private boolean inJournal = false;
    private boolean inMonth = false;
    private boolean inVolume = false;
    private boolean inAuthorList = false;
    private boolean inAuthor = false;
    private boolean inLastName = false;
    private boolean inSuffix = false;
    private boolean inInitials = false;
    private boolean inMedlinePgn = false;
    private boolean inIssue = false;
    private boolean inPubDate = false;
    private boolean inUrl = false;
    private boolean inForename = false;
    private boolean inAbstractText = false;
    private boolean inMedlineDate = false;
    private boolean inPubMedID = false;
    private boolean inDescriptorName = false;
    private boolean inDoi = false;
    private boolean inPii = false;
    private boolean inPmc = false;
    private boolean inAffiliation = false;
    private boolean inMeshHeader = false;
    private boolean inQualifierName = false;
    private boolean inLanguage = false;
    private boolean inPst = false;
    private String title = "";
    private String journal = "";
    private String author = "";
    private String lastName = "";
    private String suffix = "";
    private String year = "";
    private String forename = "";
    private String abstractText = "";
    private String affiliation = "";
    private String month = "";
    private String volume = "";
    private String lastname = "";
    private String initials = "";
    private String number = "";
    private String page = "";
    private String MedlineDate = "";
    String series = "";
    String editor = "";
    String booktitle = "";
    String type = "article";
    String key = "";
    String address = "";
    private String pubmedid = "";
    private String doi = "";
    private String pii = "";
    private String pmc = "";
    private String majorTopic = "";
    private String minorTopics = "";
    private String language = "";
    private String pst = "";
    private final ArrayList<String> authors = new ArrayList();
    private final TreeSet<String> descriptors = new TreeSet();
    int rowNum = 0;
    private static final String KEYWORD_SEPARATOR = "; ";

    public ArrayList<BibtexEntry> getItems() {
        return this.bibitems;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (!string2.equals("PubmedArticle")) {
            if (string2.equals("ArticleTitle")) {
                this.inTitle = true;
                this.title = "";
            } else if (string2.equals("PubDate")) {
                this.inPubDate = true;
            } else if (string2.equals("Year") && this.inPubDate) {
                this.inYear = true;
            } else if (string2.equals("MedlineDate") && this.inPubDate) {
                this.inMedlineDate = true;
            } else if (string2.equals("MedlineTA")) {
                this.inJournal = true;
                this.journal = "";
            } else if (string2.equals("Month") && this.inPubDate) {
                this.inMonth = true;
            } else if (string2.equals("Volume")) {
                this.inVolume = true;
            } else if (string2.equals("Language")) {
                this.inLanguage = true;
            } else if (string2.equals("PublicationStatus")) {
                this.inPst = true;
            } else if (string2.equals("AuthorList")) {
                this.inAuthorList = true;
                this.authors.clear();
            } else if (string2.equals("MeshHeading")) {
                this.inMeshHeader = true;
                this.majorTopic = "";
                this.minorTopics = "";
            } else if (string2.equals("DescriptorName")) {
                this.inDescriptorName = true;
            } else if (string2.equals("QualifierName")) {
                this.inQualifierName = true;
            } else if (string2.equals("Author")) {
                this.inAuthor = true;
                this.author = "";
            } else if (string2.equals("CollectiveName")) {
                this.inForename = true;
                this.forename = "";
            } else if (string2.equals("PMID")) {
                if (this.pubmedid.length() == 0) {
                    this.inPubMedID = true;
                    this.pubmedid = "";
                }
            } else if (string2.equals("LastName")) {
                this.inLastName = true;
                this.lastName = "";
            } else if (string2.equals("ForeName") || string2.equals("FirstName")) {
                this.inForename = true;
                this.forename = "";
            } else if (string2.equals("Suffix")) {
                this.inSuffix = true;
                this.suffix = "";
            } else if (string2.equals("Issue")) {
                this.inIssue = true;
            } else if (string2.equals("MedlinePgn")) {
                this.inMedlinePgn = true;
            } else if (string2.equals("URL")) {
                this.inUrl = true;
            } else if (string2.equals("Initials")) {
                this.inInitials = true;
            } else if (string2.equals("AbstractText")) {
                this.inAbstractText = true;
            } else if (string2.equals("ArticleId")) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String string4 = attributes.getValue(i);
                    if (string4.equals("doi")) {
                        this.inDoi = true;
                        continue;
                    }
                    if (string4.equals("pii")) {
                        this.inPii = true;
                        continue;
                    }
                    if (!string4.equals("pmc")) continue;
                    this.inPmc = true;
                }
            } else if (string2.equals("Affiliation")) {
                this.inAffiliation = true;
            }
        }
    }

    private String join(Object[] objectArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(objectArray[0].toString());
        for (int i = 1; i < objectArray.length; ++i) {
            stringBuilder.append(string);
            stringBuilder.append(objectArray[i].toString());
        }
        return stringBuilder.toString();
    }

    String makeBibtexString() {
        String string = "article{,\n author = { " + this.author + " },\n title = { " + this.title + "},\n journal ={ " + this.journal + "},\n year = " + this.year + "},\n volume = { " + this.volume + "},\n number = { " + this.number + "},\n pages = { " + this.fixPageRange(this.page) + "},\n abstract = { " + this.abstractText + "},\n}";
        return string;
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if (string2.equals("PubmedArticle")) {
            Object object;
            if (this.year.equals("") && !this.MedlineDate.equals("")) {
                this.year = this.MedlineDate.substring(0, 4);
            }
            StringBuilder stringBuilder = new StringBuilder();
            Object object2 = this.descriptors.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                stringBuilder.append((String)object);
                if (!object2.hasNext()) continue;
                stringBuilder.append(KEYWORD_SEPARATOR);
            }
            object2 = stringBuilder.toString();
            object = new BibtexEntry(IdGenerator.next(), Globals.getEntryType("article"));
            if (!this.author.equals("")) {
                ((BibtexEntry)object).setField("author", htmlConverter.formatUnicode(ImportFormatReader.expandAuthorInitials(this.author)));
                this.author = "";
            }
            if (!this.title.equals("")) {
                ((BibtexEntry)object).setField("title", htmlConverter.formatUnicode(this.title));
            }
            if (!this.journal.equals("")) {
                ((BibtexEntry)object).setField("journal", this.journal);
            }
            if (!this.year.equals("")) {
                ((BibtexEntry)object).setField("year", this.year);
            }
            if (!this.page.equals("")) {
                ((BibtexEntry)object).setField("pages", this.fixPageRange(this.page));
            }
            if (!this.volume.equals("")) {
                ((BibtexEntry)object).setField("volume", this.volume);
            }
            if (!this.language.equals("")) {
                ((BibtexEntry)object).setField("language", this.language);
            }
            if (!this.pst.equals("")) {
                ((BibtexEntry)object).setField("medline-pst", this.pst);
            }
            if (!this.abstractText.equals("")) {
                ((BibtexEntry)object).setField("abstract", this.abstractText.replaceAll("%", "\\\\%"));
            }
            if (!((String)object2).equals("")) {
                ((BibtexEntry)object).setField("keywords", (String)object2);
            }
            if (!this.month.equals("")) {
                ((BibtexEntry)object).setField("month", this.month);
            }
            if (!this.number.equals("")) {
                ((BibtexEntry)object).setField("number", this.number);
            }
            if (!this.doi.equals("")) {
                ((BibtexEntry)object).setField("doi", this.doi);
                ((BibtexEntry)object).setField("url", "http://dx.doi.org/" + this.doi);
            }
            if (!this.pii.equals("")) {
                ((BibtexEntry)object).setField("pii", this.pii);
            }
            if (!this.pmc.equals("")) {
                ((BibtexEntry)object).setField("pmc", this.pmc);
            }
            if (!this.affiliation.equals("")) {
                ((BibtexEntry)object).setField("institution", this.affiliation.replaceAll("#", "\\\\#"));
            }
            if (!this.pubmedid.equals("")) {
                ((BibtexEntry)object).setField("pmid", this.pubmedid);
            }
            this.bibitems.add((BibtexEntry)object);
            this.abstractText = "";
            this.author = "";
            this.title = "";
            this.journal = "";
            object2 = "";
            this.doi = "";
            this.pii = "";
            this.pmc = "";
            this.year = "";
            this.forename = "";
            this.lastName = "";
            this.suffix = "";
            this.abstractText = "";
            this.affiliation = "";
            this.pubmedid = "";
            this.majorTopic = "";
            this.minorTopics = "";
            this.month = "";
            this.volume = "";
            this.language = "";
            this.pst = "";
            this.lastname = "";
            this.suffix = "";
            this.initials = "";
            this.number = "";
            this.page = "";
            String string4 = "";
            String string5 = "";
            this.MedlineDate = "";
            this.descriptors.clear();
        } else if (string2.equals("ArticleTitle")) {
            this.inTitle = false;
        } else if (string2.equals("PubDate")) {
            this.inPubDate = false;
        } else if (string2.equals("Year")) {
            this.inYear = false;
        } else if (string2.equals("PMID")) {
            this.inPubMedID = false;
        } else if (string2.equals("MedlineDate")) {
            this.inMedlineDate = false;
        } else if (string2.equals("MedlineTA")) {
            this.inJournal = false;
        } else if (string2.equals("Month")) {
            this.inMonth = false;
        } else if (string2.equals("Volume")) {
            this.inVolume = false;
        } else if (string2.equals("Language")) {
            this.inLanguage = false;
        } else if (string2.equals("PublicationStatus")) {
            this.inPst = false;
        } else if (string2.equals("AuthorList")) {
            this.author = this.join(this.authors.toArray(), " and ");
            this.inAuthorList = false;
        } else if (string2.equals("Author")) {
            if (this.forename.length() == 3 && this.forename.charAt(1) == ' ') {
                this.forename = this.initials;
            }
            this.author = this.lastname.indexOf(" ") > 0 ? "{" + this.lastname + "}" : this.lastname;
            if (this.suffix.length() > 0) {
                this.author = this.author + ", " + this.suffix;
            }
            if (this.forename.length() > 0) {
                this.author = this.author + ", " + this.forename;
            }
            this.authors.add(this.author);
            this.inAuthor = false;
            this.forename = "";
            this.initials = "";
            this.lastname = "";
            this.suffix = "";
        } else if (string2.equals("DescriptorName")) {
            this.inDescriptorName = false;
        } else if (string2.equals("QualifierName")) {
            this.inQualifierName = false;
        } else if (string2.equals("MeshHeading")) {
            this.inMeshHeader = false;
            if (this.minorTopics.equals("")) {
                this.descriptors.add(this.majorTopic);
            } else {
                this.descriptors.add(this.majorTopic + ", " + this.minorTopics);
            }
        } else if (string2.equals("LastName")) {
            this.inLastName = false;
        } else if (string2.equals("Suffix")) {
            this.inSuffix = false;
        } else if (string2.equals("ForeName") || string2.equals("FirstName")) {
            this.inForename = false;
        } else if (string2.equals("Issue")) {
            this.inIssue = false;
        } else if (string2.equals("MedlinePgn")) {
            this.inMedlinePgn = false;
        } else if (string2.equals("URL")) {
            this.inUrl = false;
        } else if (string2.equals("Initials")) {
            this.inInitials = false;
        } else if (string2.equals("AbstractText")) {
            this.inAbstractText = false;
        } else if (string2.equals("Affiliation")) {
            this.inAffiliation = false;
        } else if (string2.equals("ArticleId")) {
            if (this.inDoi) {
                this.inDoi = false;
            } else if (this.inPii) {
                this.inPii = false;
            } else if (this.inPmc) {
                this.inPmc = false;
            }
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        if (this.inTitle) {
            this.title = this.title + new String(cArray, n, n2);
        } else if (this.inYear) {
            this.year = this.year + new String(cArray, n, n2);
        } else if (this.inJournal) {
            this.journal = this.journal + new String(cArray, n, n2);
        } else if (this.inMonth) {
            this.month = this.month + new String(cArray, n, n2);
        } else if (this.inVolume) {
            this.volume = this.volume + new String(cArray, n, n2);
        } else if (this.inLanguage) {
            this.language = this.language + new String(cArray, n, n2).toLowerCase();
        } else if (this.inPst) {
            this.pst = this.pst + new String(cArray, n, n2);
        } else if (this.inLastName) {
            this.lastname = this.lastname + new String(cArray, n, n2);
        } else if (this.inSuffix) {
            this.suffix = this.suffix + new String(cArray, n, n2);
        } else if (this.inInitials) {
            this.initials = this.initials + new String(cArray, n, n2);
        } else if (this.inIssue) {
            this.number = this.number + new String(cArray, n, n2);
        } else if (this.inMedlinePgn) {
            this.page = this.page + new String(cArray, n, n2);
        } else if (bl2) {
            String string = "";
            string = string + new String(cArray, n, n2);
        } else if (bl) {
            String string = "";
            string = string + new String(cArray, n, n2);
        } else if (this.inPubMedID) {
            this.pubmedid = new String(cArray, n, n2);
        } else if (this.inQualifierName) {
            if (!this.minorTopics.equals("")) {
                this.minorTopics = this.minorTopics + "/";
            }
            this.minorTopics = this.minorTopics + new String(cArray, n, n2);
        } else if (this.inDescriptorName) {
            this.majorTopic = new String(cArray, n, n2);
        } else if (this.inForename) {
            this.forename = this.forename + new String(cArray, n, n2);
        } else if (this.inAbstractText) {
            this.abstractText = this.abstractText + new String(cArray, n, n2);
        } else if (this.inMedlineDate) {
            this.MedlineDate = this.MedlineDate + new String(cArray, n, n2);
        } else if (this.inDoi) {
            this.doi = new String(cArray, n, n2);
        } else if (this.inPii) {
            this.pii = new String(cArray, n, n2);
        } else if (this.inPmc) {
            this.pmc = new String(cArray, n, n2);
        } else if (this.inAffiliation) {
            this.affiliation = new String(cArray, n, n2);
        }
    }

    private String fixPageRange(String string) {
        int n;
        int n2 = string.indexOf(45);
        if (n2 < 0) {
            return string;
        }
        String string2 = string.substring(0, n2).trim();
        String string3 = string.substring(n2 + 1).trim();
        int n3 = string3.length();
        if (n3 < (n = string2.length())) {
            string3 = string2.substring(0, n - n3) + string3;
        }
        return string2 + "--" + string3;
    }
}

