/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;
import net.sf.jabref.util.CaseChangers;
import net.sf.jabref.util.MonthUtil;
import net.sf.jabref.util.StringUtil;

public class IsiImporter
extends ImportFormat {
    private static final Pattern isiPattern = Pattern.compile("FN ISI Export Format|VR 1.|PY \\d{4}");
    private static final Pattern subsupPattern = Pattern.compile("/(sub|sup)\\s+(.*?)\\s*/");

    @Override
    public String getFormatName() {
        return "ISI";
    }

    @Override
    public String getCLIId() {
        return "isi";
    }

    @Override
    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        for (int i = 0; (string = bufferedReader.readLine()) != null && i < 50; ++i) {
            if (!isiPattern.matcher(string).find()) continue;
            return true;
        }
        return false;
    }

    public static void processSubSup(HashMap<String, String> hashMap) {
        String[] stringArray;
        for (String string : stringArray = new String[]{"title", "abstract", "review", "notes"}) {
            if (!hashMap.containsKey(string)) continue;
            Matcher matcher = subsupPattern.matcher(hashMap.get(string));
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                String string2 = matcher.group(2);
                if ((string2 = string2.replaceAll("\\$", "\\\\\\\\\\\\\\$")).length() > 1) {
                    string2 = "{" + string2 + "}";
                }
                if (matcher.group(1).equals("sub")) {
                    matcher.appendReplacement(stringBuffer, "\\$_" + string2 + "\\$");
                    continue;
                }
                matcher.appendReplacement(stringBuffer, "\\$^" + string2 + "\\$");
            }
            matcher.appendTail(stringBuffer);
            hashMap.put(string, stringBuffer.toString());
        }
    }

    private static void processCapitalization(HashMap<String, String> hashMap) {
        String[] stringArray;
        for (String string : stringArray = new String[]{"title", "journal", "publisher"}) {
            String string2;
            if (!hashMap.containsKey(string) || !(string2 = hashMap.get(string)).toUpperCase().equals(string2)) continue;
            string2 = CaseChangers.TITLE.changeCase(string2);
            hashMap.put(string, string2);
        }
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream inputStream, OutputPrinter outputPrinter) throws IOException {
        Object object;
        String string;
        if (inputStream == null) {
            throw new IOException("No stream given.");
        }
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() < 3) continue;
            if (string.substring(0, 3).equals("PT ")) {
                stringBuilder.append("::").append(string);
                continue;
            }
            object = string.substring(0, 3).trim();
            if (((String)object).length() == 2) {
                stringBuilder.append(" ## ");
                stringBuilder.append(string);
                continue;
            }
            stringBuilder.append("EOLEOL");
            stringBuilder.append(string.trim());
        }
        object = stringBuilder.toString().split("::");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string2 : object) {
            String string3;
            String[] stringArray = string2.split(" ## ");
            if (stringArray.length == 0) {
                stringArray = string2.split("\n");
            }
            String string4 = "";
            String string5 = "";
            String string6 = "";
            hashMap.clear();
            for (String string7 : stringArray) {
                if (string7.length() <= 2) continue;
                string3 = string7.substring(0, 2);
                String string8 = string7.substring(3);
                if (string8.startsWith(" - ")) {
                    string8 = string8.substring(3);
                }
                string8 = string8.trim();
                if (string3.equals("PT")) {
                    string5 = string8.startsWith("J") ? "article" : string8;
                    string4 = "article";
                    continue;
                }
                if (string3.equals("TY")) {
                    if ("JOUR".equals(string8)) {
                        string4 = "article";
                        continue;
                    }
                    if (!"CONF".equals(string8)) continue;
                    string4 = "inproceedings";
                    continue;
                }
                if (string3.equals("JO")) {
                    hashMap.put("booktitle", string8);
                    continue;
                }
                if (string3.equals("AU")) {
                    String string10 = IsiImporter.isiAuthorsConvert(string8.replaceAll("EOLEOL", " and "));
                    if (hashMap.get("author") != null) {
                        string10 = hashMap.get("author") + " and " + string10;
                    }
                    hashMap.put("author", string10);
                    continue;
                }
                if (string3.equals("TI")) {
                    hashMap.put("title", string8.replaceAll("EOLEOL", " "));
                    continue;
                }
                if (string3.equals("SO") || string3.equals("JA")) {
                    hashMap.put("journal", string8.replaceAll("EOLEOL", " "));
                    continue;
                }
                if (string3.equals("ID") || string3.equals("KW")) {
                    string8 = string8.replaceAll("EOLEOL", " ");
                    String string9 = hashMap.get("keywords");
                    string9 = string9 != null && !string9.contains(string8) ? string9 + ", " + string8 : string8;
                    hashMap.put("keywords", string9);
                    continue;
                }
                if (string3.equals("AB")) {
                    hashMap.put("abstract", string8.replaceAll("EOLEOL", " "));
                    continue;
                }
                if (string3.equals("BP") || string3.equals("BR") || string3.equals("SP")) {
                    string6 = string8;
                    continue;
                }
                if (string3.equals("EP")) {
                    int n = string8.indexOf(32);
                    if (n != -1 && string8.substring(0, n).trim().length() > 0) {
                        string8 = string8.substring(0, n);
                    }
                    string6 = string6 + "--" + string8;
                    continue;
                }
                if (string3.equals("PS")) {
                    string6 = IsiImporter.parsePages(string8);
                    continue;
                }
                if (string3.equals("AR")) {
                    string6 = string8;
                    continue;
                }
                if (string3.equals("IS")) {
                    hashMap.put("number", string8);
                    continue;
                }
                if (string3.equals("PY")) {
                    hashMap.put("year", string8);
                    continue;
                }
                if (string3.equals("VL")) {
                    hashMap.put("volume", string8);
                    continue;
                }
                if (string3.equals("PU")) {
                    hashMap.put("publisher", string8);
                    continue;
                }
                if (string3.equals("DI")) {
                    hashMap.put("doi", string8);
                    continue;
                }
                if (string3.equals("PD")) {
                    String string10 = IsiImporter.parseMonth(string8);
                    if (string10 == null) continue;
                    hashMap.put("month", string10);
                    continue;
                }
                if (string3.equals("DT")) {
                    string4 = string8;
                    if (string4.equals("Review")) {
                        string4 = "article";
                        continue;
                    }
                    if (string4.startsWith("Article") || string4.startsWith("Journal") || string5.equals("article")) {
                        string4 = "article";
                        continue;
                    }
                    string4 = "misc";
                    continue;
                }
                if (string3.equals("CR")) {
                    hashMap.put("CitedReferences", string8.replaceAll("EOLEOL", " ; ").trim());
                    continue;
                }
                if (string3.equals("ER") || string3.equals("EF") || string3.equals("VR") || string3.equals("FN")) continue;
                hashMap.put(string3, string8);
            }
            if (!"".equals(string6)) {
                hashMap.put("pages", string6);
            }
            if (hashMap.size() == 0) continue;
            BibtexEntry bibtexEntry = new BibtexEntry("__ID", Globals.getEntryType(string4));
            ArrayList<String> arrayList2 = new ArrayList<String>();
            for (String string11 : hashMap.keySet()) {
                string3 = (String)hashMap.get(string11);
                if (string3 != null && string3.trim().length() != 0) continue;
                arrayList2.add(string11);
            }
            for (Object object2 : arrayList2) {
                hashMap.remove(object2);
            }
            IsiImporter.processSubSup(hashMap);
            IsiImporter.processCapitalization(hashMap);
            bibtexEntry.setField(hashMap);
            arrayList.add(bibtexEntry);
        }
        return arrayList;
    }

    private static String parsePages(String string) {
        int n = string.lastIndexOf("-");
        return string.substring(0, n) + "--" + string.substring(n + 1);
    }

    public static String parseMonth(String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.split("\\s|\\-")) {
            MonthUtil.Month month = MonthUtil.getMonthByShortName(string2.toLowerCase());
            if (!month.isValid()) continue;
            return month.bibtexFormat;
        }
        for (String string2 : stringArray) {
            try {
                int n = Integer.parseInt(string2);
                MonthUtil.Month month = MonthUtil.getMonthByNumber(n);
                if (!month.isValid()) continue;
                return month.bibtexFormat;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String isiAuthorConvert(String string) {
        String[] stringArray = string.split(",");
        if (stringArray.length != 2) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = stringArray[0].trim();
        stringBuilder.append(string2).append(", ");
        String string3 = stringArray[1].trim();
        String[] stringArray2 = string3.split("\\s+");
        for (int i = 0; i < stringArray2.length; ++i) {
            string3 = stringArray2[i];
            if (string3.toUpperCase().equals(string3)) {
                string3 = string3.replaceAll("\\.", "");
                for (int j = 0; j < string3.length(); ++j) {
                    stringBuilder.append(string3.charAt(j)).append(".");
                    if (j >= string3.length() - 1) continue;
                    stringBuilder.append(" ");
                }
            } else {
                stringBuilder.append(string3);
            }
            if (i >= stringArray2.length - 1) continue;
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    private static String[] isiAuthorsConvert(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = IsiImporter.isiAuthorConvert(stringArray[i]);
        }
        return stringArray2;
    }

    public static String isiAuthorsConvert(String string) {
        String[] stringArray = IsiImporter.isiAuthorsConvert(string.split(" and |;"));
        return StringUtil.join(stringArray, " and ");
    }
}

