/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

public class InspecImporter
extends ImportFormat {
    @Override
    public String getFormatName() {
        return "INSPEC";
    }

    @Override
    public String getCLIId() {
        return "inspec";
    }

    @Override
    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        Pattern pattern = Pattern.compile("Record.*INSPEC.*");
        while ((string = bufferedReader.readLine()) != null) {
            if (!pattern.matcher(string).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<BibtexEntry> importEntries(InputStream inputStream, OutputPrinter outputPrinter) throws IOException {
        String string;
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        StringBuilder stringBuilder = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() < 2) continue;
            if (string.indexOf("Record") == 0) {
                stringBuilder.append("__::__").append(string);
                continue;
            }
            stringBuilder.append("__NEWFIELD__").append(string);
        }
        bufferedReader.close();
        String[] stringArray = stringBuilder.toString().split("__::__");
        String string2 = "";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string3 : stringArray) {
            if (string3.indexOf("Record") != 0) continue;
            hashMap.clear();
            String[] stringArray2 = string3.split("__NEWFIELD__");
            for (String string4 : stringArray2) {
                String string5 = string4.substring(0, 2);
                String string6 = string4.substring(5);
                if (string5.equals("TI")) {
                    hashMap.put("title", string6);
                    continue;
                }
                if (string5.equals("PY")) {
                    hashMap.put("year", string6);
                    continue;
                }
                if (string5.equals("AU")) {
                    hashMap.put("author", AuthorList.fixAuthor_lastNameFirst(string6.replaceAll(",-", ", ").replaceAll(";", " and ")));
                    continue;
                }
                if (string5.equals("AB")) {
                    hashMap.put("abstract", string6);
                    continue;
                }
                if (string5.equals("ID")) {
                    hashMap.put("keywords", string6);
                    continue;
                }
                if (string5.equals("SO")) {
                    int n = string6.indexOf(".");
                    if (n < 0) continue;
                    String string7 = string6.substring(0, n);
                    hashMap.put("journal", string7.replaceAll("-", " "));
                    string6 = string6.substring(n);
                    n = string6.indexOf(";");
                    if (n < 5) continue;
                    String string8 = string6.substring(n - 5, n);
                    hashMap.put("year", string8);
                    string6 = string6.substring(n);
                    n = string6.indexOf(":");
                    if (n < 0) continue;
                    String string9 = string6.substring(n + 1).trim();
                    hashMap.put("pages", string9);
                    hashMap.put("volume", string6.substring(1, n));
                    continue;
                }
                if (!string5.equals("RT")) continue;
                string2 = (string6 = string6.trim()).equals("Journal-Paper") ? "article" : (string6.equals("Conference-Paper") || string6.equals("Conference-Paper; Journal-Paper") ? "inproceedings" : string6.replaceAll(" ", ""));
            }
            BibtexEntry bibtexEntry = new BibtexEntry("__ID", Globals.getEntryType(string2));
            bibtexEntry.setField(hashMap);
            arrayList.add(bibtexEntry);
        }
        return arrayList;
    }
}

