/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.BibtexString;
import net.sf.jabref.DuplicateCheck;
import net.sf.jabref.DuplicateResolverDialog;
import net.sf.jabref.EntryMarker;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.MetaData;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.gui.ImportInspectionDialog;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.labelPattern.LabelPatternUtil;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableInsertEntry;
import net.sf.jabref.undo.UndoableRemoveEntry;
import net.sf.jabref.util.Util;

public class ImportMenuItem
extends JMenuItem
implements ActionListener {
    private final JabRefFrame frame;
    private final boolean openInNew;
    private final ImportFormat importer;
    private IOException importError = null;

    public ImportMenuItem(JabRefFrame jabRefFrame, boolean bl) {
        this(jabRefFrame, bl, null);
    }

    public ImportMenuItem(JabRefFrame jabRefFrame, boolean bl, ImportFormat importFormat) {
        super(importFormat != null ? importFormat.getFormatName() : Globals.lang("Autodetect format"));
        this.importer = importFormat;
        this.frame = jabRefFrame;
        this.openInNew = bl;
        this.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        MyWorker myWorker = new MyWorker();
        myWorker.init();
        myWorker.getWorker().run();
        myWorker.getCallBack().update();
    }

    public void automatedImport(String[] stringArray) {
        MyWorker myWorker = new MyWorker();
        myWorker.fileOk = true;
        myWorker.filenames = stringArray;
        myWorker.getWorker().run();
        myWorker.getCallBack().update();
    }

    private ParserResult mergeImportResults(List<ImportFormatReader.UnknownFormatImport> list) {
        BibtexDatabase bibtexDatabase = new BibtexDatabase();
        ParserResult parserResult = null;
        boolean bl = false;
        for (ImportFormatReader.UnknownFormatImport unknownFormatImport : list) {
            ParserResult parserResult2;
            if (unknownFormatImport == null) continue;
            if ("BibTeX".equals(unknownFormatImport.format)) {
                parserResult2 = unknownFormatImport.parserResult;
                boolean bl2 = bl = bl || parserResult2.getDatabase().getEntryCount() > 0 || parserResult2.getDatabase().getStringCount() > 0;
                if (parserResult == null) {
                    parserResult = parserResult2;
                }
                for (BibtexEntry bibtexEntry : parserResult2.getDatabase().getEntries()) {
                    bibtexDatabase.insertEntry(bibtexEntry);
                }
                for (BibtexString bibtexString : parserResult2.getDatabase().getStringValues()) {
                    try {
                        bibtexDatabase.addString((BibtexString)bibtexString.clone());
                    }
                    catch (KeyCollisionException keyCollisionException) {}
                }
                continue;
            }
            parserResult2 = unknownFormatImport.parserResult;
            Collection<BibtexEntry> collection = parserResult2.getDatabase().getEntries();
            bl |= collection.size() > 0;
            Util.setAutomaticFields(collection, Globals.prefs.getBoolean("overwriteOwner"), Globals.prefs.getBoolean("overwriteTimeStamp"), !this.openInNew && Globals.prefs.getBoolean("markImportedEntries"));
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                BibtexEntry bibtexEntry = (BibtexEntry)iterator.next();
                bibtexDatabase.insertEntry(bibtexEntry);
            }
        }
        if (!bl) {
            return null;
        }
        if (list.size() == 1 && parserResult != null) {
            return parserResult;
        }
        return new ParserResult(bibtexDatabase, new MetaData(), new HashMap<String, BibtexEntryType>());
    }

    class MyWorker
    extends AbstractWorker {
        String[] filenames = null;
        ParserResult bibtexResult = null;
        boolean fileOk = false;

        MyWorker() {
        }

        @Override
        public void init() {
            ImportMenuItem.this.importError = null;
            this.filenames = FileDialogs.getMultipleFiles(ImportMenuItem.this.frame, new File(Globals.prefs.get("workingDirectory")), ImportMenuItem.this.importer != null ? ImportMenuItem.this.importer.getExtensions() : null, true);
            if (this.filenames != null && this.filenames.length > 0) {
                ImportMenuItem.this.frame.block();
                ImportMenuItem.this.frame.output(Globals.lang("Starting import"));
                this.fileOk = true;
                Globals.prefs.put("workingDirectory", this.filenames[0]);
            }
        }

        @Override
        public void run() {
            Object object;
            if (!this.fileOk) {
                return;
            }
            ArrayList<ImportFormatReader.UnknownFormatImport> arrayList = new ArrayList<ImportFormatReader.UnknownFormatImport>();
            for (String stringArray : this.filenames) {
                try {
                    if (ImportMenuItem.this.importer != null) {
                        object = new ParserResult(Globals.importFormatReader.importFromFile(ImportMenuItem.this.importer, stringArray, (OutputPrinter)ImportMenuItem.this.frame));
                        arrayList.add(new ImportFormatReader.UnknownFormatImport(ImportMenuItem.this.importer.getFormatName(), (ParserResult)object));
                        continue;
                    }
                    ImportMenuItem.this.frame.output(Globals.lang("Importing in unknown format") + "...");
                    arrayList.add(Globals.importFormatReader.importUnknownFormat(stringArray));
                }
                catch (IOException iOException) {
                    ImportMenuItem.this.importError = iOException;
                }
            }
            this.bibtexResult = ImportMenuItem.this.mergeImportResults(arrayList);
            for (ImportFormatReader.UnknownFormatImport unknownFormatImport : arrayList) {
                ParserResult parserResult;
                if (unknownFormatImport == null || !(parserResult = unknownFormatImport.parserResult).hasWarnings() || !Globals.prefs.getBoolean("displayKeyWarningDialogAtStartup") || !parserResult.hasWarnings()) continue;
                String[] stringArray = parserResult.warnings();
                object = new StringBuilder();
                for (int i = 0; i < stringArray.length; ++i) {
                    ((StringBuilder)object).append(i + 1).append(". ").append(stringArray[i]).append("\n");
                }
                if (((StringBuilder)object).length() > 0) {
                    ((StringBuilder)object).deleteCharAt(((StringBuilder)object).length() - 1);
                }
                JOptionPane.showMessageDialog(ImportMenuItem.this.frame, ((StringBuilder)object).toString(), Globals.lang("Warnings"), 2);
            }
        }

        @Override
        public void update() {
            if (!this.fileOk) {
                return;
            }
            if (this.bibtexResult != null) {
                if (!ImportMenuItem.this.openInNew) {
                    BasePanel basePanel = (BasePanel)ImportMenuItem.this.frame.getTabbedPane().getSelectedComponent();
                    BibtexDatabase bibtexDatabase = basePanel.database();
                    if (Globals.prefs.getBoolean("useImportInspectionDialog") && (Globals.prefs.getBoolean("useImportInspectionDialogForSingle") || this.bibtexResult.getDatabase().getEntryCount() > 1)) {
                        ImportInspectionDialog importInspectionDialog = new ImportInspectionDialog(ImportMenuItem.this.frame, basePanel, BibtexFields.DEFAULT_INSPECTION_FIELDS, Globals.lang("Import"), ImportMenuItem.this.openInNew);
                        importInspectionDialog.addEntries(this.bibtexResult.getDatabase().getEntries());
                        importInspectionDialog.entryListComplete();
                        Util.placeDialog(importInspectionDialog, ImportMenuItem.this.frame);
                        importInspectionDialog.setVisible(true);
                        importInspectionDialog.toFront();
                    } else {
                        boolean bl = Globals.prefs.getBoolean("generateKeysAfterInspection");
                        NamedCompound namedCompound = new NamedCompound(Globals.lang("Import entries"));
                        if (Globals.prefs.getBoolean("unmarkAllEntriesBeforeImporting")) {
                            for (BibtexEntry bibtexEntry : bibtexDatabase.getEntries()) {
                                EntryMarker.unmarkEntry(bibtexEntry, true, bibtexDatabase, namedCompound);
                            }
                        }
                        for (BibtexEntry bibtexEntry : this.bibtexResult.getDatabase().getEntries()) {
                            try {
                                boolean bl2 = true;
                                BibtexEntry bibtexEntry2 = DuplicateCheck.containsDuplicate(bibtexDatabase, bibtexEntry);
                                if (bibtexEntry2 != null) {
                                    int n = DuplicateResolverDialog.resolveDuplicateInImport(ImportMenuItem.this.frame, bibtexEntry2, bibtexEntry);
                                    if (n == 2) {
                                        bl2 = false;
                                    }
                                    if (n == 1) {
                                        bibtexDatabase.removeEntry(bibtexEntry2.getId());
                                        namedCompound.addEdit(new UndoableRemoveEntry(bibtexDatabase, bibtexEntry2, basePanel));
                                    }
                                }
                                if (!bl2) continue;
                                bibtexDatabase.insertEntry(bibtexEntry);
                                if (bl) {
                                    LabelPatternUtil.makeLabel(this.bibtexResult.getMetaData(), bibtexDatabase, bibtexEntry);
                                }
                                namedCompound.addEdit(new UndoableInsertEntry(bibtexDatabase, bibtexEntry, basePanel));
                            }
                            catch (KeyCollisionException keyCollisionException) {
                                keyCollisionException.printStackTrace();
                            }
                        }
                        namedCompound.end();
                        if (namedCompound.hasEdits()) {
                            basePanel.undoManager.addEdit(namedCompound);
                            basePanel.markBaseChanged();
                        }
                    }
                } else {
                    ImportMenuItem.this.frame.addTab(this.bibtexResult.getDatabase(), this.bibtexResult.getFile(), this.bibtexResult.getMetaData(), Globals.prefs.get("defaultEncoding"), true);
                    ImportMenuItem.this.frame.output(Globals.lang("Imported entries") + ": " + this.bibtexResult.getDatabase().getEntryCount());
                }
            } else if (ImportMenuItem.this.importer == null) {
                ImportMenuItem.this.frame.output(Globals.lang("Could not find a suitable import format."));
            } else if (ImportMenuItem.this.importError != null) {
                JOptionPane.showMessageDialog(ImportMenuItem.this.frame, ImportMenuItem.this.importError.getMessage(), Globals.lang("Import failed"), 0);
            } else {
                JOptionPane.showMessageDialog(ImportMenuItem.this.frame, Globals.lang("No entries found. Please make sure you are using the correct import filter."), Globals.lang("Import failed"), 0);
            }
            ImportMenuItem.this.frame.unblock();
        }
    }
}

